/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRDesignLevelType;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPhysicalObject;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRModelObject
extends MIRElement {
    protected transient String aComment = "";
    protected transient byte aDesignLevel = 0;
    protected transient String aPhysicalName = "";
    protected transient String aStereotype = "";
    protected transient MIRObjectCollection<MIRBusinessRule> associatedBusinessRules = null;
    protected transient MIRObjectCollection<MIRPhysicalObject> associatedPhysicalObjects = null;
    protected transient MIRObjectCollection<MIRPresentationElement> presentationPresentationElements = null;
    protected transient MIRObjectCollection<MIRSynonym> synonyms = null;
    private static MIRMetaClass metaClass = MIRModelObject.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 59;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)59)) {
            this.setComment(((MIRModelObject)mIR_Object).getComment());
            this.setDesignLevel(((MIRModelObject)mIR_Object).getDesignLevel());
            this.setPhysicalName(((MIRModelObject)mIR_Object).getPhysicalName());
            this.setStereotype(((MIRModelObject)mIR_Object).getStereotype());
        }
    }

    public final void setComment(String string) {
        this.aComment = string == null ? "" : string;
    }

    public final String getComment() {
        return this.aComment;
    }

    public final void setDesignLevel(byte by) {
        this.aDesignLevel = by;
    }

    public final byte getDesignLevel() {
        return this.aDesignLevel;
    }

    public final void setPhysicalName(String string) {
        if (string == null) {
            string = "";
        }
        if (!this.aPhysicalName.equals(string)) {
            String string2 = this.aPhysicalName.isEmpty() ? this.aName : this.aPhysicalName;
            this.aPhysicalName = string;
            if (!this._isValidName()) {
                this.aPhysicalName = string2;
                throw new IllegalArgumentException(MIRSDK.CANNOT_RENAME.getMessage("PhysicalName", this.getPath(), string2, string));
            }
            this._rename(string2);
        }
    }

    public final String getPhysicalName() {
        return this.aPhysicalName;
    }

    public final void setStereotype(String string) {
        this.aStereotype = string == null ? "" : string;
    }

    public final String getStereotype() {
        return this.aStereotype;
    }

    protected MIRObjectCollection<MIRBusinessRule> getAssociatedBusinessRuleCollection() {
        this.associatedBusinessRules = MIRObjectCollections.get(this.associatedBusinessRules, MIRSdkCollection.Type.OBJECT);
        return this.associatedBusinessRules;
    }

    public SortedSet<MIRBusinessRule> getAssociatedBusinessRules() {
        return MIRObjectCollections.sortedSet(this.associatedBusinessRules);
    }

    public final void addAssociatedBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelObject", "AssociatedBusinessRule"));
        }
        if (mIRBusinessRule._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelObject", "AssociatedBusinessRule"));
        }
        if (this.associatedBusinessRules != null && this.associatedBusinessRules.contains(mIRBusinessRule)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelObject", "AssociatedBusinessRule"));
        }
        this.getAssociatedBusinessRuleCollection().add(mIRBusinessRule);
        mIRBusinessRule.getModelObjectCollection().add(this);
    }

    public final int getAssociatedBusinessRuleCount() {
        if (this.associatedBusinessRules != null) {
            return this.associatedBusinessRules.size();
        }
        return 0;
    }

    public final boolean containsAssociatedBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule != null && this.associatedBusinessRules != null) {
            return this.associatedBusinessRules.contains(mIRBusinessRule);
        }
        return false;
    }

    public final MIRBusinessRule getAssociatedBusinessRule(String string) {
        if (this.associatedBusinessRules != null) {
            return this.associatedBusinessRules.get(string);
        }
        return null;
    }

    public final Iterator<MIRBusinessRule> getAssociatedBusinessRuleIterator() {
        if (this.associatedBusinessRules != null) {
            return this.associatedBusinessRules.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeAssociatedBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule != null && this.associatedBusinessRules != null && this.associatedBusinessRules.remove(mIRBusinessRule)) {
            mIRBusinessRule.modelObjects.remove(this);
            if (mIRBusinessRule.modelObjects.isEmpty()) {
                mIRBusinessRule.modelObjects = null;
            }
            if (this.associatedBusinessRules.isEmpty()) {
                this.associatedBusinessRules = null;
            }
            return true;
        }
        return false;
    }

    public final void removeAssociatedBusinessRules() {
        if (this.associatedBusinessRules != null) {
            for (MIRBusinessRule mIRBusinessRule : this.associatedBusinessRules) {
                mIRBusinessRule.modelObjects.remove(this);
                if (!mIRBusinessRule.modelObjects.isEmpty()) continue;
                mIRBusinessRule.modelObjects = null;
            }
            this.associatedBusinessRules = null;
        }
    }

    protected MIRObjectCollection<MIRPhysicalObject> getAssociatedPhysicalObjectCollection() {
        this.associatedPhysicalObjects = MIRObjectCollections.get(this.associatedPhysicalObjects, MIRSdkCollection.Type.OBJECT);
        return this.associatedPhysicalObjects;
    }

    public SortedSet<MIRPhysicalObject> getAssociatedPhysicalObjects() {
        return MIRObjectCollections.sortedSet(this.associatedPhysicalObjects);
    }

    public final void addAssociatedPhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        if (mIRPhysicalObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelObject", "AssociatedPhysicalObject"));
        }
        if (mIRPhysicalObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelObject", "AssociatedPhysicalObject"));
        }
        if (this.associatedPhysicalObjects != null && this.associatedPhysicalObjects.contains(mIRPhysicalObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelObject", "AssociatedPhysicalObject"));
        }
        this.getAssociatedPhysicalObjectCollection().add(mIRPhysicalObject);
        mIRPhysicalObject.getModelObjectCollection().add(this);
    }

    public final int getAssociatedPhysicalObjectCount() {
        if (this.associatedPhysicalObjects != null) {
            return this.associatedPhysicalObjects.size();
        }
        return 0;
    }

    public final boolean containsAssociatedPhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        if (mIRPhysicalObject != null && this.associatedPhysicalObjects != null) {
            return this.associatedPhysicalObjects.contains(mIRPhysicalObject);
        }
        return false;
    }

    public final MIRPhysicalObject getAssociatedPhysicalObject(String string) {
        if (this.associatedPhysicalObjects != null) {
            return this.associatedPhysicalObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRPhysicalObject> getAssociatedPhysicalObjectIterator() {
        if (this.associatedPhysicalObjects != null) {
            return this.associatedPhysicalObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeAssociatedPhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        if (mIRPhysicalObject != null && this.associatedPhysicalObjects != null && this.associatedPhysicalObjects.remove(mIRPhysicalObject)) {
            mIRPhysicalObject.modelObjects.remove(this);
            if (mIRPhysicalObject.modelObjects.isEmpty()) {
                mIRPhysicalObject.modelObjects = null;
            }
            if (this.associatedPhysicalObjects.isEmpty()) {
                this.associatedPhysicalObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removeAssociatedPhysicalObjects() {
        if (this.associatedPhysicalObjects != null) {
            for (MIRPhysicalObject mIRPhysicalObject : this.associatedPhysicalObjects) {
                mIRPhysicalObject.modelObjects.remove(this);
                if (!mIRPhysicalObject.modelObjects.isEmpty()) continue;
                mIRPhysicalObject.modelObjects = null;
            }
            this.associatedPhysicalObjects = null;
        }
    }

    protected MIRObjectCollection<MIRPresentationElement> getPresentationPresentationElementCollection() {
        this.presentationPresentationElements = MIRObjectCollections.get(this.presentationPresentationElements, MIRSdkCollection.Type.OBJECT);
        return this.presentationPresentationElements;
    }

    public SortedSet<MIRPresentationElement> getPresentationPresentationElements() {
        return MIRObjectCollections.sortedSet(this.presentationPresentationElements);
    }

    public final void addPresentationPresentationElement(MIRPresentationElement mIRPresentationElement) {
        if (mIRPresentationElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelObject", "PresentationPresentationElement"));
        }
        if (mIRPresentationElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelObject", "PresentationPresentationElement"));
        }
        if (mIRPresentationElement.hasSubjectModelObject != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PresentationElement", "SubjectModelObject"));
        }
        if (this.presentationPresentationElements != null && this.presentationPresentationElements.contains(mIRPresentationElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelObject", "PresentationPresentationElement"));
        }
        this.getPresentationPresentationElementCollection().add(mIRPresentationElement);
        mIRPresentationElement.hasSubjectModelObject = this;
    }

    public final int getPresentationPresentationElementCount() {
        if (this.presentationPresentationElements != null) {
            return this.presentationPresentationElements.size();
        }
        return 0;
    }

    public final boolean containsPresentationPresentationElement(MIRPresentationElement mIRPresentationElement) {
        if (mIRPresentationElement != null && this.presentationPresentationElements != null) {
            return this.presentationPresentationElements.contains(mIRPresentationElement);
        }
        return false;
    }

    public final MIRPresentationElement getPresentationPresentationElement(String string) {
        if (this.presentationPresentationElements != null) {
            return this.presentationPresentationElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRPresentationElement> getPresentationPresentationElementIterator() {
        if (this.presentationPresentationElements != null) {
            return this.presentationPresentationElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removePresentationPresentationElement(MIRPresentationElement mIRPresentationElement) {
        if (mIRPresentationElement != null && this.presentationPresentationElements != null && this.presentationPresentationElements.remove(mIRPresentationElement)) {
            mIRPresentationElement.hasSubjectModelObject = null;
            if (this.presentationPresentationElements.isEmpty()) {
                this.presentationPresentationElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removePresentationPresentationElements() {
        if (this.presentationPresentationElements != null) {
            for (MIRPresentationElement mIRPresentationElement : this.presentationPresentationElements) {
                mIRPresentationElement.hasSubjectModelObject = null;
            }
            this.presentationPresentationElements = null;
        }
    }

    protected MIRObjectCollection<MIRSynonym> getSynonymCollection() {
        this.synonyms = MIRObjectCollections.get(this.synonyms, MIRSdkCollection.Type.OBJECT);
        return this.synonyms;
    }

    public SortedSet<MIRSynonym> getSynonyms() {
        return MIRObjectCollections.sortedSet(this.synonyms);
    }

    public final void addSynonym(MIRSynonym mIRSynonym) {
        if (mIRSynonym == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelObject", "Synonym"));
        }
        if (mIRSynonym._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelObject", "Synonym"));
        }
        if (mIRSynonym.hasModelObject != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Synonym", "ModelObject"));
        }
        if (this.synonyms != null && this.synonyms.contains(mIRSynonym)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelObject", "Synonym"));
        }
        this.getSynonymCollection().add(mIRSynonym);
        mIRSynonym.hasModelObject = this;
    }

    public final int getSynonymCount() {
        if (this.synonyms != null) {
            return this.synonyms.size();
        }
        return 0;
    }

    public final boolean containsSynonym(MIRSynonym mIRSynonym) {
        if (mIRSynonym != null && this.synonyms != null) {
            return this.synonyms.contains(mIRSynonym);
        }
        return false;
    }

    public final MIRSynonym getSynonym(String string) {
        if (this.synonyms != null) {
            return this.synonyms.get(string);
        }
        return null;
    }

    public final Iterator<MIRSynonym> getSynonymIterator() {
        if (this.synonyms != null) {
            return this.synonyms.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSynonym(MIRSynonym mIRSynonym) {
        if (mIRSynonym != null && this.synonyms != null && this.synonyms.remove(mIRSynonym)) {
            mIRSynonym.hasModelObject = null;
            if (this.synonyms.isEmpty()) {
                this.synonyms = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSynonyms() {
        if (this.synonyms != null) {
            for (MIRSynonym mIRSynonym : this.synonyms) {
                mIRSynonym.hasModelObject = null;
            }
            this.synonyms = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 59, "ModelObject", true);
            new MIRMetaAttribute(metaClass, 106, "PhysicalName", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 103, "Comment", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 104, "DesignLevel", "java.lang.Byte", MIRDesignLevelType.class, (byte)0);
            new MIRMetaAttribute(metaClass, 108, "Stereotype", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 189, "AssociatedBusinessRule", false, 1, 100, 32);
            new MIRMetaLink(metaClass, 187, "AssociatedPhysicalObject", false, 0, 54, 205);
            new MIRMetaLink(metaClass, 186, "PresentationPresentationElement", false, 0, 61, 211);
            new MIRMetaLink(metaClass, 190, "Synonym", false, 3, 49, 234);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRModelObject.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.associatedBusinessRules != null) {
            for (MIRBusinessRule mIRModelObject : this.associatedBusinessRules) {
                mIRModelObject.modelObjects.rename(this, string);
            }
        }
        if (this.associatedPhysicalObjects != null) {
            for (MIRPhysicalObject mIRPhysicalObject : this.associatedPhysicalObjects) {
                mIRPhysicalObject.modelObjects.rename(this, string);
            }
        }
        super._rename(string);
    }
}

