/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRDimension;
import MITI.sdk.MIRDrillPathLevelAssociation;
import MITI.sdk.MIRHierarchyLevelAssociation;
import MITI.sdk.MIRLevelAssociation;
import MITI.sdk.MIRLevelAttribute;
import MITI.sdk.MIRLevelKey;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRLevel
extends MIRClassifier {
    protected transient MIRObjectCollection<MIRLevelAssociation> childOfLevelAssociations = null;
    protected transient MIRLevelAttribute hasDefaultLevelAttribute = null;
    protected transient MIRDimension hasDimension = null;
    protected transient MIRObjectCollection<MIRDrillPathLevelAssociation> drillPathLevelAssociations = null;
    protected transient MIRObjectCollection<MIRHierarchyLevelAssociation> hierarchyLevelAssociations = null;
    protected transient MIRLevelKey hasLevelKey = null;
    protected transient MIRObjectCollection<MIRLevelAssociation> parentOfLevelAssociations = null;
    private static MIRMetaClass metaClass = MIRLevel.staticGetMetaClass();

    public MIRLevel() {
    }

    public MIRLevel(MIRLevel mIRLevel) {
        this.setFrom(mIRLevel);
    }

    @Override
    public Object clone() {
        return new MIRLevel(this);
    }

    @Override
    public short getElementType() {
        return 94;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasDimension != null) {
            return this.hasDimension;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasDimension != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRLevelAssociation> getChildOfLevelAssociationCollection() {
        this.childOfLevelAssociations = MIRObjectCollections.get(this.childOfLevelAssociations, MIRSdkCollection.Type.OBJECT);
        return this.childOfLevelAssociations;
    }

    public SortedSet<MIRLevelAssociation> getChildOfLevelAssociations() {
        return MIRObjectCollections.sortedSet(this.childOfLevelAssociations);
    }

    public final void addChildOfLevelAssociation(MIRLevelAssociation mIRLevelAssociation) {
        if (mIRLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "ChildOfLevelAssociation"));
        }
        if (mIRLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "ChildOfLevelAssociation"));
        }
        if (mIRLevelAssociation.hasChildLevel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("LevelAssociation", "ChildLevel"));
        }
        if (this.childOfLevelAssociations != null && this.childOfLevelAssociations.contains(mIRLevelAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "ChildOfLevelAssociation"));
        }
        this.getChildOfLevelAssociationCollection().add(mIRLevelAssociation);
        mIRLevelAssociation.hasChildLevel = this;
    }

    public final int getChildOfLevelAssociationCount() {
        if (this.childOfLevelAssociations != null) {
            return this.childOfLevelAssociations.size();
        }
        return 0;
    }

    public final boolean containsChildOfLevelAssociation(MIRLevelAssociation mIRLevelAssociation) {
        if (mIRLevelAssociation != null && this.childOfLevelAssociations != null) {
            return this.childOfLevelAssociations.contains(mIRLevelAssociation);
        }
        return false;
    }

    public final MIRLevelAssociation getChildOfLevelAssociation(String string) {
        if (this.childOfLevelAssociations != null) {
            return this.childOfLevelAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRLevelAssociation> getChildOfLevelAssociationIterator() {
        if (this.childOfLevelAssociations != null) {
            return this.childOfLevelAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeChildOfLevelAssociation(MIRLevelAssociation mIRLevelAssociation) {
        if (mIRLevelAssociation != null && this.childOfLevelAssociations != null && this.childOfLevelAssociations.remove(mIRLevelAssociation)) {
            mIRLevelAssociation.hasChildLevel = null;
            if (this.childOfLevelAssociations.isEmpty()) {
                this.childOfLevelAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeChildOfLevelAssociations() {
        if (this.childOfLevelAssociations != null) {
            for (MIRLevelAssociation mIRLevelAssociation : this.childOfLevelAssociations) {
                mIRLevelAssociation.hasChildLevel = null;
            }
            this.childOfLevelAssociations = null;
        }
    }

    public final void addDefaultLevelAttribute(MIRLevelAttribute mIRLevelAttribute) {
        if (mIRLevelAttribute == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "DefaultLevelAttribute"));
        }
        if (mIRLevelAttribute._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "DefaultLevelAttribute"));
        }
        if (this.hasDefaultLevelAttribute != null) {
            if (this.hasDefaultLevelAttribute._equals(mIRLevelAttribute)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "DefaultLevelAttribute"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Level", "DefaultLevelAttribute"));
        }
        if (mIRLevelAttribute.hasDefaultOfLevel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("LevelAttribute", "DefaultOfLevel"));
        }
        this.hasDefaultLevelAttribute = mIRLevelAttribute;
        mIRLevelAttribute.hasDefaultOfLevel = this;
    }

    public final MIRLevelAttribute getDefaultLevelAttribute() {
        return this.hasDefaultLevelAttribute;
    }

    public final boolean removeDefaultLevelAttribute() {
        if (this.hasDefaultLevelAttribute != null) {
            this.hasDefaultLevelAttribute.hasDefaultOfLevel = null;
            this.hasDefaultLevelAttribute = null;
            return true;
        }
        return false;
    }

    public final void addDimension(MIRDimension mIRDimension) {
        if (mIRDimension == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "Dimension"));
        }
        if (mIRDimension._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "Dimension"));
        }
        if (this.hasDimension != null) {
            if (this.hasDimension._equals(mIRDimension)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "Dimension"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Level", "Dimension"));
        }
        if (mIRDimension.levels != null && !mIRDimension._allowName(mIRDimension.levels, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Dimension", mIRDimension.getPath(), "Level", "Object", this.getName()));
        }
        this.hasDimension = mIRDimension;
        mIRDimension.getLevelCollection().add(this);
    }

    public final MIRDimension getDimension() {
        return this.hasDimension;
    }

    public final boolean removeDimension() {
        if (this.hasDimension != null) {
            this.hasDimension.levels.remove(this);
            if (this.hasDimension.levels.isEmpty()) {
                this.hasDimension.levels = null;
            }
            this.hasDimension = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRDrillPathLevelAssociation> getDrillPathLevelAssociationCollection() {
        this.drillPathLevelAssociations = MIRObjectCollections.get(this.drillPathLevelAssociations, MIRSdkCollection.Type.OBJECT);
        return this.drillPathLevelAssociations;
    }

    public SortedSet<MIRDrillPathLevelAssociation> getDrillPathLevelAssociations() {
        return MIRObjectCollections.sortedSet(this.drillPathLevelAssociations);
    }

    public final void addDrillPathLevelAssociation(MIRDrillPathLevelAssociation mIRDrillPathLevelAssociation) {
        if (mIRDrillPathLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "DrillPathLevelAssociation"));
        }
        if (mIRDrillPathLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "DrillPathLevelAssociation"));
        }
        if (mIRDrillPathLevelAssociation.hasLevel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("DrillPathLevelAssociation", "Level"));
        }
        if (this.drillPathLevelAssociations != null && this.drillPathLevelAssociations.contains(mIRDrillPathLevelAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "DrillPathLevelAssociation"));
        }
        this.getDrillPathLevelAssociationCollection().add(mIRDrillPathLevelAssociation);
        mIRDrillPathLevelAssociation.hasLevel = this;
    }

    public final int getDrillPathLevelAssociationCount() {
        if (this.drillPathLevelAssociations != null) {
            return this.drillPathLevelAssociations.size();
        }
        return 0;
    }

    public final boolean containsDrillPathLevelAssociation(MIRDrillPathLevelAssociation mIRDrillPathLevelAssociation) {
        if (mIRDrillPathLevelAssociation != null && this.drillPathLevelAssociations != null) {
            return this.drillPathLevelAssociations.contains(mIRDrillPathLevelAssociation);
        }
        return false;
    }

    public final MIRDrillPathLevelAssociation getDrillPathLevelAssociation(String string) {
        if (this.drillPathLevelAssociations != null) {
            return this.drillPathLevelAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRDrillPathLevelAssociation> getDrillPathLevelAssociationIterator() {
        if (this.drillPathLevelAssociations != null) {
            return this.drillPathLevelAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDrillPathLevelAssociation(MIRDrillPathLevelAssociation mIRDrillPathLevelAssociation) {
        if (mIRDrillPathLevelAssociation != null && this.drillPathLevelAssociations != null && this.drillPathLevelAssociations.remove(mIRDrillPathLevelAssociation)) {
            mIRDrillPathLevelAssociation.hasLevel = null;
            if (this.drillPathLevelAssociations.isEmpty()) {
                this.drillPathLevelAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDrillPathLevelAssociations() {
        if (this.drillPathLevelAssociations != null) {
            for (MIRDrillPathLevelAssociation mIRDrillPathLevelAssociation : this.drillPathLevelAssociations) {
                mIRDrillPathLevelAssociation.hasLevel = null;
            }
            this.drillPathLevelAssociations = null;
        }
    }

    protected MIRObjectCollection<MIRHierarchyLevelAssociation> getHierarchyLevelAssociationCollection() {
        this.hierarchyLevelAssociations = MIRObjectCollections.get(this.hierarchyLevelAssociations, MIRSdkCollection.Type.OBJECT);
        return this.hierarchyLevelAssociations;
    }

    public SortedSet<MIRHierarchyLevelAssociation> getHierarchyLevelAssociations() {
        return MIRObjectCollections.sortedSet(this.hierarchyLevelAssociations);
    }

    public final void addHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "HierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "HierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation.hasLevel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("HierarchyLevelAssociation", "Level"));
        }
        if (this.hierarchyLevelAssociations != null && this.hierarchyLevelAssociations.contains(mIRHierarchyLevelAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "HierarchyLevelAssociation"));
        }
        this.getHierarchyLevelAssociationCollection().add(mIRHierarchyLevelAssociation);
        mIRHierarchyLevelAssociation.hasLevel = this;
    }

    public final int getHierarchyLevelAssociationCount() {
        if (this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.size();
        }
        return 0;
    }

    public final boolean containsHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation != null && this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.contains(mIRHierarchyLevelAssociation);
        }
        return false;
    }

    public final MIRHierarchyLevelAssociation getHierarchyLevelAssociation(String string) {
        if (this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRHierarchyLevelAssociation> getHierarchyLevelAssociationIterator() {
        if (this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation != null && this.hierarchyLevelAssociations != null && this.hierarchyLevelAssociations.remove(mIRHierarchyLevelAssociation)) {
            mIRHierarchyLevelAssociation.hasLevel = null;
            if (this.hierarchyLevelAssociations.isEmpty()) {
                this.hierarchyLevelAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeHierarchyLevelAssociations() {
        if (this.hierarchyLevelAssociations != null) {
            for (MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation : this.hierarchyLevelAssociations) {
                mIRHierarchyLevelAssociation.hasLevel = null;
            }
            this.hierarchyLevelAssociations = null;
        }
    }

    public final void addLevelKey(MIRLevelKey mIRLevelKey) {
        if (mIRLevelKey == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "LevelKey"));
        }
        if (mIRLevelKey._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "LevelKey"));
        }
        if (this.hasLevelKey != null) {
            if (this.hasLevelKey._equals(mIRLevelKey)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "LevelKey"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Level", "LevelKey"));
        }
        if (mIRLevelKey.hasLevel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("LevelKey", "Level"));
        }
        this.hasLevelKey = mIRLevelKey;
        mIRLevelKey.hasLevel = this;
    }

    public final MIRLevelKey getLevelKey() {
        return this.hasLevelKey;
    }

    public final boolean removeLevelKey() {
        if (this.hasLevelKey != null) {
            this.hasLevelKey.hasLevel = null;
            this.hasLevelKey = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRLevelAssociation> getParentOfLevelAssociationCollection() {
        this.parentOfLevelAssociations = MIRObjectCollections.get(this.parentOfLevelAssociations, MIRSdkCollection.Type.OBJECT);
        return this.parentOfLevelAssociations;
    }

    public SortedSet<MIRLevelAssociation> getParentOfLevelAssociations() {
        return MIRObjectCollections.sortedSet(this.parentOfLevelAssociations);
    }

    public final void addParentOfLevelAssociation(MIRLevelAssociation mIRLevelAssociation) {
        if (mIRLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Level", "ParentOfLevelAssociation"));
        }
        if (mIRLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Level", "ParentOfLevelAssociation"));
        }
        if (mIRLevelAssociation.hasParentLevel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("LevelAssociation", "ParentLevel"));
        }
        if (this.parentOfLevelAssociations != null && this.parentOfLevelAssociations.contains(mIRLevelAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Level", "ParentOfLevelAssociation"));
        }
        this.getParentOfLevelAssociationCollection().add(mIRLevelAssociation);
        mIRLevelAssociation.hasParentLevel = this;
    }

    public final int getParentOfLevelAssociationCount() {
        if (this.parentOfLevelAssociations != null) {
            return this.parentOfLevelAssociations.size();
        }
        return 0;
    }

    public final boolean containsParentOfLevelAssociation(MIRLevelAssociation mIRLevelAssociation) {
        if (mIRLevelAssociation != null && this.parentOfLevelAssociations != null) {
            return this.parentOfLevelAssociations.contains(mIRLevelAssociation);
        }
        return false;
    }

    public final MIRLevelAssociation getParentOfLevelAssociation(String string) {
        if (this.parentOfLevelAssociations != null) {
            return this.parentOfLevelAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRLevelAssociation> getParentOfLevelAssociationIterator() {
        if (this.parentOfLevelAssociations != null) {
            return this.parentOfLevelAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeParentOfLevelAssociation(MIRLevelAssociation mIRLevelAssociation) {
        if (mIRLevelAssociation != null && this.parentOfLevelAssociations != null && this.parentOfLevelAssociations.remove(mIRLevelAssociation)) {
            mIRLevelAssociation.hasParentLevel = null;
            if (this.parentOfLevelAssociations.isEmpty()) {
                this.parentOfLevelAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeParentOfLevelAssociations() {
        if (this.parentOfLevelAssociations != null) {
            for (MIRLevelAssociation mIRLevelAssociation : this.parentOfLevelAssociations) {
                mIRLevelAssociation.hasParentLevel = null;
            }
            this.parentOfLevelAssociations = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRClassifier.staticGetMetaClass(), 94, "Level", false);
            new MIRMetaLink(metaClass, 336, "ChildOfLevelAssociation", false, 0, 138, 338);
            new MIRMetaLink(metaClass, 365, "DefaultLevelAttribute", true, 1, 95, 366);
            new MIRMetaLink(metaClass, 161, "Dimension", true, 2, 87, 93);
            new MIRMetaLink(metaClass, 301, "DrillPathLevelAssociation", false, 0, 109, 333);
            new MIRMetaLink(metaClass, 163, "HierarchyLevelAssociation", false, 0, 91, 142);
            new MIRMetaLink(metaClass, 162, "LevelKey", true, 3, 96, 166);
            new MIRMetaLink(metaClass, 335, "ParentOfLevelAssociation", false, 3, 138, 337);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRLevel.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasDimension != null && !this.hasDimension._allowName(this.hasDimension.levels, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDimension != null) {
            this.hasDimension.levels.rename(this, string);
        }
        super._rename(string);
    }
}

