/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRIndex;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRKey
extends MIRModelObject {
    protected transient MIRClass hasAssociatedClass = null;
    protected transient MIRObjectCollection<MIRAttribute> attributes = null;
    protected transient MIRIndex hasIndex = null;
    private static MIRMetaClass metaClass = MIRKey.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 20;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasAssociatedClass != null) {
            return this.hasAssociatedClass;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasAssociatedClass != null ? 1 : 0) + super.getParentCount();
    }

    public final void addAssociatedClass(MIRClass mIRClass) {
        if (mIRClass == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Key", "AssociatedClass"));
        }
        if (mIRClass._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Key", "AssociatedClass"));
        }
        if (this.hasAssociatedClass != null) {
            if (this.hasAssociatedClass._equals(mIRClass)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Key", "AssociatedClass"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Key", "AssociatedClass"));
        }
        this.hasAssociatedClass = mIRClass;
        mIRClass.getKeyCollection().add(this);
    }

    public final MIRClass getAssociatedClass() {
        return this.hasAssociatedClass;
    }

    public final boolean removeAssociatedClass() {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.keys.remove(this);
            if (this.hasAssociatedClass.keys.isEmpty()) {
                this.hasAssociatedClass.keys = null;
            }
            this.hasAssociatedClass = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRAttribute> getAttributeCollection() {
        this.attributes = MIRObjectCollections.get(this.attributes, MIRSdkCollection.Type.OBJECT);
        return this.attributes;
    }

    public SortedSet<MIRAttribute> getAttributes() {
        return MIRObjectCollections.sortedSet(this.attributes);
    }

    public final void addAttribute(MIRAttribute mIRAttribute) {
        if (mIRAttribute == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Key", "Attribute"));
        }
        if (mIRAttribute._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Key", "Attribute"));
        }
        if (this.attributes != null && this.attributes.contains(mIRAttribute)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Key", "Attribute"));
        }
        this.getAttributeCollection().add(mIRAttribute);
        mIRAttribute.getKeyCollection().add(this);
    }

    public final int getAttributeCount() {
        if (this.attributes != null) {
            return this.attributes.size();
        }
        return 0;
    }

    public final boolean containsAttribute(MIRAttribute mIRAttribute) {
        if (mIRAttribute != null && this.attributes != null) {
            return this.attributes.contains(mIRAttribute);
        }
        return false;
    }

    public final MIRAttribute getAttribute(String string) {
        if (this.attributes != null) {
            return this.attributes.get(string);
        }
        return null;
    }

    public final Iterator<MIRAttribute> getAttributeIterator() {
        if (this.attributes != null) {
            return this.attributes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeAttribute(MIRAttribute mIRAttribute) {
        if (mIRAttribute != null && this.attributes != null && this.attributes.remove(mIRAttribute)) {
            mIRAttribute.keys.remove(this);
            if (mIRAttribute.keys.isEmpty()) {
                mIRAttribute.keys = null;
            }
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeAttributes() {
        if (this.attributes != null) {
            for (MIRAttribute mIRAttribute : this.attributes) {
                mIRAttribute.keys.remove(this);
                if (!mIRAttribute.keys.isEmpty()) continue;
                mIRAttribute.keys = null;
            }
            this.attributes = null;
        }
    }

    public final void addIndex(MIRIndex mIRIndex) {
        if (mIRIndex == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Key", "Index"));
        }
        if (mIRIndex._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Key", "Index"));
        }
        if (this.hasIndex != null) {
            if (this.hasIndex._equals(mIRIndex)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Key", "Index"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Key", "Index"));
        }
        if (mIRIndex.hasKey != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Index", "Key"));
        }
        this.hasIndex = mIRIndex;
        mIRIndex.hasKey = this;
    }

    public final MIRIndex getIndex() {
        return this.hasIndex;
    }

    public final boolean removeIndex() {
        if (this.hasIndex != null) {
            this.hasIndex.hasKey = null;
            this.hasIndex = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 20, "Key", true);
            new MIRMetaLink(metaClass, 155, "AssociatedClass", true, 2, 13, 54);
            new MIRMetaLink(metaClass, 156, "Attribute", false, 0, 14, 24);
            new MIRMetaLink(metaClass, 153, "Index", true, 1, 51, 145);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRKey.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.keys.rename(this, string);
        }
        if (this.attributes != null) {
            for (MIRAttribute mIRAttribute : this.attributes) {
                mIRAttribute.keys.rename(this, string);
            }
        }
        super._rename(string);
    }
}

