/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRCube;
import MITI.sdk.MIRDimension;
import MITI.sdk.MIRJoinGroup;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRJoinType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRJoin
extends MIRClassifier {
    protected transient byte aType = 0;
    protected transient boolean aUserDefined = true;
    protected transient MIRObjectCollection<MIRCube> cubes = null;
    protected transient MIRObjectCollection<MIRDimension> dimensions = null;
    protected transient MIRObjectCollection<MIRJoinGroup> joinGroups = null;
    protected transient MIRObjectCollection<MIRJoinRole> joinRoles = null;
    private static MIRMetaClass metaClass = MIRJoin.staticGetMetaClass();

    public MIRJoin() {
    }

    public MIRJoin(MIRJoin mIRJoin) {
        this.setFrom(mIRJoin);
    }

    @Override
    public Object clone() {
        return new MIRJoin(this);
    }

    @Override
    public short getElementType() {
        return 92;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)92)) {
            this.setType(((MIRJoin)mIR_Object).getType());
            this.setUserDefined(((MIRJoin)mIR_Object).getUserDefined());
        }
    }

    public final void setType(byte by) {
        this.aType = by;
    }

    public final byte getType() {
        return this.aType;
    }

    public final void setUserDefined(boolean bl) {
        this.aUserDefined = bl;
    }

    public final boolean getUserDefined() {
        return this.aUserDefined;
    }

    protected MIRObjectCollection<MIRCube> getCubeCollection() {
        this.cubes = MIRObjectCollections.get(this.cubes, MIRSdkCollection.Type.OBJECT);
        return this.cubes;
    }

    public SortedSet<MIRCube> getCubes() {
        return MIRObjectCollections.sortedSet(this.cubes);
    }

    public final void addCube(MIRCube mIRCube) {
        if (mIRCube == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Join", "Cube"));
        }
        if (mIRCube._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Join", "Cube"));
        }
        if (this.cubes != null && this.cubes.contains(mIRCube)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Join", "Cube"));
        }
        this.getCubeCollection().add(mIRCube);
        mIRCube.getJoinCollection().add(this);
    }

    public final int getCubeCount() {
        if (this.cubes != null) {
            return this.cubes.size();
        }
        return 0;
    }

    public final boolean containsCube(MIRCube mIRCube) {
        if (mIRCube != null && this.cubes != null) {
            return this.cubes.contains(mIRCube);
        }
        return false;
    }

    public final MIRCube getCube(String string) {
        if (this.cubes != null) {
            return this.cubes.get(string);
        }
        return null;
    }

    public final Iterator<MIRCube> getCubeIterator() {
        if (this.cubes != null) {
            return this.cubes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeCube(MIRCube mIRCube) {
        if (mIRCube != null && this.cubes != null && this.cubes.remove(mIRCube)) {
            mIRCube.joins.remove(this);
            if (mIRCube.joins.isEmpty()) {
                mIRCube.joins = null;
            }
            if (this.cubes.isEmpty()) {
                this.cubes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeCubes() {
        if (this.cubes != null) {
            for (MIRCube mIRCube : this.cubes) {
                mIRCube.joins.remove(this);
                if (!mIRCube.joins.isEmpty()) continue;
                mIRCube.joins = null;
            }
            this.cubes = null;
        }
    }

    protected MIRObjectCollection<MIRDimension> getDimensionCollection() {
        this.dimensions = MIRObjectCollections.get(this.dimensions, MIRSdkCollection.Type.OBJECT);
        return this.dimensions;
    }

    public SortedSet<MIRDimension> getDimensions() {
        return MIRObjectCollections.sortedSet(this.dimensions);
    }

    public final void addDimension(MIRDimension mIRDimension) {
        if (mIRDimension == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Join", "Dimension"));
        }
        if (mIRDimension._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Join", "Dimension"));
        }
        if (this.dimensions != null && this.dimensions.contains(mIRDimension)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Join", "Dimension"));
        }
        this.getDimensionCollection().add(mIRDimension);
        mIRDimension.getJoinCollection().add(this);
    }

    public final int getDimensionCount() {
        if (this.dimensions != null) {
            return this.dimensions.size();
        }
        return 0;
    }

    public final boolean containsDimension(MIRDimension mIRDimension) {
        if (mIRDimension != null && this.dimensions != null) {
            return this.dimensions.contains(mIRDimension);
        }
        return false;
    }

    public final MIRDimension getDimension(String string) {
        if (this.dimensions != null) {
            return this.dimensions.get(string);
        }
        return null;
    }

    public final Iterator<MIRDimension> getDimensionIterator() {
        if (this.dimensions != null) {
            return this.dimensions.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDimension(MIRDimension mIRDimension) {
        if (mIRDimension != null && this.dimensions != null && this.dimensions.remove(mIRDimension)) {
            mIRDimension.joins.remove(this);
            if (mIRDimension.joins.isEmpty()) {
                mIRDimension.joins = null;
            }
            if (this.dimensions.isEmpty()) {
                this.dimensions = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDimensions() {
        if (this.dimensions != null) {
            for (MIRDimension mIRDimension : this.dimensions) {
                mIRDimension.joins.remove(this);
                if (!mIRDimension.joins.isEmpty()) continue;
                mIRDimension.joins = null;
            }
            this.dimensions = null;
        }
    }

    protected MIRObjectCollection<MIRJoinGroup> getJoinGroupCollection() {
        this.joinGroups = MIRObjectCollections.get(this.joinGroups, MIRSdkCollection.Type.OBJECT);
        return this.joinGroups;
    }

    public SortedSet<MIRJoinGroup> getJoinGroups() {
        return MIRObjectCollections.sortedSet(this.joinGroups);
    }

    public final void addJoinGroup(MIRJoinGroup mIRJoinGroup) {
        if (mIRJoinGroup == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Join", "JoinGroup"));
        }
        if (mIRJoinGroup._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Join", "JoinGroup"));
        }
        if (this.joinGroups != null && this.joinGroups.contains(mIRJoinGroup)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Join", "JoinGroup"));
        }
        this.getJoinGroupCollection().add(mIRJoinGroup);
        mIRJoinGroup.getJoinCollection().add(this);
    }

    public final int getJoinGroupCount() {
        if (this.joinGroups != null) {
            return this.joinGroups.size();
        }
        return 0;
    }

    public final boolean containsJoinGroup(MIRJoinGroup mIRJoinGroup) {
        if (mIRJoinGroup != null && this.joinGroups != null) {
            return this.joinGroups.contains(mIRJoinGroup);
        }
        return false;
    }

    public final MIRJoinGroup getJoinGroup(String string) {
        if (this.joinGroups != null) {
            return this.joinGroups.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinGroup> getJoinGroupIterator() {
        if (this.joinGroups != null) {
            return this.joinGroups.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeJoinGroup(MIRJoinGroup mIRJoinGroup) {
        if (mIRJoinGroup != null && this.joinGroups != null && this.joinGroups.remove(mIRJoinGroup)) {
            mIRJoinGroup.joins.remove(this);
            if (mIRJoinGroup.joins.isEmpty()) {
                mIRJoinGroup.joins = null;
            }
            if (this.joinGroups.isEmpty()) {
                this.joinGroups = null;
            }
            return true;
        }
        return false;
    }

    public final void removeJoinGroups() {
        if (this.joinGroups != null) {
            for (MIRJoinGroup mIRJoinGroup : this.joinGroups) {
                mIRJoinGroup.joins.remove(this);
                if (!mIRJoinGroup.joins.isEmpty()) continue;
                mIRJoinGroup.joins = null;
            }
            this.joinGroups = null;
        }
    }

    protected MIRObjectCollection<MIRJoinRole> getJoinRoleCollection() {
        this.joinRoles = MIRObjectCollections.get(this.joinRoles, MIRSdkCollection.Type.OBJECT);
        return this.joinRoles;
    }

    public SortedSet<MIRJoinRole> getJoinRoles() {
        return MIRObjectCollections.sortedSet(this.joinRoles);
    }

    public final void addJoinRole(MIRJoinRole mIRJoinRole) {
        if (mIRJoinRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Join", "JoinRole"));
        }
        if (mIRJoinRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Join", "JoinRole"));
        }
        if (mIRJoinRole.hasJoin != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinRole", "Join"));
        }
        if (this.joinRoles != null && this.joinRoles.contains(mIRJoinRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Join", "JoinRole"));
        }
        this.getJoinRoleCollection().add(mIRJoinRole);
        mIRJoinRole.hasJoin = this;
    }

    public final int getJoinRoleCount() {
        if (this.joinRoles != null) {
            return this.joinRoles.size();
        }
        return 0;
    }

    public final boolean containsJoinRole(MIRJoinRole mIRJoinRole) {
        if (mIRJoinRole != null && this.joinRoles != null) {
            return this.joinRoles.contains(mIRJoinRole);
        }
        return false;
    }

    public final MIRJoinRole getJoinRole(String string) {
        if (this.joinRoles != null) {
            return this.joinRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinRole> getJoinRoleIterator() {
        if (this.joinRoles != null) {
            return this.joinRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeJoinRole(MIRJoinRole mIRJoinRole) {
        if (mIRJoinRole != null && this.joinRoles != null && this.joinRoles.remove(mIRJoinRole)) {
            mIRJoinRole.hasJoin = null;
            if (this.joinRoles.isEmpty()) {
                this.joinRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeJoinRoles() {
        if (this.joinRoles != null) {
            for (MIRJoinRole mIRJoinRole : this.joinRoles) {
                mIRJoinRole.hasJoin = null;
            }
            this.joinRoles = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRClassifier.staticGetMetaClass(), 92, "Join", false);
            new MIRMetaAttribute(metaClass, 84, "Type", "java.lang.Byte", MIRJoinType.class, (byte)0);
            new MIRMetaAttribute(metaClass, 85, "UserDefined", "java.lang.Boolean", null, true);
            new MIRMetaLink(metaClass, 149, "Cube", false, 1, 85, 76);
            new MIRMetaLink(metaClass, 150, "Dimension", false, 1, 87, 95);
            new MIRMetaLink(metaClass, 378, "JoinGroup", false, 1, 152, 377);
            new MIRMetaLink(metaClass, 148, "JoinRole", false, 3, 93, 151);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRJoin.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.cubes != null) {
            for (MIRCube mIRModelElement : this.cubes) {
                mIRModelElement.joins.rename(this, string);
            }
        }
        if (this.dimensions != null) {
            for (MIRDimension mIRDimension : this.dimensions) {
                mIRDimension.joins.rename(this, string);
            }
        }
        if (this.joinGroups != null) {
            for (MIRJoinGroup mIRJoinGroup : this.joinGroups) {
                mIRJoinGroup.joins.rename(this, string);
            }
        }
        super._rename(string);
    }
}

