/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRFolder
extends MIRFolderContent {
    protected transient MIRObjectCollection<MIRFolderContent> folderContents = null;
    protected transient MIRObjectCollection<MIRFolderContent> referencedFolderContents = null;
    private static MIRMetaClass metaClass = MIRFolder.staticGetMetaClass();

    public MIRFolder() {
    }

    public MIRFolder(MIRFolder mIRFolder) {
        this.setFrom(mIRFolder);
    }

    @Override
    public Object clone() {
        return new MIRFolder(this);
    }

    @Override
    public short getElementType() {
        return 157;
    }

    protected MIRObjectCollection<MIRFolderContent> getFolderContentCollection() {
        this.folderContents = MIRObjectCollections.get(this.folderContents, MIRSdkCollection.Type.NAME);
        return this.folderContents;
    }

    public SortedSet<MIRFolderContent> getFolderContents() {
        return MIRObjectCollections.sortedSet(this.folderContents);
    }

    public final void addFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Folder", "FolderContent"));
        }
        if (mIRFolderContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Folder", "FolderContent"));
        }
        if (mIRFolderContent.hasFolder != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FolderContent", "Folder"));
        }
        if (this.folderContents != null) {
            if (this.folderContents.contains(mIRFolderContent)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Folder", "FolderContent"));
            }
            if (!this._allowName(this.folderContents, mIRFolderContent)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Folder", this.getPath(), "FolderContent", "Name", mIRFolderContent.getPath()));
            }
        }
        this.getFolderContentCollection().add(mIRFolderContent);
        mIRFolderContent.hasFolder = this;
    }

    public final boolean addFolderContentUniqueName(MIRFolderContent mIRFolderContent) {
        return this.addFolderContentUniqueName(mIRFolderContent, '/');
    }

    public final boolean addFolderContentUniqueName(MIRFolderContent mIRFolderContent, char c) {
        if (mIRFolderContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Folder", "FolderContent"));
        }
        if (mIRFolderContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Folder", "FolderContent"));
        }
        if (mIRFolderContent.hasFolder != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FolderContent", "Folder"));
        }
        boolean bl = false;
        if (this.folderContents != null) {
            if (this.folderContents.contains(mIRFolderContent)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Folder", "FolderContent"));
            }
            if (!this._allowName(this.folderContents, mIRFolderContent)) {
                mIRFolderContent._rename(mIRFolderContent._setUniqueName(this.folderContents, c));
                bl = true;
            }
        }
        this.getFolderContentCollection().add(mIRFolderContent);
        mIRFolderContent.hasFolder = this;
        return bl;
    }

    public final int getFolderContentCount() {
        if (this.folderContents != null) {
            return this.folderContents.size();
        }
        return 0;
    }

    public final boolean containsFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent != null && this.folderContents != null) {
            return this.folderContents.contains(mIRFolderContent);
        }
        return false;
    }

    public final MIRFolderContent getFolderContent(String string) {
        if (this.folderContents != null) {
            return this.folderContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRFolderContent> getFolderContentIterator() {
        if (this.folderContents != null) {
            return this.folderContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent != null && this.folderContents != null && this.folderContents.remove(mIRFolderContent)) {
            mIRFolderContent.hasFolder = null;
            if (this.folderContents.isEmpty()) {
                this.folderContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFolderContents() {
        if (this.folderContents != null) {
            for (MIRFolderContent mIRFolderContent : this.folderContents) {
                mIRFolderContent.hasFolder = null;
            }
            this.folderContents = null;
        }
    }

    protected MIRObjectCollection<MIRFolderContent> getReferencedFolderContentCollection() {
        this.referencedFolderContents = MIRObjectCollections.get(this.referencedFolderContents, MIRSdkCollection.Type.OBJECT);
        return this.referencedFolderContents;
    }

    public SortedSet<MIRFolderContent> getReferencedFolderContents() {
        return MIRObjectCollections.sortedSet(this.referencedFolderContents);
    }

    public final void addReferencedFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Folder", "ReferencedFolderContent"));
        }
        if (mIRFolderContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Folder", "ReferencedFolderContent"));
        }
        if (this.referencedFolderContents != null && this.referencedFolderContents.contains(mIRFolderContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Folder", "ReferencedFolderContent"));
        }
        this.getReferencedFolderContentCollection().add(mIRFolderContent);
        mIRFolderContent.getReferencedByFolderCollection().add(this);
    }

    public final int getReferencedFolderContentCount() {
        if (this.referencedFolderContents != null) {
            return this.referencedFolderContents.size();
        }
        return 0;
    }

    public final boolean containsReferencedFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent != null && this.referencedFolderContents != null) {
            return this.referencedFolderContents.contains(mIRFolderContent);
        }
        return false;
    }

    public final MIRFolderContent getReferencedFolderContent(String string) {
        if (this.referencedFolderContents != null) {
            return this.referencedFolderContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRFolderContent> getReferencedFolderContentIterator() {
        if (this.referencedFolderContents != null) {
            return this.referencedFolderContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent != null && this.referencedFolderContents != null && this.referencedFolderContents.remove(mIRFolderContent)) {
            mIRFolderContent.referencedByFolders.remove(this);
            if (mIRFolderContent.referencedByFolders.isEmpty()) {
                mIRFolderContent.referencedByFolders = null;
            }
            if (this.referencedFolderContents.isEmpty()) {
                this.referencedFolderContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedFolderContents() {
        if (this.referencedFolderContents != null) {
            for (MIRFolderContent mIRFolderContent : this.referencedFolderContents) {
                mIRFolderContent.referencedByFolders.remove(this);
                if (!mIRFolderContent.referencedByFolders.isEmpty()) continue;
                mIRFolderContent.referencedByFolders = null;
            }
            this.referencedFolderContents = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRFolderContent.staticGetMetaClass(), 157, "Folder", false);
            new MIRMetaLink(metaClass, 893, "FolderContent", false, 3, 158, 895);
            new MIRMetaLink(metaClass, 894, "ReferencedFolderContent", false, 1, 158, 896);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRFolder.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.referencedFolderContents != null) {
            for (MIRFolderContent mIRFolderContent : this.referencedFolderContents) {
                mIRFolderContent.referencedByFolders.rename(this, string);
            }
        }
        super._rename(string);
    }
}

