/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRUsedParameter;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRFeatureMap
extends MIRElement {
    protected transient boolean aBulk = false;
    protected transient boolean aConstant = false;
    protected transient String aOperation = "";
    protected transient short aPosition = 0;
    protected transient MIRClassifierMap hasClassifierMap = null;
    protected transient MIRObjectCollection<MIRFeature> controlFeatures = null;
    protected transient MIRFeature hasDestinationFeature = null;
    protected transient MIRExpression hasExpression = null;
    protected transient MIRObjectCollection<MIRFeature> sourceFeatures = null;
    protected transient MIRObjectCollection<MIRUsedParameter> usedParameters = null;
    private static MIRMetaClass metaClass = MIRFeatureMap.staticGetMetaClass();
    protected static final Comparator<MIRFeatureMap> ByPosition = new Comparator<MIRFeatureMap>(){

        @Override
        public int compare(MIRFeatureMap mIRFeatureMap, MIRFeatureMap mIRFeatureMap2) {
            return mIRFeatureMap.getPosition() - mIRFeatureMap2.getPosition();
        }
    };

    public MIRFeatureMap() {
    }

    public MIRFeatureMap(MIRFeatureMap mIRFeatureMap) {
        this.setFrom(mIRFeatureMap);
    }

    @Override
    public Object clone() {
        return new MIRFeatureMap(this);
    }

    @Override
    public short getElementType() {
        return 78;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)78)) {
            this.setBulk(((MIRFeatureMap)mIR_Object).getBulk());
            this.setConstant(((MIRFeatureMap)mIR_Object).getConstant());
            this.setOperation(((MIRFeatureMap)mIR_Object).getOperation());
            this.setPosition(((MIRFeatureMap)mIR_Object).getPosition());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasClassifierMap != null) {
            return this.hasClassifierMap;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasClassifierMap != null ? 1 : 0) + super.getParentCount();
    }

    public final void setBulk(boolean bl) {
        this.aBulk = bl;
    }

    public final boolean getBulk() {
        return this.aBulk;
    }

    public final void setConstant(boolean bl) {
        this.aConstant = bl;
    }

    public final boolean getConstant() {
        return this.aConstant;
    }

    public final void setOperation(String string) {
        this.aOperation = string == null ? "" : string;
    }

    public final String getOperation() {
        return this.aOperation;
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    public final void addClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "ClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "ClassifierMap"));
        }
        if (this.hasClassifierMap != null) {
            if (this.hasClassifierMap._equals(mIRClassifierMap)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "ClassifierMap"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FeatureMap", "ClassifierMap"));
        }
        this.hasClassifierMap = mIRClassifierMap;
        mIRClassifierMap.getFeatureMapCollection().add(this);
    }

    public final MIRClassifierMap getClassifierMap() {
        return this.hasClassifierMap;
    }

    public final boolean removeClassifierMap() {
        if (this.hasClassifierMap != null) {
            this.hasClassifierMap.featureMaps.remove(this);
            if (this.hasClassifierMap.featureMaps.isEmpty()) {
                this.hasClassifierMap.featureMaps = null;
            }
            this.hasClassifierMap = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRFeature> getControlFeatureCollection() {
        this.controlFeatures = MIRObjectCollections.get(this.controlFeatures, MIRSdkCollection.Type.OBJECT);
        return this.controlFeatures;
    }

    public SortedSet<MIRFeature> getControlFeatures() {
        return MIRObjectCollections.sortedSet(this.controlFeatures);
    }

    public final void addControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "ControlFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "ControlFeature"));
        }
        if (this.controlFeatures != null && this.controlFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "ControlFeature"));
        }
        this.getControlFeatureCollection().add(mIRFeature);
        mIRFeature.getControlOfFeatureMapCollection().add(this);
    }

    public final int getControlFeatureCount() {
        if (this.controlFeatures != null) {
            return this.controlFeatures.size();
        }
        return 0;
    }

    public final boolean containsControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.controlFeatures != null) {
            return this.controlFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getControlFeature(String string) {
        if (this.controlFeatures != null) {
            return this.controlFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getControlFeatureIterator() {
        if (this.controlFeatures != null) {
            return this.controlFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.controlFeatures != null && this.controlFeatures.remove(mIRFeature)) {
            mIRFeature.controlOfFeatureMaps.remove(this);
            if (mIRFeature.controlOfFeatureMaps.isEmpty()) {
                mIRFeature.controlOfFeatureMaps = null;
            }
            if (this.controlFeatures.isEmpty()) {
                this.controlFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeControlFeatures() {
        if (this.controlFeatures != null) {
            for (MIRFeature mIRFeature : this.controlFeatures) {
                mIRFeature.controlOfFeatureMaps.remove(this);
                if (!mIRFeature.controlOfFeatureMaps.isEmpty()) continue;
                mIRFeature.controlOfFeatureMaps = null;
            }
            this.controlFeatures = null;
        }
    }

    public final void addDestinationFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "DestinationFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "DestinationFeature"));
        }
        if (this.hasDestinationFeature != null) {
            if (this.hasDestinationFeature._equals(mIRFeature)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "DestinationFeature"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FeatureMap", "DestinationFeature"));
        }
        this.hasDestinationFeature = mIRFeature;
        mIRFeature.getDestinationOfFeatureMapCollection().add(this);
    }

    public final MIRFeature getDestinationFeature() {
        return this.hasDestinationFeature;
    }

    public final boolean removeDestinationFeature() {
        if (this.hasDestinationFeature != null) {
            this.hasDestinationFeature.destinationOfFeatureMaps.remove(this);
            if (this.hasDestinationFeature.destinationOfFeatureMaps.isEmpty()) {
                this.hasDestinationFeature.destinationOfFeatureMaps = null;
            }
            this.hasDestinationFeature = null;
            return true;
        }
        return false;
    }

    public final void addExpression(MIRExpression mIRExpression) {
        if (mIRExpression == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "Expression"));
        }
        if (mIRExpression._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "Expression"));
        }
        if (this.hasExpression != null) {
            if (this.hasExpression._equals(mIRExpression)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "Expression"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FeatureMap", "Expression"));
        }
        if (mIRExpression.hasFeatureMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Expression", "FeatureMap"));
        }
        this.hasExpression = mIRExpression;
        mIRExpression.hasFeatureMap = this;
    }

    public final MIRExpression getExpression() {
        return this.hasExpression;
    }

    public final boolean removeExpression() {
        if (this.hasExpression != null) {
            this.hasExpression.hasFeatureMap = null;
            this.hasExpression = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRFeature> getSourceFeatureCollection() {
        this.sourceFeatures = MIRObjectCollections.get(this.sourceFeatures, MIRSdkCollection.Type.OBJECT);
        return this.sourceFeatures;
    }

    public SortedSet<MIRFeature> getSourceFeatures() {
        return MIRObjectCollections.sortedSet(this.sourceFeatures);
    }

    public final void addSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "SourceFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "SourceFeature"));
        }
        if (this.sourceFeatures != null && this.sourceFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "SourceFeature"));
        }
        this.getSourceFeatureCollection().add(mIRFeature);
        mIRFeature.getSourceOfFeatureMapCollection().add(this);
    }

    public final int getSourceFeatureCount() {
        if (this.sourceFeatures != null) {
            return this.sourceFeatures.size();
        }
        return 0;
    }

    public final boolean containsSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.sourceFeatures != null) {
            return this.sourceFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getSourceFeature(String string) {
        if (this.sourceFeatures != null) {
            return this.sourceFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getSourceFeatureIterator() {
        if (this.sourceFeatures != null) {
            return this.sourceFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.sourceFeatures != null && this.sourceFeatures.remove(mIRFeature)) {
            mIRFeature.sourceOfFeatureMaps.remove(this);
            if (mIRFeature.sourceOfFeatureMaps.isEmpty()) {
                mIRFeature.sourceOfFeatureMaps = null;
            }
            if (this.sourceFeatures.isEmpty()) {
                this.sourceFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceFeatures() {
        if (this.sourceFeatures != null) {
            for (MIRFeature mIRFeature : this.sourceFeatures) {
                mIRFeature.sourceOfFeatureMaps.remove(this);
                if (!mIRFeature.sourceOfFeatureMaps.isEmpty()) continue;
                mIRFeature.sourceOfFeatureMaps = null;
            }
            this.sourceFeatures = null;
        }
    }

    protected MIRObjectCollection<MIRUsedParameter> getUsedParameterCollection() {
        this.usedParameters = MIRObjectCollections.get(this.usedParameters, MIRSdkCollection.Type.NAME);
        return this.usedParameters;
    }

    public SortedSet<MIRUsedParameter> getUsedParameters() {
        return MIRObjectCollections.sortedSet(this.usedParameters);
    }

    public final void addUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "UsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "UsedParameter"));
        }
        if (mIRUsedParameter.hasFeatureMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UsedParameter", "FeatureMap"));
        }
        if (this.usedParameters != null) {
            if (this.usedParameters.contains(mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "UsedParameter"));
            }
            if (!this._allowName(this.usedParameters, mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("FeatureMap", this.getPath(), "UsedParameter", "Name", mIRUsedParameter.getPath()));
            }
        }
        this.getUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.hasFeatureMap = this;
    }

    public final boolean addUsedParameterUniqueName(MIRUsedParameter mIRUsedParameter) {
        return this.addUsedParameterUniqueName(mIRUsedParameter, '/');
    }

    public final boolean addUsedParameterUniqueName(MIRUsedParameter mIRUsedParameter, char c) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FeatureMap", "UsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FeatureMap", "UsedParameter"));
        }
        if (mIRUsedParameter.hasFeatureMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UsedParameter", "FeatureMap"));
        }
        boolean bl = false;
        if (this.usedParameters != null) {
            if (this.usedParameters.contains(mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FeatureMap", "UsedParameter"));
            }
            if (!this._allowName(this.usedParameters, mIRUsedParameter)) {
                mIRUsedParameter._rename(mIRUsedParameter._setUniqueName(this.usedParameters, c));
                bl = true;
            }
        }
        this.getUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.hasFeatureMap = this;
        return bl;
    }

    public final int getUsedParameterCount() {
        if (this.usedParameters != null) {
            return this.usedParameters.size();
        }
        return 0;
    }

    public final boolean containsUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usedParameters != null) {
            return this.usedParameters.contains(mIRUsedParameter);
        }
        return false;
    }

    public final MIRUsedParameter getUsedParameter(String string) {
        if (this.usedParameters != null) {
            return this.usedParameters.get(string);
        }
        return null;
    }

    public final Iterator<MIRUsedParameter> getUsedParameterIterator() {
        if (this.usedParameters != null) {
            return this.usedParameters.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usedParameters != null && this.usedParameters.remove(mIRUsedParameter)) {
            mIRUsedParameter.hasFeatureMap = null;
            if (this.usedParameters.isEmpty()) {
                this.usedParameters = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsedParameters() {
        if (this.usedParameters != null) {
            for (MIRUsedParameter mIRUsedParameter : this.usedParameters) {
                mIRUsedParameter.hasFeatureMap = null;
            }
            this.usedParameters = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 78, "FeatureMap", false);
            new MIRMetaAttribute(metaClass, 67, "Operation", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 175, "Position", "java.lang.Short", null, (short)0);
            new MIRMetaAttribute(metaClass, 517, "Bulk", "java.lang.Boolean", null, false);
            new MIRMetaAttribute(metaClass, 533, "Constant", "java.lang.Boolean", null, false);
            new MIRMetaLink(metaClass, 117, "ClassifierMap", true, 2, 76, 68);
            new MIRMetaLink(metaClass, 547, "ControlFeature", false, 0, 77, 548);
            new MIRMetaLink(metaClass, 119, "DestinationFeature", true, 0, 77, 113);
            new MIRMetaLink(metaClass, 300, "Expression", true, 3, 112, 288);
            new MIRMetaLink(metaClass, 118, "SourceFeature", false, 0, 77, 112);
            new MIRMetaLink(metaClass, 794, "UsedParameter", false, 3, 268, 793);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRFeatureMap.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasClassifierMap != null) {
            this.hasClassifierMap.featureMaps.rename(this, string);
        }
        if (this.controlFeatures != null) {
            for (MIRFeature mIRFeature : this.controlFeatures) {
                mIRFeature.controlOfFeatureMaps.rename(this, string);
            }
        }
        if (this.hasDestinationFeature != null) {
            this.hasDestinationFeature.destinationOfFeatureMaps.rename(this, string);
        }
        if (this.sourceFeatures != null) {
            for (MIRFeature mIRFeature : this.sourceFeatures) {
                mIRFeature.sourceOfFeatureMaps.rename(this, string);
            }
        }
        super._rename(string);
    }
}

