/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRConnectionElement
extends MIRElement {
    protected transient String aExternalId = "";
    protected transient MIRObjectCollection<MIRElement> definedElements = null;
    protected transient MIRObjectCollection<MIRFeature> domainOfFeatures = null;
    protected transient MIRStoreConnection hasStoreConnection = null;
    private static MIRMetaClass metaClass = MIRConnectionElement.staticGetMetaClass();

    public MIRConnectionElement() {
    }

    public MIRConnectionElement(MIRConnectionElement mIRConnectionElement) {
        this.setFrom(mIRConnectionElement);
    }

    @Override
    public Object clone() {
        return new MIRConnectionElement(this);
    }

    @Override
    public short getElementType() {
        return 317;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)317)) {
            this.setExternalId(((MIRConnectionElement)mIR_Object).getExternalId());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasStoreConnection != null) {
            return this.hasStoreConnection;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasStoreConnection != null ? 1 : 0) + super.getParentCount();
    }

    public final void setExternalId(String string) {
        this.aExternalId = string == null ? "" : string;
    }

    public final String getExternalId() {
        return this.aExternalId;
    }

    protected MIRObjectCollection<MIRElement> getDefinedElementCollection() {
        this.definedElements = MIRObjectCollections.get(this.definedElements, MIRSdkCollection.Type.OBJECT);
        return this.definedElements;
    }

    public SortedSet<MIRElement> getDefinedElements() {
        return MIRObjectCollections.sortedSet(this.definedElements);
    }

    public final void addDefinedElement(MIRElement mIRElement) {
        if (mIRElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectionElement", "DefinedElement"));
        }
        if (mIRElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectionElement", "DefinedElement"));
        }
        if (mIRElement.hasDefinedByConnectionElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Element", "DefinedByConnectionElement"));
        }
        if (this.definedElements != null && this.definedElements.contains(mIRElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectionElement", "DefinedElement"));
        }
        this.getDefinedElementCollection().add(mIRElement);
        mIRElement.hasDefinedByConnectionElement = this;
    }

    public final int getDefinedElementCount() {
        if (this.definedElements != null) {
            return this.definedElements.size();
        }
        return 0;
    }

    public final boolean containsDefinedElement(MIRElement mIRElement) {
        if (mIRElement != null && this.definedElements != null) {
            return this.definedElements.contains(mIRElement);
        }
        return false;
    }

    public final MIRElement getDefinedElement(String string) {
        if (this.definedElements != null) {
            return this.definedElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRElement> getDefinedElementIterator() {
        if (this.definedElements != null) {
            return this.definedElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDefinedElement(MIRElement mIRElement) {
        if (mIRElement != null && this.definedElements != null && this.definedElements.remove(mIRElement)) {
            mIRElement.hasDefinedByConnectionElement = null;
            if (this.definedElements.isEmpty()) {
                this.definedElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDefinedElements() {
        if (this.definedElements != null) {
            for (MIRElement mIRElement : this.definedElements) {
                mIRElement.hasDefinedByConnectionElement = null;
            }
            this.definedElements = null;
        }
    }

    protected MIRObjectCollection<MIRFeature> getDomainOfFeatureCollection() {
        this.domainOfFeatures = MIRObjectCollections.get(this.domainOfFeatures, MIRSdkCollection.Type.OBJECT);
        return this.domainOfFeatures;
    }

    public SortedSet<MIRFeature> getDomainOfFeatures() {
        return MIRObjectCollections.sortedSet(this.domainOfFeatures);
    }

    public final void addDomainOfFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectionElement", "DomainOfFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectionElement", "DomainOfFeature"));
        }
        if (mIRFeature.hasDomainConnectionElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Feature", "DomainConnectionElement"));
        }
        if (this.domainOfFeatures != null && this.domainOfFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectionElement", "DomainOfFeature"));
        }
        this.getDomainOfFeatureCollection().add(mIRFeature);
        mIRFeature.hasDomainConnectionElement = this;
    }

    public final int getDomainOfFeatureCount() {
        if (this.domainOfFeatures != null) {
            return this.domainOfFeatures.size();
        }
        return 0;
    }

    public final boolean containsDomainOfFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.domainOfFeatures != null) {
            return this.domainOfFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getDomainOfFeature(String string) {
        if (this.domainOfFeatures != null) {
            return this.domainOfFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getDomainOfFeatureIterator() {
        if (this.domainOfFeatures != null) {
            return this.domainOfFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDomainOfFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.domainOfFeatures != null && this.domainOfFeatures.remove(mIRFeature)) {
            mIRFeature.hasDomainConnectionElement = null;
            if (this.domainOfFeatures.isEmpty()) {
                this.domainOfFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDomainOfFeatures() {
        if (this.domainOfFeatures != null) {
            for (MIRFeature mIRFeature : this.domainOfFeatures) {
                mIRFeature.hasDomainConnectionElement = null;
            }
            this.domainOfFeatures = null;
        }
    }

    public final void addStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectionElement", "StoreConnection"));
        }
        if (mIRStoreConnection._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectionElement", "StoreConnection"));
        }
        if (this.hasStoreConnection != null) {
            if (this.hasStoreConnection._equals(mIRStoreConnection)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectionElement", "StoreConnection"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionElement", "StoreConnection"));
        }
        this.hasStoreConnection = mIRStoreConnection;
        mIRStoreConnection.getConnectionElementCollection().add(this);
    }

    public final MIRStoreConnection getStoreConnection() {
        return this.hasStoreConnection;
    }

    public final boolean removeStoreConnection() {
        if (this.hasStoreConnection != null) {
            this.hasStoreConnection.connectionElements.remove(this);
            if (this.hasStoreConnection.connectionElements.isEmpty()) {
                this.hasStoreConnection.connectionElements = null;
            }
            this.hasStoreConnection = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 317, "ConnectionElement", false);
            new MIRMetaAttribute(metaClass, 394, "ExternalId", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 1034, "DefinedElement", false, 0, 0, 1035);
            new MIRMetaLink(metaClass, 1040, "DomainOfFeature", false, 0, 77, 1041);
            new MIRMetaLink(metaClass, 938, "StoreConnection", true, 2, 216, 939);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRConnectionElement.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasStoreConnection != null) {
            this.hasStoreConnection.connectionElements.rename(this, string);
        }
        super._rename(string);
    }
}

