/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRConnectionDataPackage
extends MIRDataPackage {
    protected transient MIRObjectCollection<MIRClassifier> classifiers = null;
    private static MIRMetaClass metaClass = MIRConnectionDataPackage.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 356;
    }

    protected MIRObjectCollection<MIRClassifier> getClassifierCollection() {
        this.classifiers = MIRObjectCollections.get(this.classifiers, MIRSdkCollection.Type.OBJECT);
        return this.classifiers;
    }

    public SortedSet<MIRClassifier> getClassifiers() {
        return MIRObjectCollections.sortedSet(this.classifiers);
    }

    public final void addClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectionDataPackage", "Classifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectionDataPackage", "Classifier"));
        }
        if (mIRClassifier.hasConnectionDataPackage != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Classifier", "ConnectionDataPackage"));
        }
        if (this.classifiers != null && this.classifiers.contains(mIRClassifier)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectionDataPackage", "Classifier"));
        }
        this.getClassifierCollection().add(mIRClassifier);
        mIRClassifier.hasConnectionDataPackage = this;
    }

    public final int getClassifierCount() {
        if (this.classifiers != null) {
            return this.classifiers.size();
        }
        return 0;
    }

    public final boolean containsClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.classifiers != null) {
            return this.classifiers.contains(mIRClassifier);
        }
        return false;
    }

    public final MIRClassifier getClassifier(String string) {
        if (this.classifiers != null) {
            return this.classifiers.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifier> getClassifierIterator() {
        if (this.classifiers != null) {
            return this.classifiers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.classifiers != null && this.classifiers.remove(mIRClassifier)) {
            mIRClassifier.hasConnectionDataPackage = null;
            if (this.classifiers.isEmpty()) {
                this.classifiers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeClassifiers() {
        if (this.classifiers != null) {
            for (MIRClassifier mIRClassifier : this.classifiers) {
                mIRClassifier.hasConnectionDataPackage = null;
            }
            this.classifiers = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRDataPackage.staticGetMetaClass(), 356, "ConnectionDataPackage", true);
            new MIRMetaLink(metaClass, 633, "Classifier", false, 0, 75, 634);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRConnectionDataPackage.staticGetMetaClass();
    }
}

