/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.config.impl;

import com.sas.framework.config.Application;
import com.sas.framework.config.ApplicationConfiguration;
import com.sas.framework.config.ApplicationNotFoundException;
import com.sas.framework.config.ApplicationRegistration;
import com.sas.framework.config.ConfigurationServiceInterface;
import com.sas.framework.config.SiteConfiguration;
import com.sas.framework.config.UrlGeneratorInterface;
import com.sas.framework.config.dao.ApplicationDAOInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
@Deprecated
public class ConfigurationService
implements ConfigurationServiceInterface,
UrlGeneratorInterface {
    private ApplicationDAOInterface dao;
    private Map map = new ConcurrentHashMap();
    private String[] platformVersions = new String[]{"9.4", "9.3", "9.2"};

    public void setApplicationDAO(ApplicationDAOInterface d) {
        this.dao = d;
    }

    @Override
    @ManagedOperation(description="Reload the configuration data")
    public void reload() {
        this.dao.reload();
    }

    @Override
    public SiteConfiguration getSiteConfiguration() {
        SiteConfiguration siteConfig = new SiteConfiguration();
        siteConfig.setConfiguration(this.getSettings("SAS Application Infrastructure"));
        return siteConfig;
    }

    @Override
    public List getApplications() {
        List data = this.dao.getAll();
        data.addAll(this.map.values());
        return data;
    }

    @Override
    @ManagedAttribute(description="Registered application names")
    public List getApplicationNames() {
        ArrayList<String> l = new ArrayList<String>();
        List all = this.getApplications();
        for (Application app : all) {
            l.add(app.getName());
        }
        return l;
    }

    @Override
    public Application getApplication(String name) {
        if (null == name) {
            throw new NullPointerException("You must specify a non-null name to retrieve an application.");
        }
        Application app = this._getApplication(name);
        if (null == app && name.contains("Logon Manager")) {
            for (String version : this.platformVersions) {
                app = this._getApplication("Logon Manager " + version);
                if (null != app) break;
            }
        }
        if (null == app) {
            throw new ApplicationNotFoundException("Application '" + name + "' does not exist. Is it appropriately registered for the underlying data implementation?");
        }
        return app;
    }

    private Application _getApplication(String name) {
        Application app = this.dao.getApplication(name);
        if (null == app) {
            app = (Application)this.map.get(name);
        }
        return app;
    }

    @Override
    public ApplicationConfiguration getConfiguration(String name) {
        Application app = this.getApplication(name);
        return app.getConfiguration();
    }

    @Override
    public ApplicationRegistration getRegistration(String name) {
        Application app = this.getApplication(name);
        return app.getRegistration();
    }

    @Override
    public Properties getSettings(String name) {
        Application app = this.getApplication(name);
        return app.getSettings();
    }

    @Override
    public void register(Application application) {
        String name = application.getName();
        if (this.isRegistered(name)) {
            throw new IllegalArgumentException("Application '" + name + "' is already registered.");
        }
        this.map.put(name, application);
    }

    @Override
    public List getRegistrations() {
        ArrayList<ApplicationRegistration> l = new ArrayList<ApplicationRegistration>();
        List applications = this.getApplications();
        for (Application a : applications) {
            ApplicationRegistration r = a.getRegistration();
            if (null == r) continue;
            l.add(r);
        }
        return l;
    }

    @Override
    public boolean isRegistered(String name) {
        boolean found = this.map.containsKey(name);
        if (found) {
            return found;
        }
        return null != this.dao.getApplication(name);
    }

    @Override
    public void unregister(String name) {
        if (null == name) {
            throw new NullPointerException("Must provide name to be unregistered.");
        }
        if (null != this.dao.getApplication(name)) {
            throw new IllegalArgumentException("You may only unregister applications that are programmatically registered. Those being provided by the data layer cannot be removed.");
        }
        if (!this.map.containsKey(name)) {
            throw new ApplicationNotFoundException("Attempt to unregister non-existent application.");
        }
        this.map.remove(name);
    }

    @Override
    public String generateUrl(String application, String path, Properties parameters) {
        StringBuffer parms = new StringBuffer();
        if (null != parameters) {
            Iterator<Object> it = parameters.keySet().iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                parms.append(next).append("=").append(parameters.getProperty(next));
                if (!it.hasNext()) continue;
                parms.append("&");
            }
        }
        return this.generateUrl(application, path, parms.toString());
    }

    @Override
    public String generateUrl(String application, String path, String parameters) {
        StringBuffer url = new StringBuffer(20);
        ApplicationRegistration registration = this.getRegistration(application);
        if (null == registration) {
            return "";
        }
        String root = registration.getUrl();
        url.append(root);
        if (null != path && !"".equals(path)) {
            if (!root.endsWith("/") && !path.startsWith("/")) {
                url.append("/");
            }
            url.append(path);
        }
        if (null != parameters && !"".equals(parameters)) {
            if (root.indexOf("?") >= 0 || path.indexOf("?") >= 0) {
                url.append("&");
            } else {
                url.append("?");
            }
            url.append(parameters);
        }
        return url.toString();
    }

    @Override
    public String getRootUrl(String application) {
        ApplicationRegistration registration = this.getRegistration(application);
        return registration.getUrl();
    }

    @Override
    public String getRootIPUrl(String application) {
        ApplicationRegistration registration = this.getRegistration(application);
        return registration.getIPUrl();
    }
}

