/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VersionInfo {
    private boolean versionParsed;
    private boolean dateParsed;
    private String version;
    private String majorVersion;
    private String minorVersion;
    private String microVersion;
    private Package p;
    private Date date = null;
    private String dateString;
    private SimpleDateFormat dateFormat = null;

    private VersionInfo(String classname) throws ClassNotFoundException {
        this.p = Class.forName(classname).getPackage();
    }

    public static VersionInfo getVersionInfo(String classname) throws ClassNotFoundException {
        return new VersionInfo(classname);
    }

    public String getImplementationVersion() {
        return this.p.getImplementationVersion();
    }

    public String getSpecificationVersion() {
        return this.p.getSpecificationVersion();
    }

    public String getMajorVersion() {
        this.parseBuildVersions();
        return this.majorVersion;
    }

    public String getMinorVersion() {
        this.parseBuildVersions();
        return this.minorVersion;
    }

    public String getMicroVersion() {
        this.parseBuildVersions();
        return this.microVersion;
    }

    public String getBuildVersion() {
        this.parseBuildVersions();
        return this.version;
    }

    public Date getBuildDate() {
        return this.getBuildDate(Locale.getDefault());
    }

    public Date getBuildDate(Locale locale) {
        try {
            this.parseBuildDate(locale);
            return this.date;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public String getBuildDateString() {
        return this.getBuildDateString(Locale.getDefault());
    }

    public String getBuildDateString(Locale locale) {
        try {
            this.parseBuildDate(locale);
            return this.dateString;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private void parseBuildDate(Locale locale) throws ParseException {
        String versionInfo;
        if (this.dateParsed) {
            return;
        }
        this.dateParsed = true;
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null != (versionInfo = this.p.getImplementationVersion())) {
            this.dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", locale);
            String[] field = versionInfo.split("\\.");
            this.date = this.dateFormat.parse(field[3]);
            this.dateString = DateFormat.getDateInstance(1, locale).format(this.date) + " " + DateFormat.getTimeInstance(1, locale).format(this.date);
        }
    }

    private void parseBuildVersions() {
        if (this.versionParsed) {
            return;
        }
        this.versionParsed = true;
        String versionInfo = this.p.getImplementationVersion();
        if (null == versionInfo) {
            return;
        }
        String[] field = versionInfo.split("\\.");
        String versionString = field[0];
        int len = versionString.length();
        this.majorVersion = versionString.substring(0, len - 5);
        this.minorVersion = versionString.substring(len - 5, len - 3);
        this.microVersion = versionString.substring(len - 3);
        this.version = this.majorVersion + "." + this.minorVersion + "." + this.microVersion;
    }
}

