/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MimeTypeMapper {
    private static Map<String, String> extensionToMime = new HashMap<String, String>();
    private static Map<String, String> mimeToExtension = new HashMap<String, String>();
    private static Map<String, String> mimeToImage = new HashMap<String, String>();
    private static final Logger logger = LogManager.getLogger(MimeTypeMapper.class);
    private static final String DEFAULT_TYPE = "application/octet-stream";

    private MimeTypeMapper() {
    }

    public static String getMimeType(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        String ext = fileName.substring(index + 1);
        return MimeTypeMapper.getMimeTypeFromExtension(ext);
    }

    public static String getMimeTypeFromExtension(String ext) {
        ext = ext.toLowerCase();
        String mime = extensionToMime.get(ext);
        return mime;
    }

    public static String getExtension(String mimeType) {
        mimeType = mimeType.toLowerCase();
        return mimeToExtension.get(mimeType);
    }

    public static String getImage(String mimeType) {
        String image = mimeToImage.get(mimeType);
        if (null == image) {
            image = "DocTypeDocument.gif";
        }
        return image;
    }

    public static String getDefaultMimeType() {
        return DEFAULT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMap() throws IOException {
        String mime;
        StringTokenizer tokens;
        String next;
        InputStream is = null;
        InputStreamReader isReader = null;
        BufferedReader reader = null;
        ClassLoader loader = MimeTypeMapper.class.getClassLoader();
        Enumeration<URL> resources = loader.getResources("META-INF/mimetypes.txt");
        while (resources.hasMoreElements()) {
            try {
                is = resources.nextElement().openStream();
                isReader = new InputStreamReader(is);
                reader = new BufferedReader(isReader);
                while (null != (next = reader.readLine())) {
                    if (next.startsWith("#")) continue;
                    tokens = new StringTokenizer(next);
                    mime = tokens.nextToken();
                    String ext = tokens.nextToken().toLowerCase();
                    extensionToMime.put(ext, mime);
                    mimeToExtension.put(mime, ext);
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        if (0 == token.length()) continue;
                        extensionToMime.put(token, mime);
                    }
                }
            }
            finally {
                if (null == reader) continue;
                reader.close();
            }
        }
        resources = loader.getResources("META-INF/mimeimages.txt");
        while (resources.hasMoreElements()) {
            try {
                is = resources.nextElement().openStream();
                isReader = new InputStreamReader(is);
                reader = new BufferedReader(isReader);
                while (null != (next = reader.readLine())) {
                    if (next.startsWith("#")) continue;
                    tokens = new StringTokenizer(next);
                    mime = tokens.nextToken();
                    String image = tokens.nextToken();
                    mimeToImage.put(mime, image);
                }
            }
            finally {
                if (null == reader) continue;
                reader.close();
            }
        }
    }

    static {
        try {
            MimeTypeMapper.loadMap();
        }
        catch (IOException ioe) {
            logger.fatal("Failed to load mime type map: " + ioe, (Throwable)ioe);
        }
    }
}

