/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.util.Locale;

public class LocaleUtil {
    private LocaleUtil() {
    }

    public static Locale getLocaleFromString(String localeString) {
        if (null == localeString) {
            return Locale.getDefault();
        }
        String[] tokens = localeString.split("_");
        return LocaleUtil.tokenize(tokens);
    }

    public static Locale getLocaleFromXml(String lang) {
        if (null == lang) {
            return Locale.getDefault();
        }
        String[] tokens = lang.split("-");
        return LocaleUtil.tokenize(tokens);
    }

    private static Locale tokenize(String[] tokens) {
        Locale locale = null;
        if (null == tokens) {
            return Locale.getDefault();
        }
        switch (tokens.length) {
            case 1: {
                locale = new Locale(tokens[0], "");
                break;
            }
            case 2: {
                locale = new Locale(tokens[0], tokens[1]);
                break;
            }
            case 3: {
                locale = new Locale(tokens[0], tokens[1], tokens[2]);
                break;
            }
            case 4: {
                locale = new Locale(tokens[0], tokens[1], tokens[2] + '_' + tokens[3]);
            }
        }
        return locale;
    }
}

