/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class HttpUtil {
    private static final Logger logger = LogManager.getLogger(HttpUtil.class);
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";

    public static String readUrl(URL url, int maxTries, int sleepTime, String subnet) throws IOException {
        return HttpUtil.readUrl(url, maxTries, sleepTime, subnet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(URL url, int maxTries, int sleepTime, String subnet, String proxyPrefix) throws IOException {
        String retval = null;
        int tries = 0;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(sleepTime - 500).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        String host = url.getHost();
        boolean abortLoop = false;
        String proxyHost = null;
        String proxyPortStr = null;
        boolean useProxy = false;
        int proxyPort = 0;
        if (StringUtils.hasText((String)subnet)) {
            try {
                InetAddress clientInterface = HttpUtil.locateInterface(subnet);
                proxyHost = clientInterface.getHostAddress();
                proxyPort = HttpUtil.getRandomClientPort();
                useProxy = true;
            }
            catch (SocketException e) {
                logger.error("Exception getting connection to " + url + ": " + e.getMessage(), (Throwable)e);
            }
        } else if (null != proxyPrefix) {
            if (!proxyPrefix.endsWith(".")) {
                proxyPrefix = proxyPrefix + ".";
            }
            proxyHost = System.getProperty(proxyPrefix + PROXY_HOST);
            proxyPortStr = System.getProperty(proxyPrefix + PROXY_PORT);
            if (proxyHost != null && proxyPortStr != null) {
                try {
                    proxyPort = Integer.parseInt(proxyPortStr);
                    useProxy = true;
                }
                catch (NumberFormatException e) {
                    logger.error(proxyPrefix + PROXY_HOST + "=" + proxyHost + " : " + proxyPrefix + PROXY_PORT + "=" + proxyPort, (Throwable)e);
                }
            } else if (proxyHost != null && proxyPortStr == null || proxyHost == null && proxyPortStr != null) {
                logger.debug("A proxy prefix was provided but one or more values were not found; " + proxyPrefix + PROXY_HOST + "=" + proxyHost + " : " + proxyPrefix + PROXY_PORT + "=" + proxyPort);
            }
        }
        HttpGet method = null;
        while (tries < maxTries) {
            if (tries > 0) {
                logger.info("HttpUtil tries:" + tries);
            }
            try {
                if (useProxy) {
                    HttpHost httpProxy = new HttpHost(proxyHost, proxyPort);
                    httpClientBuilder.setProxy(httpProxy);
                }
                CloseableHttpClient client = httpClientBuilder.build();
                String protocol = url.getProtocol();
                if (null == protocol) {
                    protocol = "http";
                }
                method = new HttpGet(url.toString());
                char leadingChar = host.toLowerCase().charAt(0);
                boolean needHostHeader = true;
                if (leadingChar == 'l' && host.equalsIgnoreCase("localhost")) {
                    needHostHeader = false;
                } else if (leadingChar >= '0' && leadingChar <= '9') {
                    needHostHeader = false;
                }
                if (needHostHeader) {
                    StringBuffer hostHeader = new StringBuffer();
                    int port = url.getPort();
                    if (port == -1) {
                        if ("http".equalsIgnoreCase(protocol)) {
                            port = 80;
                        } else if ("https".equalsIgnoreCase(protocol)) {
                            port = 443;
                        }
                    }
                    hostHeader.append(url.getHost()).append(":").append(port);
                    try {
                        method.setHeader("Host", hostHeader.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                HttpResponse httpResponse = client.execute((HttpUriRequest)method);
                switch (httpResponse.getStatusLine().getStatusCode()) {
                    case 200: {
                        HttpEntity entity = httpResponse.getEntity();
                        retval = EntityUtils.toString((HttpEntity)entity);
                        abortLoop = true;
                        break;
                    }
                    case 404: {
                        retval = null;
                        logger.error("ERROR 404 url: " + url);
                        ++tries;
                        break;
                    }
                    default: {
                        retval = null;
                        ++tries;
                    }
                }
                if (abortLoop) {
                    break;
                }
            }
            catch (IOException e) {
                retval = null;
                if (logger.isDebugEnabled()) {
                    logger.debug("url: " + url.toString(), (Throwable)e);
                }
                ++tries;
            }
            finally {
                if (null != method) {
                    method.releaseConnection();
                }
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                logger.error("url: " + url, (Throwable)e);
            }
        }
        if (null == retval) {
            logger.error("resource not found: url: " + url);
        }
        return retval;
    }

    private static int getRandomClientPort() {
        Random r = new Random(System.currentTimeMillis());
        long range = 24001L;
        long fraction = (long)((double)range * r.nextDouble());
        return (int)(fraction + 24000L);
    }

    private static InetAddress locateInterface(String subnet) throws SocketException {
        InetAddress retval = null;
        Enumeration<NetworkInterface> outer = NetworkInterface.getNetworkInterfaces();
        block0: while (outer.hasMoreElements()) {
            NetworkInterface ni = outer.nextElement();
            Enumeration<InetAddress> inner = ni.getInetAddresses();
            while (inner.hasMoreElements()) {
                InetAddress addr = inner.nextElement();
                String textAddr = addr.getHostAddress();
                if (!textAddr.startsWith(subnet)) continue;
                retval = addr;
                continue block0;
            }
        }
        return retval;
    }
}

