/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import com.sas.framework.commons.util.HttpClientUtil;
import com.sas.framework.commons.util.ResponseRetriever;
import java.io.IOException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClientResponseRetriever
implements ResponseRetriever {
    private static final Logger _logger = LogManager.getLogger(HttpClientResponseRetriever.class);
    private HttpClientUtil _httpClientUtil = new HttpClientUtil();

    @Override
    public String getResponseFromServer(URL url) {
        CredentialsProvider provider;
        String str = url.toString();
        if (_logger.isDebugEnabled()) {
            _logger.debug("requesting response from URL: " + str);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        HttpHost httpHost = this._httpClientUtil.getHttpHost(url);
        if (null != httpHost) {
            httpClientBuilder.setProxy(httpHost);
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting proxy:" + httpHost);
            }
        }
        if (null != (provider = this._httpClientUtil.getProvider())) {
            httpClientBuilder.setDefaultCredentialsProvider(provider);
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting provider: " + provider);
            }
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        String body = null;
        HttpGet httpGet = new HttpGet(str);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            int httpStatus = httpResponse.getStatusLine().getStatusCode();
            if (200 == httpStatus) {
                body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                _logger.debug("request OK");
            } else {
                String statusText = httpResponse.getStatusLine().getReasonPhrase();
                _logger.warn("request not OK: " + statusText);
            }
        }
        catch (IOException e) {
            _logger.error("request failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return body;
    }

    public void setHttpClientUtil(HttpClientUtil httpClientUtil) {
        this._httpClientUtil = httpClientUtil;
    }
}

