/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CollectionUtil {
    public static boolean areInstances(Collection c, Class clazz) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (clazz.isInstance(itr.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Collection a, Collection b, Comparator c) {
        if (a == b) {
            return true;
        }
        if (null == a || null == b) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator aItr = a.iterator();
        Iterator bItr = b.iterator();
        while (aItr.hasNext()) {
            if (0 == c.compare(aItr.next(), bItr.next())) continue;
            return false;
        }
        return true;
    }

    public static String toString(Collection collection, String delimiter) {
        StringBuffer sb = new StringBuffer();
        CollectionUtil.toString(sb, collection, delimiter);
        return sb.toString();
    }

    public static void toString(StringBuffer sb, Collection collection, String delimiter) {
        if (null == sb) {
            return;
        }
        Iterator itr = collection.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append(delimiter);
        }
    }

    public static Map toMap(Collection collection) {
        HashMap map = new HashMap(collection.size());
        return CollectionUtil.toMap(map, collection);
    }

    public static Map toMap(Map map, Collection collection) {
        for (Object val : collection) {
            map.put(val, val);
        }
        return map;
    }

    public static Collection flatten(Collection c) {
        ArrayList values = new ArrayList(c.size());
        for (Object o : c) {
            if (o instanceof Collection) {
                values.addAll((Collection)o);
                continue;
            }
            values.add(o);
        }
        return values;
    }

    public static Map flatten(Map m) {
        HashMap values = new HashMap(m.size());
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            if (value instanceof Map) {
                values.putAll((Map)value);
                continue;
            }
            values.put(key, value);
        }
        return values;
    }
}

