/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import com.sas.framework.commons.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Comparator;

public final class ArrayUtil {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Comparator SHORT_ARRAY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ArrayUtil.compare((short[])o1, (short[])o2);
        }
    };
    public static final Comparator INT_ARRAY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ArrayUtil.compare((int[])o1, (int[])o2);
        }
    };

    public static void affirmNoNulls(String name, Object[] array) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (null != array[i]) continue;
                if (null == name) {
                    throw new RuntimeException("null array entry at index " + i);
                }
                throw new IllegalArgumentException(name + " has a null entry at index " + i);
            }
        }
    }

    public static int compare(Object[] o1, Object[] o2) {
        int rv = 0;
        for (int i = 0; i < o1.length && 0 == rv; ++i) {
            rv = ((Comparable)o1[i]).compareTo(o2[i]);
        }
        return rv;
    }

    public static int compare(int[] a1, int[] a2) {
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] < a2[i]) {
                return -1;
            }
            if (a1[i] <= a2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static int compare(short[] a1, short[] a2) {
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] < a2[i]) {
                return -1;
            }
            if (a1[i] <= a2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static void affirmNoNulls(Object[] array) {
        ArrayUtil.affirmNoNulls(null, array);
    }

    public static void affirmNotEmpty(Object[] array) {
        ArrayUtil.affirmNotEmpty(null, array);
    }

    public static void affirmNotEmpty(String name, Object[] array) {
        ObjectUtil.affirmNotNull(name, array);
        if (0 == array.length) {
            if (null == name) {
                throw new RuntimeException("empty array");
            }
            throw new RuntimeException(name + " is an empty array");
        }
    }

    public static ArrayList toList(Object[][] arrays) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < arrays.length; ++i) {
            for (int j = 0; j < arrays[i].length; ++j) {
                list.add(arrays[i][j]);
            }
        }
        return list;
    }

    public static int indexOfNull(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (null != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int x) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != x) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int x) {
        return ArrayUtil.indexOf(array, x) >= 0;
    }

    public static String toString(Object array, String delimiter) {
        Class<?> type = array.getClass().getComponentType();
        if (null == type) {
            throw new IllegalArgumentException("the argument is not an array");
        }
        if (Object.class.isAssignableFrom(type)) {
            return ArrayUtil.toString((Object[])array, delimiter);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return ArrayUtil.toString((int[])array, delimiter);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return ArrayUtil.toString((long[])array, delimiter);
        }
        throw new IllegalArgumentException("arrays of type \"" + type.getName() + "\" are not supported (you'll have to add it)");
    }

    public static String toString(Object[] array, String delimiter) {
        StringBuffer sb = new StringBuffer();
        ArrayUtil.toString(sb, array, delimiter);
        return sb.toString();
    }

    public static void toString(StringBuffer sb, Object[] array, String delimiter) {
        ArrayUtil.toString(sb, array, 0, delimiter);
    }

    public static void toString(StringBuffer sb, Object[] array, int start, String delimiter) {
        for (int i = start; i < array.length; ++i) {
            if (i > start) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
    }

    public static String toString(int[] array, String delimiter) {
        StringBuffer sb = new StringBuffer(array.length * 8);
        ArrayUtil.toString(sb, array, delimiter);
        return sb.toString();
    }

    public static String toString(long[] array, String delimiter) {
        StringBuffer sb = new StringBuffer(array.length * 8);
        ArrayUtil.toString(sb, array, delimiter);
        return sb.toString();
    }

    public static String toString(short[] array, String delimiter) {
        StringBuffer sb = new StringBuffer(array.length * 8);
        ArrayUtil.toString(sb, array, delimiter);
        return sb.toString();
    }

    public static String toString(int[] array, int start, String delimiter) {
        StringBuffer sb = new StringBuffer((array.length - start) * 8);
        ArrayUtil.toString(sb, array, start, delimiter);
        return sb.toString();
    }

    public static String toString(long[] array, int start, String delimiter) {
        StringBuffer sb = new StringBuffer((array.length - start) * 8);
        ArrayUtil.toString(sb, array, start, delimiter);
        return sb.toString();
    }

    public static void toString(StringBuffer sb, int[] array, String delimiter) {
        ArrayUtil.toString(sb, array, 0, delimiter);
    }

    public static void toString(StringBuffer sb, long[] array, String delimiter) {
        ArrayUtil.toString(sb, array, 0, delimiter);
    }

    public static void toString(StringBuffer sb, int[] array, int start, String delimiter) {
        for (int i = start; i < array.length; ++i) {
            if (i > start) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
    }

    public static void toString(StringBuffer sb, long[] array, int start, String delimiter) {
        for (int i = start; i < array.length; ++i) {
            if (i > start) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
    }

    public static String toString(short[] array) {
        StringBuffer sb = new StringBuffer(array.length * 8);
        ArrayUtil.toString(sb, array, 0, ",");
        return sb.toString();
    }

    public static String toString(short[] array, int start, String delimiter) {
        StringBuffer sb = new StringBuffer((array.length - start) * 8);
        ArrayUtil.toString(sb, array, start, delimiter);
        return sb.toString();
    }

    public static void toString(StringBuffer sb, short[] array, String delimiter) {
        ArrayUtil.toString(sb, array, 0, delimiter);
    }

    public static void toString(StringBuffer sb, short[] array, int start, String delimiter) {
        for (int i = start; i < array.length; ++i) {
            if (i > start) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
    }
}

