/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.holders;

import com.sas.framework.commons.holders.GlobalHolderStrategy;
import com.sas.framework.commons.holders.HolderStrategy;
import com.sas.framework.commons.holders.InheritableThreadLocalHolderStrategy;
import com.sas.framework.commons.holders.ThreadLocalHolderStrategy;
import java.lang.reflect.Constructor;

public class HolderStrategyFactory {
    public static final String MODE_THREADLOCAL = "MODE_THREADLOCAL";
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String GENERIC_STRATEGY_PROPERTY_NAME = "sas.holder.strategy";
    private static final String DEFAULT_STRATEGY = System.getProperty("sas.holder.strategy", "MODE_INHERITABLETHREADLOCAL");

    public static <T> HolderStrategy<T> getStrategy(Class<T> type, String strategyName) {
        HolderStrategy strategy;
        if (null == strategyName || "".equals(strategyName.trim())) {
            strategyName = DEFAULT_STRATEGY;
        }
        if (MODE_INHERITABLETHREADLOCAL.equals(strategyName)) {
            strategy = new InheritableThreadLocalHolderStrategy();
        } else if (MODE_GLOBAL.equals(strategyName)) {
            strategy = new GlobalHolderStrategy();
        } else if (MODE_THREADLOCAL.equals(strategyName)) {
            strategy = new ThreadLocalHolderStrategy();
        } else {
            try {
                Class<?> strategyClass = Class.forName(strategyName);
                Constructor<?> constructor = strategyClass.getConstructor(new Class[0]);
                strategy = (HolderStrategy)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid class provided for SecurityContextHolderStrategy, " + strategyName, e);
            }
        }
        return strategy;
    }
}

