/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.holders;

import com.sas.framework.commons.holders.HolderStrategy;
import com.sas.framework.commons.holders.HolderStrategyFactory;

public class ClientApplicationNameHolder {
    private static final String DEFAULT_STRATEGY = System.getProperty("sas.application.name.holder.strategy", null);
    private static HolderStrategy<String> strategy;
    private static String baseApplicationName;

    private ClientApplicationNameHolder() {
    }

    public static void setName(String s) {
        ClientApplicationNameHolder.set(s);
    }

    public static String getName() {
        return ClientApplicationNameHolder.get();
    }

    public static void setStrategyName(String name) {
        strategy = HolderStrategyFactory.getStrategy(String.class, name);
    }

    public static void set(String s) {
        strategy.set(s);
    }

    public static String get() {
        String s = strategy.get();
        if (s != null) {
            return s;
        }
        return baseApplicationName;
    }

    public static void clear() {
        strategy.clear();
    }

    public static void setBaseApplicationName(String baseApplicationName) {
        ClientApplicationNameHolder.baseApplicationName = baseApplicationName;
    }

    public static String getBaseApplicationName() {
        return baseApplicationName;
    }

    public static String getFullApplicationName() {
        String s = strategy.get();
        if (baseApplicationName == null) {
            return s;
        }
        if (s == null) {
            return baseApplicationName;
        }
        return baseApplicationName + " - " + s;
    }

    static {
        baseApplicationName = null;
        ClientApplicationNameHolder.setStrategyName(DEFAULT_STRATEGY);
    }
}

