/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.login;

import com.sas.report.config.StartPFS;
import com.sas.services.ServiceException;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.util.login.LoginBean;
import com.sas.util.login.LoginBeanActionInterface;
import com.sas.util.login.LoginBeanSwingUtil;
import com.sas.util.login.LoginBeanValidateInterface;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

public class LoginBeanBIPValidate
implements LoginBeanValidateInterface {
    protected LoginBean loginBean;
    protected String securityPolicyFilename;
    protected String securityLoginConfigFilename;
    protected String pfsDeploymentFileURL;
    protected String softwareComponentName;
    protected String serviceDeploymentName;
    protected String domain;
    protected boolean debug;

    public LoginBeanBIPValidate() {
        this.init();
    }

    public LoginBeanBIPValidate(LoginBean bean) {
        this.init();
        this.setLoginBean(bean);
    }

    protected void init() {
        this.debug = false;
        this.securityPolicyFilename = null;
        this.securityLoginConfigFilename = null;
        this.serviceDeploymentName = "BIP Core Services";
    }

    public void setLoginBean(LoginBean bean) {
        this.loginBean = bean;
    }

    public LoginBean getLoginBean() {
        return this.loginBean;
    }

    public void setSecurityPolicy(String filename) {
        this.securityPolicyFilename = filename;
    }

    public String getSecurityPolicy() {
        return this.securityPolicyFilename;
    }

    public void setSecurityLoginConfig(String filename) {
        this.securityLoginConfigFilename = filename;
    }

    public String getSecurityLoginConfig() {
        return this.securityLoginConfigFilename;
    }

    public void setPFSDeploymentFileURL(String URL2) {
        this.pfsDeploymentFileURL = URL2;
    }

    public String getPFSDeploymentFileURL() {
        return this.pfsDeploymentFileURL;
    }

    public void setSoftwareComponentName(String name) {
        this.softwareComponentName = name;
    }

    public String getSoftwareComponentName() {
        return this.softwareComponentName;
    }

    public void setServiceDeploymentName(String name) {
        this.serviceDeploymentName = name;
    }

    public String getServiceDeploymentName() {
        return this.serviceDeploymentName;
    }

    public void setDomain(String value) {
        this.domain = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean validate(String username, String password) {
        if (this.securityPolicyFilename != null) {
            System.setProperty("java.security.policy", this.securityPolicyFilename);
        }
        if (this.securityLoginConfigFilename != null) {
            System.setProperty("java.security.auth.login.config", this.securityLoginConfigFilename);
        }
        boolean valid = false;
        try {
            StartPFS.deployPlatformServices((String)this.pfsDeploymentFileURL, (String)this.softwareComponentName);
            StartPFS.loginUser((String)username, (String)password, (String)this.domain);
            valid = true;
        }
        catch (MalformedURLException e) {
            LoggerRepository2.getLogger((String)LoginBeanBIPValidate.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)LoginBeanBIPValidate.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)LoginBeanBIPValidate.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            if (this.loginBean != null) {
                String s = e.toString();
                if (s.startsWith("com.sas.services.security.LoginServiceException")) {
                    this.loginBean.setFailureType(2);
                } else if (s.startsWith("com.sas.services.security.CredentialLoginServiceException")) {
                    this.loginBean.setFailureType(2);
                } else if (s.startsWith("com.sas.services.security.BadHostLoginServiceException")) {
                    this.loginBean.setFailureType(3);
                } else if (s.startsWith("com.sas.services.security.ConnectRefusedLoginServiceException")) {
                    this.loginBean.setFailureType(4);
                } else if (s.startsWith("com.sas.services.discovery.ServiceNotAvailableException")) {
                    this.loginBean.setFailureType(5);
                } else {
                    this.loginBean.setFailureType(1);
                }
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)LoginBeanBIPValidate.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            this.loginBean.setFailureType(1);
        }
        return valid;
    }

    public static void main(String[] argv) {
        LoginBean bean = new LoginBean();
        bean.setTitle("Enter your username and password:");
        bean.setAttempts(2);
        LoginBeanSwingUtil beanUtil = new LoginBeanSwingUtil(bean);
        bean.setActionHandler((LoginBeanActionInterface)beanUtil);
        LoginBeanBIPValidate BIPValidate = new LoginBeanBIPValidate(bean);
        bean.setValidateHandler((LoginBeanValidateInterface)BIPValidate);
        String pfsConfigFileBase = "C:\\AppDevStudio\\webAF\\resources";
        BIPValidate.setSecurityPolicy(pfsConfigFileBase + "\\policy");
        BIPValidate.setSecurityLoginConfig(pfsConfigFileBase + "\\login.config");
        BIPValidate.setPFSDeploymentFileURL("file:\\" + pfsConfigFileBase + "\\sas_pfs_services_core.xml");
        BIPValidate.setSoftwareComponentName("Query and Reporting");
        BIPValidate.setDomain("CARYNT");
        BIPValidate.setDebug(true);
        beanUtil.showDialog("LoginBean", null);
        System.exit(0);
    }
}

