/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.config;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TableCollection;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserContextInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.config.ESRIMapConfig;
import com.sas.util.config.ESRIMapCube;
import com.sas.util.config.ESRIMapService;
import com.sas.util.config.RB;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ESRIMapMetadataReader {
    private ESRIMapConfig config;
    private String repositoryID;
    private MdFactory factory;
    private MdObjectStore store;
    private CommonLoggerInterface logger = null;
    public static final String RB_KEY = "ESRIMapMetadataReader.";
    private static String XML_SELECT_OPTIONS = "<XMLSELECT Search=\"@CLASSIDENTIFIER='04C6FD00-8B79-48ad-8477-7C87E2C5A0E1'\"/>";

    public ESRIMapMetadataReader(ESRIMapConfig config, SessionContextInterface sci) {
        this.logger = LoggerRepository2.getLogger((String)ESRIMapMetadataReader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory(sci));
        this.config = config;
        try {
            this.read(sci);
            this.dispose();
        }
        catch (RemoteException e1) {
            this.logger.error(e1.getMessage(), (Throwable)e1);
        }
    }

    public synchronized void read(SessionContextInterface sci) throws RemoteException {
        UserContextInterface uci = sci.getUserContext();
        List repos = uci.getRepositories();
        if (repos != null) {
            String repositoryId = null;
            ArrayList<ESRIMapCube> cubesObj = null;
            ArrayList<ESRIMapService> mapServices = null;
            for (int i = 0; i < repos.size(); ++i) {
                try {
                    RepositoryInterface ri = (RepositoryInterface)repos.get(i);
                    if (!(ri instanceof OMIRepositoryInterface)) continue;
                    OMIRepositoryInterface omiRi = (OMIRepositoryInterface)ri;
                    repositoryId = omiRi.getDefaultRepositoryId();
                    Filter filter = new Filter("ClassIdentifier", 0, "04C6FD00-8B79-48ad-8477-7C87E2C5A0E1");
                    filter.setType("ServerComponent");
                    List serverList = omiRi.search((FilterInterface)filter);
                    if (serverList == null || serverList.size() <= 0) continue;
                    for (MetadataInterface mi : serverList) {
                        ServerComponent serverComponent = (ServerComponent)mi.getRepositoryEntity();
                        String serverName = null;
                        String userid = null;
                        String password = null;
                        Machine machine = serverComponent.getAssociatedMachine();
                        if (machine == null) continue;
                        serverName = machine.getName();
                        AssociationList srcConnections = serverComponent.getSourceConnections();
                        if (srcConnections != null && srcConnections.size() > 0 && srcConnections.get(0) instanceof COMConnection) {
                            COMConnection conn = (COMConnection)srcConnections.get(0);
                            AuthenticationDomain domain = conn.getDomain();
                            PasswordAuthentication pwdAuthn = this.getLogin(domain.getName(), uci);
                            try {
                                if (pwdAuthn != null) {
                                    SasPasswordString.DecodeResult dr = null;
                                    userid = pwdAuthn.getUserName();
                                    dr = SasPasswordString.decodeWithResult((String)new String(pwdAuthn.getPassword()));
                                    password = dr.getValue();
                                    if (dr != null) {
                                        switch (dr.getReason()) {
                                            case 2: {
                                                String tag = password.substring(password.indexOf("{") + 1, password.indexOf("}"));
                                                String fmt = RB.getStringResource(RB_KEY, "passwordnotsupported.warning.fmt.txt");
                                                String message = MessageFormat.format(fmt, userid, tag);
                                                this.logger.warn(message);
                                            }
                                            case 3: {
                                                String fmt = RB.getStringResource(RB_KEY, "passwordnotdecodable.warning.fmt.txt");
                                                String message = MessageFormat.format(fmt, userid);
                                                this.logger.warn(message);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (SasPasswordEncodingException spee) {
                                spee.printStackTrace();
                            }
                        }
                        AssociationList dataPackages = serverComponent.getDataPackages();
                        Iterator dataPackagesIterator = dataPackages.iterator();
                        AssociationList tableCollections = null;
                        while (dataPackagesIterator.hasNext()) {
                            File file = (File)dataPackagesIterator.next();
                            tableCollections = file.getTableCollections();
                            for (TableCollection table : tableCollections) {
                                ESRIMapService mapService = new ESRIMapService();
                                mapService.setName(file.getName());
                                mapService.setUniqueMapServiceName(table.getName());
                                if (mapServices == null) {
                                    mapServices = new ArrayList<ESRIMapService>();
                                }
                                mapServices.add(mapService);
                                AssociationList classifierMaps = table.getSourceTransformations();
                                for (ClassifierMap classifierMap : classifierMaps) {
                                    AssociationList dimensions = classifierMap.getTransformationTargets();
                                    if (dimensions.size() <= 0) continue;
                                    Dimension dimension = (Dimension)dimensions.get(0);
                                    AssociationList levels = dimension.getLevels();
                                    Iterator levelIterator = levels.iterator();
                                    HashMap<String, String> levelToLayer = new HashMap<String, String>();
                                    HashMap<String, String> layerToField = new HashMap<String, String>();
                                    while (levelIterator.hasNext()) {
                                        Level lvl = (Level)levelIterator.next();
                                        AssociationList olapProperties = lvl.getOLAPProperties();
                                        for (OLAPProperty prop : olapProperties) {
                                            if (!prop.getName().equalsIgnoreCase("SAS_SPATIAL_ID")) continue;
                                            try {
                                                String field = ((Property)prop.getProperties().get(0)).getName();
                                                AssociationList alist = lvl.getTargetTransformations();
                                                for (FeatureMap fm : alist) {
                                                    if (fm.getTransformRole() == null || !fm.getTransformRole().equalsIgnoreCase("ESRI Map Layer")) continue;
                                                    layerToField.put(fm.getName(), field);
                                                }
                                            }
                                            catch (MdException e1) {
                                                e1.printStackTrace();
                                            }
                                        }
                                        AssociationList levelFeatureMap = lvl.getTargetTransformations();
                                        if (levelFeatureMap == null || levelFeatureMap.size() <= 0) continue;
                                        for (FeatureMap levelMap : levelFeatureMap) {
                                            AssociationList list;
                                            if (levelMap.getTransformRole() == null || !levelMap.getTransformRole().equalsIgnoreCase("ESRI Map Layer") || (list = levelMap.getTransformationSources()) == null || list.size() <= 0) continue;
                                            Column col = (Column)list.get(0);
                                            String uniqueLevel = "[" + dimension.getName() + "].[" + lvl.getName() + "]";
                                            levelToLayer.put(uniqueLevel, col.getName());
                                        }
                                    }
                                    ESRIMapService mService = this.getLocalMapService(mapServices, table.getName());
                                    mService.setLayerToFieldMap(layerToField);
                                    AssociationList cubesList = dimension.getCubes();
                                    Cube cube = (Cube)cubesList.get(0);
                                    ESRIMapCube cubeObj = new ESRIMapCube();
                                    cubeObj.setUniqueMapServiceName(table.getName());
                                    cubeObj.setServer(serverName);
                                    if (userid != null && userid.indexOf("\\") > 0) {
                                        cubeObj.setUserid(userid.substring(userid.indexOf("\\") + 1, userid.length()));
                                        cubeObj.setDomain(userid.substring(0, userid.indexOf("\\")));
                                    } else {
                                        cubeObj.setUserid(userid);
                                    }
                                    cubeObj.setPassword(password);
                                    cubeObj.setName(cube.getName());
                                    cubeObj.setDimensionName(dimension.getName());
                                    cubeObj.setLayerToFieldMap(layerToField);
                                    AssociationList schemaList = cube.getAssociatedOLAPSchema().getDeployedComponents();
                                    ServerContext schemaContext = (ServerContext)schemaList.get(0);
                                    cubeObj.setOlapServer(schemaContext.getName());
                                    cubeObj.setLevelToLayerMap(levelToLayer);
                                    cubeObj.setMapService(file.getName());
                                    String cubeName = cube.getName();
                                    if (cubeName == null || cubeName.equals("")) {
                                        cubeName = cube.getName();
                                    }
                                    cubeObj.setName(cubeName);
                                    if (cubesObj == null) {
                                        cubesObj = new ArrayList<ESRIMapCube>();
                                    }
                                    cubesObj.add(cubeObj);
                                }
                            }
                        }
                    }
                    continue;
                }
                catch (RemoteException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (MdException mdException) {
                    continue;
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            if (mapServices != null) {
                this.config.setMapServices(mapServices);
            }
            if (cubesObj != null) {
                this.config.setCubes(cubesObj);
            }
        }
    }

    private ESRIMapService getLocalMapService(List mapServices, String uniqueName) {
        if (mapServices != null) {
            for (int i = 0; i < mapServices.size(); ++i) {
                ESRIMapService mc = (ESRIMapService)mapServices.get(i);
                if (!uniqueName.equalsIgnoreCase(mc.getUniqueMapServiceName())) continue;
                return mc;
            }
        }
        return null;
    }

    public void dispose() {
        if (this.factory != null) {
            try {
                this.factory.dispose();
            }
            catch (RemoteException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.factory = null;
        }
        this.store = null;
    }

    private PasswordAuthentication getLogin(String domain, UserContextInterface uci) throws RemoteException {
        List identities = uci.getIdentities();
        for (int index = 0; index < identities.size(); ++index) {
            SimpleUserIdentity identity = (SimpleUserIdentity)identities.get(index);
            if (!identity.getDomain().equals(domain)) continue;
            return new PasswordAuthentication(identity.getPrincipal().toString(), identity.getCredential().toString().toCharArray());
        }
        return null;
    }
}

