/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceNavigationModel;
import com.sas.swing.models.remotefileselector2.informationservices.BaseInformationServicesModel;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesAdapterSupport;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.FileMetadataComparatorInterface;
import com.sas.swing.visuals.remotefileselector2.RFSSortableTableModelAdapter;
import com.sas.table.SortException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class RemoteFileVisualsUtil {
    public static int FOLDER = 0;
    public static int NON_FOLDER = 1;
    public static int UNKNOWN = 2;
    private static String SINGLE_SPACE = " ";
    private static NumberFormat numberFormat = NumberFormat.getIntegerInstance();

    public static String getDateValue(DateFormat dateFormat, Date date) {
        if (date != null && date.getTime() > 0L && dateFormat != null) {
            return SINGLE_SPACE + dateFormat.format(date);
        }
        return SINGLE_SPACE;
    }

    public static String getSizeValue(Integer value, int folderStatus) {
        if (folderStatus == FOLDER || value == null) {
            return SINGLE_SPACE;
        }
        if (value.longValue() < 0L) {
            return SINGLE_SPACE;
        }
        double doubleValue = (double)value.longValue() / 1024.0;
        if (doubleValue < 1.0) {
            doubleValue = 1.0;
        }
        return numberFormat.format(doubleValue) + " KB ";
    }

    public static int[] getValidSelectionIndexesDependingOnSelectionMode(List selections, int mode) {
        int numSelections;
        int validCount = 0;
        int n = numSelections = selections == null ? 0 : selections.size();
        if (numSelections == 0) {
            return null;
        }
        int[] validIndexes = new int[selections.size()];
        for (int i = 0; i < numSelections; ++i) {
            Object node = selections.get(i);
            if (node instanceof RemoteFileMetadataInterface) {
                if (mode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY && ((RemoteFileMetadataInterface)node).isFolder()) {
                    validIndexes[validCount++] = i;
                    continue;
                }
                if (mode == BaseRemoteFileSelectorPanel.FILES_ONLY && !((RemoteFileMetadataInterface)node).isFolder()) {
                    validIndexes[validCount++] = i;
                    continue;
                }
                if (mode != BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES) continue;
                validIndexes[validCount++] = i;
                continue;
            }
            validIndexes[validCount++] = i;
        }
        if (validCount == 0) {
            return null;
        }
        if (validCount < numSelections) {
            validIndexes[validCount] = -1;
        }
        return validIndexes;
    }

    public static int countValidSelectionIndexesDependingOnSelectionMode(List selections, int mode) {
        int numSelections;
        int n = numSelections = selections == null ? 0 : selections.size();
        if (numSelections == 0) {
            return 0;
        }
        int validCount = 0;
        for (int i = 0; i < numSelections; ++i) {
            Object node = selections.get(i);
            if (node instanceof RemoteFileMetadataInterface) {
                if (mode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY && ((RemoteFileMetadataInterface)node).isFolder()) {
                    ++validCount;
                    continue;
                }
                if (mode == BaseRemoteFileSelectorPanel.FILES_ONLY && !((RemoteFileMetadataInterface)node).isFolder()) {
                    ++validCount;
                    continue;
                }
                if (mode != BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES) continue;
                ++validCount;
                continue;
            }
            ++validCount;
        }
        return validCount;
    }

    public static boolean hasValidSelectionDependingOnSelectionMode(List selections, int mode) {
        int numSelections;
        int n = numSelections = selections == null ? 0 : selections.size();
        if (numSelections == 0) {
            return false;
        }
        if (mode == BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES) {
            return true;
        }
        int numValidSelections = RemoteFileVisualsUtil.countValidSelectionIndexesDependingOnSelectionMode(selections, mode);
        if (mode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY) {
            return numValidSelections != 0;
        }
        if (numValidSelections > 0) {
            return true;
        }
        boolean singleFolderSelected = false;
        for (int i = 0; i < numSelections; ++i) {
            Object node = selections.get(i);
            if (node instanceof RemoteFileMetadataInterface) {
                if (!((RemoteFileMetadataInterface)node).isFolder()) continue;
                if (!singleFolderSelected) {
                    singleFolderSelected = true;
                    continue;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean listContainsItemByType(List selections, int type) {
        if (selections == null || selections.isEmpty()) {
            return false;
        }
        int numSelections = selections.size();
        for (int i = 0; i < numSelections; ++i) {
            Object o = selections.get(i);
            if (!(o instanceof RemoteFileMetadataInterface)) continue;
            if (type == 0 && ((RemoteFileMetadataInterface)o).isFolder()) {
                return true;
            }
            if (type != 1 || ((RemoteFileMetadataInterface)o).isFolder()) continue;
            return true;
        }
        return false;
    }

    public static String getSelectedItemText(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof RemoteFileMetadataInterface) {
            return ((RemoteFileMetadataInterface)o).getName();
        }
        return o.toString();
    }

    public static boolean startsWithValidAbsolutePathIndentifier(RemoteFileModel2Interface model, String value) {
        if (model instanceof IFileServiceNavigationModel) {
            return IFileServiceAdapterSupport.startsWithValidAbsolutePathIndentifier((IFileServiceNavigationModel)model, value);
        }
        if (model instanceof BaseInformationServicesModel) {
            return InformationServicesAdapterSupport.startsWithValidAbsolutePathIndentifier((BaseInformationServicesModel)((Object)model), value);
        }
        return false;
    }

    public static boolean isValidLocationForSave(RemoteFileModel2Interface model, String[] fileInfo, String value) {
        if (model instanceof BaseInformationServicesModel) {
            return !InformationServicesAdapterSupport.isItemAtRootLocation(model, fileInfo, value);
        }
        return true;
    }

    public static boolean isRootLocation(RemoteFileModel2Interface model, String location) {
        if (model instanceof BaseInformationServicesModel) {
            return InformationServicesAdapterSupport.isRootLocation(model, location);
        }
        return false;
    }

    public static boolean isValidLocationForSelection(RemoteFileModel2Interface model, String location, boolean rootValid) {
        if (model instanceof BaseInformationServicesModel) {
            if (rootValid) {
                return true;
            }
            return !InformationServicesAdapterSupport.isRootLocation(model, location);
        }
        String serverName = model.getServerName();
        return (location == null || !location.trim().equals("")) && !location.trim().equals(model.getServerName());
    }

    public static boolean hasWritePermissionsOnCurrentFolder(RemoteFileModel2Interface model) {
        if (model instanceof BaseInformationServicesModel) {
            BaseInformationServicesModel infoSvcModel = (BaseInformationServicesModel)((Object)model);
            return InformationServicesAdapterSupport.hasWritePermissionsOnFolder(infoSvcModel, infoSvcModel.getLocation());
        }
        return true;
    }

    public static void sortFoldersFirst(SortableTableModelAdapter sortModel, BaseRemoteFileModelInterface model, String sortColName, int sortDirection) {
        try {
            Comparator fileMetaDataComparator = null;
            String fileMetadataColumnName = "FILE_METADATA_COLUMN";
            int fileMetadataColumnIndex = model.getColumnIndex(fileMetadataColumnName);
            if (fileMetadataColumnIndex >= 0) {
                fileMetaDataComparator = sortModel.getColumnComparator(fileMetadataColumnName);
            }
            if (fileMetaDataComparator instanceof FileMetadataComparatorInterface && sortModel instanceof RFSSortableTableModelAdapter) {
                ((FileMetadataComparatorInterface)fileMetaDataComparator).setActiveColumnIdentifier(sortColName);
                ((RFSSortableTableModelAdapter)sortModel).rfsSort(sortColName, sortDirection);
            } else {
                RemoteFileVisualsUtil.sort_classic(sortModel, model, sortColName, sortDirection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sort_classic(SortableTableModelAdapter sortModel, BaseRemoteFileModelInterface model, String sortColName, int sortDirection) throws SortException {
        int isFolderColIndex;
        int nameColIndex = model.getColumnIndex("NAME_COLUMN");
        String nameColName = null;
        if (nameColIndex >= 0) {
            nameColName = model.getColumnName(nameColIndex).trim();
        }
        if ((isFolderColIndex = model.getColumnIndex("IS_A_FOLDER_COLUMN")) >= 0) {
            String isFolderColName = model.getColumnName(isFolderColIndex).trim();
            if (nameColName != null && !sortColName.equals(nameColName) && !sortColName.equals(isFolderColName)) {
                sortModel.sort(new String[]{isFolderColName, sortColName, nameColName}, new int[]{sortDirection, sortDirection, sortDirection});
            } else if (!sortColName.equals(isFolderColName)) {
                sortModel.sort(new String[]{isFolderColName, sortColName}, new int[]{sortDirection, sortDirection});
            } else if (nameColName != null && !sortColName.equals(nameColName)) {
                sortModel.sort(new String[]{sortColName, nameColName}, new int[]{sortDirection, sortDirection});
            } else {
                sortModel.sort(new String[]{sortColName}, new int[]{sortDirection});
            }
        } else if (nameColName != null && !sortColName.equals(nameColName)) {
            sortModel.sort(new String[]{sortColName, nameColName}, new int[]{sortDirection, sortDirection});
        } else {
            sortModel.sort(new String[]{sortColName}, new int[]{sortDirection});
        }
    }

    public static int compare_classic(Object o1, Object o2, Comparator defaultComparator, Comparator stringComparator) {
        int retVal;
        if (o1 instanceof String && o2 instanceof String) {
            retVal = stringComparator.compare(o1, o2);
        } else if (o1 instanceof Boolean && o2 instanceof Boolean) {
            retVal = ((Boolean)o1).equals(o2) ? 0 : (((Boolean)o1).booleanValue() ? -1 : 1);
        } else {
            retVal = defaultComparator.compare(o1, o2);
            if (retVal == Integer.MAX_VALUE && o1 != null && o2 != null) {
                return stringComparator.compare(o1.toString(), o2.toString());
            }
        }
        return retVal;
    }

    public static boolean hasWritePermissionsOnFile(RemoteFileModel2Interface rfsModel, String selectionLocation) {
        if (rfsModel instanceof BaseInformationServicesModel) {
            return InformationServicesAdapterSupport.hasWritePermissionsOnFile((BaseInformationServicesModel)((Object)rfsModel), selectionLocation);
        }
        return true;
    }

    public static String checkWritePermissionsOnFiles(List selections, RemoteFileModel2Interface rfsModel) {
        String filesWithWriteDenied = "";
        if (rfsModel instanceof BaseInformationServicesModel) {
            int numOfSelections = selections.size();
            for (int i = 0; i < numOfSelections; ++i) {
                RemoteFileMetadataInterface selection = (RemoteFileMetadataInterface)selections.get(i);
                String selectionLocation = selection.getLocation();
                if (RemoteFileVisualsUtil.hasWritePermissionsOnFile(rfsModel, selectionLocation)) continue;
                if (!filesWithWriteDenied.equals("")) {
                    filesWithWriteDenied = filesWithWriteDenied + ", ";
                }
                filesWithWriteDenied = filesWithWriteDenied + selection.getName();
            }
        }
        return filesWithWriteDenied;
    }

    public static boolean isTypeTheSame(String ob1, Object ob2) {
        if (ob1 != null && ob1 instanceof String && ob2 instanceof String) {
            if (ob1.equals(ob2)) {
                return true;
            }
            if (RemoteFileVisualsUtil.isMapType(ob1) && RemoteFileVisualsUtil.isMapType(ob2)) {
                return true;
            }
        } else if (ob1 == ob2) {
            return true;
        }
        return false;
    }

    private static boolean isMapType(Object objectType) {
        if (objectType.equals("InformationMap")) {
            return true;
        }
        if (objectType.equals("InformationMap.OLAP")) {
            return true;
        }
        return objectType.equals("InformationMap.Relational");
    }

    public static String getFileLocationInformation(String fileName, String fileType, BaseRemoteFileSelectorPanel panel, RemoteFileModel2Interface model) {
        if (fileName != null && !fileName.equals("")) {
            String[] fileInfo = null;
            String modelPath = model.getLocation();
            if (fileType != null && !fileType.equalsIgnoreCase("Folder")) {
                fileInfo = model.getFileInfo(model.getLocation(), fileName, fileType);
            } else {
                PathUrl modelPathUrl;
                if (modelPath != null && modelPath.startsWith("SBIP:") && panel.getSelectionMode() == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY && !panel.isSelectionTextInNameField() && !panel.isUserInputInNameField() && fileName.equalsIgnoreCase((modelPathUrl = new PathUrl(modelPath)).getName())) {
                    return modelPath;
                }
                fileInfo = model.getFileInfo(fileName);
            }
            if (fileInfo[1] != null) {
                return fileInfo[1];
            }
        }
        return null;
    }

    public static String getDisplayPath(String path) {
        String displayLocation = path;
        if (path != null && path.startsWith("SBIP://")) {
            PathUrl locationURL = new PathUrl(path);
            displayLocation = locationURL.getDisplayPath();
        }
        return displayLocation;
    }
}

