/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.DetailViewComponentInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentInterface;
import com.sas.swing.visuals.remotefileselector2.RemoteFileListComponent;
import com.sas.swing.visuals.remotefileselector2.RemoteFileTableComponent;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RemoteFileComponentPanel
extends JPanel
implements PropertyChangeListener,
DetailViewComponentInterface {
    private static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileComponentInterface viewComponent;
    private RemoteFileListComponent listComponent;
    private RemoteFileTableComponent tableComponent;
    private AutoSizingGridLayout layout;
    private BaseRemoteFileSelectorPanel parentComponent;
    private BaseRemoteFileModelInterface model;
    private List propertyChangeListeners;
    private boolean notInitialized;

    public RemoteFileComponentPanel(BaseRemoteFileSelectorPanel parentComponent) {
        this.parentComponent = parentComponent;
        this.viewComponent = new RemoteFileListComponent(parentComponent, parentComponent.supportType);
        JComponent vc = this.viewComponent.getViewComponent();
        this.setViewSelectionMode(vc);
        this.init();
    }

    private void setViewSelectionMode(JComponent vc) {
        if (vc instanceof TableView) {
            TableView tableVC = (TableView)vc;
            if (this.parentComponent != null && this.parentComponent.isMultiSelectionEnabled()) {
                tableVC.setSelectionMode(2);
            } else {
                tableVC.setSelectionMode(0);
            }
        }
    }

    protected void init() {
        this.notInitialized = true;
        this.layout = new AutoSizingGridLayout(1, 1, 10, 10, true, true, true);
        this.layout.setRemainderRow(1);
        this.setLayout((LayoutManager)this.layout);
        this.propertyChangeListeners = new ArrayList();
        ArrayList previousPath = new ArrayList();
        if (this.viewComponent instanceof RemoteFileListComponent) {
            this.listComponent = (RemoteFileListComponent)this.viewComponent;
        } else if (this.viewComponent instanceof RemoteFileTableComponent) {
            this.tableComponent = (RemoteFileTableComponent)this.viewComponent;
        }
        this.viewComponent.setPreviousPath(previousPath);
        this.add((JComponent)((Object)this.viewComponent));
    }

    public RemoteFileComponentInterface getViewComponent() {
        return this.viewComponent;
    }

    public void setModel(BaseRemoteFileModelInterface model) {
        this.model = model;
        this.viewComponent.setModel(model);
    }

    public void setViewComponent(String view) {
        int pathSize;
        boolean directoriesProperty = this.viewComponent.isShowDirectoriesOnly();
        Object selectionObject = this.viewComponent.getSelectionObject();
        List previousPath = this.viewComponent.getPreviousPath();
        this.remove((JComponent)((Object)this.viewComponent));
        String actualPrevPath = null;
        if (previousPath != null && (pathSize = previousPath.size()) > 0) {
            actualPrevPath = (String)previousPath.get(0);
        }
        this.createViewComponent(view, previousPath);
        this.viewComponent.setShowDirectoriesOnly(directoriesProperty);
        this.viewComponent.setSelectionObject(selectionObject);
        this.viewComponent.setPath(this.model.getLocation());
        if (actualPrevPath != null) {
            previousPath.clear();
            previousPath.add(actualPrevPath);
        }
        this.add((JComponent)((Object)this.viewComponent));
        this.paintAll(this.getGraphics());
    }

    private void createViewComponent(String view, List previousPath) {
        if (view.equals(RB.getStringResource(RB_KEY, "listText.txt")) || "List".equalsIgnoreCase(view)) {
            if (this.listComponent == null) {
                this.listComponent = new RemoteFileListComponent(this.parentComponent, this.parentComponent.supportType);
                this.listComponent.setModel(this.model);
                this.listComponent.setActionProvider(this.parentComponent.getActionProvider());
                this.listComponent.setPreviousPath(previousPath);
                this.listComponent.addPropertyChangeListener(this.parentComponent.filePanel);
                this.listComponent.setColumnRenderers(this.viewComponent.getColumnRenderers());
                this.setViewSelectionMode(this.listComponent.getViewComponent());
                Iterator i = this.propertyChangeListeners.iterator();
                while (i.hasNext()) {
                    this.listComponent.addPropertyChangeListener((PropertyChangeListener)i.next());
                }
            }
            this.viewComponent = this.listComponent;
        } else if (view.equals(RB.getStringResource(RB_KEY, "detailsText.txt")) || "Detail".equalsIgnoreCase(view)) {
            if (this.tableComponent == null || this.notInitialized) {
                this.tableComponent = (RemoteFileTableComponent)this.getDetailViewComponent();
                this.tableComponent.setModel(this.model);
                this.tableComponent.setActionProvider(this.parentComponent.getActionProvider());
                this.tableComponent.setPreviousPath(previousPath);
                this.tableComponent.addPropertyChangeListener(this.parentComponent.filePanel);
                this.tableComponent.setColumnRenderers(this.viewComponent.getColumnRenderers());
                this.setViewSelectionMode(this.tableComponent.getViewComponent());
                Iterator i = this.propertyChangeListeners.iterator();
                while (i.hasNext()) {
                    this.tableComponent.addPropertyChangeListener((PropertyChangeListener)i.next());
                }
                this.notInitialized = false;
            }
            this.viewComponent = this.tableComponent;
        }
    }

    @Override
    public JComponent getDetailViewComponent() {
        if (this.tableComponent == null) {
            this.tableComponent = new RemoteFileTableComponent(this.parentComponent, this.parentComponent.supportType);
        }
        return this.tableComponent;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        if (this.viewComponent != null) {
            this.viewComponent.addPropertyChangeListener(listener);
        }
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.viewComponent != null) {
            this.viewComponent.addPropertyChangeListener(listener);
        }
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        this.propertyChangeListeners.remove(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeListeners.remove(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("multiSelectionEnabled")) {
            if (this.listComponent != null) {
                this.setViewSelectionMode(this.listComponent.getViewComponent());
            }
            if (this.tableComponent != null) {
                this.setViewSelectionMode(this.tableComponent.getViewComponent());
            }
        }
    }
}

