/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.visuals.remotefileselector2.ColumnBasedFilePropertyComparator;
import com.sas.swing.visuals.remotefileselector2.DefaultRFSComparator;
import com.sas.swing.visuals.remotefileselector2.FileMetadataComparatorInterface;
import com.sas.swing.visuals.remotefileselector2.RFSFoldersFirstComparator;
import java.util.Comparator;
import java.util.Locale;

public class FileMetadataComparator
implements FileMetadataComparatorInterface {
    private Comparator activeColumnComparator;
    private String activeColumnIdentifier;
    private Locale locale;
    private RFSFoldersFirstComparator foldersFirstComparator;
    private Comparator fileNameComparator;

    public FileMetadataComparator(Locale sortLocale) {
        this.locale = sortLocale;
        this.foldersFirstComparator = new RFSFoldersFirstComparator();
        this.fileNameComparator = SASCollatorFactory.createCollator((Locale)this.locale);
    }

    public int compare(Object o1, Object o2) {
        Comparator comp1 = this.getFoldersFirstOrderComparator();
        int compResult = comp1.compare(o1, o2);
        if (compResult != 0) {
            return compResult;
        }
        Comparator comp2 = this.getActiveColumnComparator();
        compResult = comp2.compare(o1, o2);
        if (compResult != 0) {
            return compResult;
        }
        Comparator comp3 = this.getFileNameComparator();
        if (comp3 != comp2) {
            String o1FileName = ((RemoteFileMetadataInterface)o1).getName();
            String o2FileName = ((RemoteFileMetadataInterface)o2).getName();
            compResult = comp3.compare(o1FileName, o2FileName);
        }
        return compResult;
    }

    private Comparator getFileNameComparator() {
        return this.fileNameComparator;
    }

    protected Comparator getFoldersFirstOrderComparator() {
        return this.foldersFirstComparator;
    }

    @Override
    public Comparator getActiveColumnComparator() {
        return this.activeColumnComparator;
    }

    @Override
    public String getActiveColumnIdentifier() {
        return this.activeColumnIdentifier;
    }

    @Override
    public void setActiveColumnIdentifier(String columnId) {
        this.activeColumnIdentifier = columnId;
        this.activeColumnComparator = new ColumnBasedFilePropertyComparator(new DefaultRFSComparator(this.locale), columnId);
    }
}

