/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector.ifileservice;

import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class IFileServiceSizeCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final IFileServiceSizeCellRenderer defaultInstance = new IFileServiceSizeCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        String s = null;
        SortableTableModelAdapter sortableModel = (SortableTableModelAdapter)table.getModel();
        row = sortableModel.convertRowIndexToModel(row);
        RemoteFileMetadataInterface node = ((RemoteFileServerModelInterface)sortableModel.getModel()).getNodeAt(row);
        List hiddenColumns = ((TableView)table).getHiddenColumns();
        int arrayListSize = hiddenColumns.size();
        if (value != null && arrayListSize <= 1) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            if (node.isDrillable()) {
                s = " ";
            } else {
                double doubleValue = (double)((Integer)value).longValue() / 1024.0;
                if (doubleValue < 1.0) {
                    doubleValue = 1.0;
                }
                s = format.format(doubleValue) + "KB ";
            }
            this.setHorizontalAlignment(4);
        }
        this.setText(s);
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setEnabled(table.isEnabled());
        this.setFont(table.getFont());
        return this;
    }
}

