/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector.actions;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileServerModel;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class RenameAction
extends SwingAction
implements CellEditorListener {
    public static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileServerModelInterface model;
    private SortableTableModelAdapter tableModel;
    private int index;
    private String oldName;
    private TableView table;

    public void actionPerformed(ActionEvent event) {
        this.table = (TableView)this.getAttribute("table");
        this.index = this.table.getSelectedRow();
        this.tableModel = (SortableTableModelAdapter)this.table.getModel();
        Integer actualIndex = new Integer(this.tableModel.convertRowIndexToModel(this.index));
        this.tableModel.setAutoResortEnabled(false);
        this.oldName = this.tableModel.getValueAt(this.index, 0).toString();
        try {
            this.setAttribute("index", actualIndex);
            this.setAttribute("oldName", this.oldName);
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
        TableCellEditor cellEditor = this.table.getCellEditor(this.index, 0);
        cellEditor.addCellEditorListener(this);
        this.model = (RemoteFileServerModelInterface)this.tableModel.getModel();
        Rectangle rect = this.table.getCellRect(this.index, 0, false);
        this.table.scrollRectToVisible(rect);
        this.model.setTableEditable(true);
        this.table.setCellSelectionInterval(this.index, 0, this.index, 0);
        this.table.editCellAt(this.index, 0);
        JTextField text = (JTextField)this.table.getEditorComponent();
        text.selectAll();
        text.requestFocus();
    }

    @Override
    public void editingStopped(ChangeEvent ce) {
        String newName = this.tableModel.getValueAt(this.index, 0).toString();
        TableCellEditor cellEditor = this.table.getCellEditor(this.index, 0);
        cellEditor.removeCellEditorListener(this);
        this.model.setTableEditable(false);
        if (newName != null && !newName.equals("")) {
            try {
                this.setAttribute("newName", newName);
                this.removeAttribute("model");
                this.setAttribute("model", (RemoteFileServerModel)this.model);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            DynamicAttributeCommandInterface command = this.getCommand();
            if (command != null) {
                AttributeDescriptorInterface[] adi = this.getAttributeDescriptors();
                if (adi != null) {
                    for (int i = 0; i < adi.length; ++i) {
                        try {
                            AttributeDescriptorInterface attributeDescriptor = adi[i];
                            if (!attributeDescriptor.isModifiable()) continue;
                            command.setAttribute(attributeDescriptor.getName(), this.getValue(attributeDescriptor.getName()));
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
                this.executeCommand(command);
                this.removeAttribute("model");
                try {
                    this.setAttribute("model", null);
                }
                catch (AttributeSetException attributeDescriptor) {
                    // empty catch block
                }
                SwingActionProvider actionProvider = (SwingActionProvider)this.getActionProvider();
                if (command instanceof ContentsChangedInterface && actionProvider != null && ((ContentsChangedInterface)command).isContentsChanged()) {
                    actionProvider.fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)command).getEventSource(), (Map)((ContentsChangedInterface)command).getEventInfo()));
                }
            }
        } else {
            this.tableModel.setValueAt((Object)this.oldName, this.index, 0);
        }
        this.tableModel.setAutoResortEnabled(true);
    }

    @Override
    public void editingCanceled(ChangeEvent ce) {
        this.tableModel.setAutoResortEnabled(true);
    }

    protected void executeCommand(DynamicAttributeCommandInterface command) {
        try {
            command.execute(null);
        }
        catch (IllegalArgumentException iae) {
            this.tableModel.setValueAt((Object)this.oldName, this.index, 0);
            JOptionPane.showMessageDialog(null, iae.getMessage(), RB.getStringResource(RB_KEY, "error.txt"), 0);
            this.tableModel.setAutoResortEnabled(true);
        }
    }
}

