/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector.actions;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentInterface;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JOptionPane;

public class OpenFolderAction
extends SwingAction {
    public static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileServerModelInterface model;

    public void actionPerformed(ActionEvent event) {
        RemoteFileComponentInterface component = (RemoteFileComponentInterface)this.getAttribute("component");
        TableView table = (TableView)component.getViewComponent();
        SortableTableModelAdapter tableModel = (SortableTableModelAdapter)table.getModel();
        RemoteFileServerModelInterface model = (RemoteFileServerModelInterface)tableModel.getModel();
        int index = table.getSelectedRow();
        int convertedIndex = tableModel.convertRowIndexToModel(index);
        RemoteFileMetadataInterface node = model.getNodeAt(convertedIndex);
        String name = null;
        if (node.isDrillable()) {
            name = node.getName();
        }
        if (name != null) {
            try {
                this.setAttribute("folderName", name);
                this.setAttribute("path", model.getPath());
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            DynamicAttributeCommandInterface command = this.getCommand();
            if (command != null) {
                AttributeDescriptorInterface[] adi = this.getAttributeDescriptors();
                if (adi != null) {
                    for (int i = 0; i < adi.length; ++i) {
                        try {
                            AttributeDescriptorInterface attributeDescriptor = adi[i];
                            if (!attributeDescriptor.isModifiable()) continue;
                            command.setAttribute(attributeDescriptor.getName(), this.getValue(attributeDescriptor.getName()));
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
                this.executeCommand(command);
                SwingActionProvider actionProvider = (SwingActionProvider)this.getActionProvider();
                if (command instanceof ContentsChangedInterface && actionProvider != null && ((ContentsChangedInterface)command).isContentsChanged()) {
                    actionProvider.fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)command).getEventSource(), (Map)((ContentsChangedInterface)command).getEventInfo()));
                }
            }
            table.scrollRectToVisible(new Rectangle());
        }
    }

    protected void executeCommand(DynamicAttributeCommandInterface command) {
        try {
            command.execute(null);
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(null, iae.getMessage(), RB.getStringResource(RB_KEY, "error.txt"), 0);
        }
    }
}

