/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModel;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileSearchComponent;
import com.sas.swing.visuals.remotefileselector.RemoteFileSelectorDialog;
import com.sas.swing.visuals.remotefileselector.RemoteFileTableComponent;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class RemoteFileSearchPanel
extends BaseRemoteFileSelectorPanel
implements PropertyChangeListener {
    public RemoteFileTableComponent tablePanel;
    public RemoteFileSearchComponent searchPanel;
    protected List selectedObjects;

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, TransformInterface[] transforms, String[] columnNames, RemoteFileSearchModelInterface serviceModel, boolean returnSelectedItems) {
        RemoteFileSearchPanel panel = new RemoteFileSearchPanel(initialPath, transforms, columnNames, serviceModel);
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(returnSelectedItems);
    }

    public static List showDialog(Frame parent, String initialPath, RemoteFileSearchPanel panel) {
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, "Search", true, 2, panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(true);
    }

    public RemoteFileSearchPanel() {
        this(null, null, null, null);
    }

    public RemoteFileSearchPanel(String initialPath, TransformInterface[] transforms, String[] columnNames, RemoteFileSearchModelInterface serviceModel) {
        this(initialPath, transforms, columnNames, null, serviceModel);
    }

    public RemoteFileSearchPanel(String initialPath, TransformInterface[] transforms, String[] columnNames, Object[] columnRenderers, RemoteFileSearchModelInterface serviceModel) {
        if (initialPath != null) {
            this.initialize(initialPath, transforms, columnNames, columnRenderers, serviceModel, null);
        }
    }

    public void initialize(String initialPath, TransformInterface[] transforms, String[] columnNames, Object[] columnRenderers, RemoteFileSearchModelInterface serviceModel, String supportType) {
        this.serviceModel = serviceModel;
        initialPath = serviceModel.getDirectoryPath(initialPath);
        this.model = new RemoteFileServerModel(initialPath, serviceModel, transforms, columnNames);
        this.tablePanel = new RemoteFileTableComponent(this);
        this.tablePanel.addPropertyChangeListener(this);
        this.tablePanel.setRemoteModel(this.model);
        this.tablePanel.setColumnRenderers(columnRenderers);
        this.searchPanel = new RemoteFileSearchComponent(supportType, serviceModel, this.tablePanel, this.model);
        this.viewerSupport = new SwingViewerSupport((ActionProviderViewInterface)this);
        if (this.getActionProvider() == null) {
            this.setActionProvider(new SwingActionProvider());
        }
        if (supportType == "REMOTE_IFILE_SERVICE_SUPPORT") {
            this.viewerSupport.setActionSupportType("REMOTE_IFILE_SERVICE_SUPPORT");
            this.tableDataCellFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_DATA_CELL_AREA", (ActionProviderViewInterface)this);
            this.tableColumnHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_COLUMN_HEADER_AREA", (ActionProviderViewInterface)this);
            this.drillDownFilter = new ActionSupportFilter(this.getActionSupportType(), "DRILL_DOWN_AREA", (ActionProviderViewInterface)this);
        } else if (supportType == "REMOTE_INFO_SERVICE_SUPPORT") {
            this.viewerSupport.setActionSupportType("REMOTE_INFO_SERVICE_SUPPORT");
            this.tableDataCellFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_DATA_CELL_AREA", (ActionProviderViewInterface)this);
            this.tableColumnHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_COLUMN_HEADER_AREA", (ActionProviderViewInterface)this);
            this.drillDownFilter = new ActionSupportFilter(this.getActionSupportType(), "DRILL_DOWN_AREA", (ActionProviderViewInterface)this);
        }
        try {
            this.drillDownFilter.setAttribute("path", (Object)initialPath);
            this.drillDownFilter.setAttribute("model", (Object)serviceModel);
            this.drillDownFilter.setAttribute("component", (Object)this.tablePanel);
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)RemoteFileSearchPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        mainLayout.setRemainderRow(1);
        this.setLayout((LayoutManager)mainLayout);
        if (this.searchPanel != null) {
            this.add(this.searchPanel);
        }
        if (this.tablePanel != null) {
            this.add(this.tablePanel);
        }
    }

    @Override
    public List getReturnedInformation(boolean returnSelectedItems) {
        return this.getSelectedItems();
    }

    private List getSelectedItems() {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (this.selectedObjects != null) {
            int size = this.selectedObjects.size();
            for (int i = 0; i < size; ++i) {
                fileNames.add(this.serviceModel.getFullyQualifiedPath(((RemoteFileMetadataInterface)this.selectedObjects.get(i)).getPath(), ((RemoteFileMetadataInterface)this.selectedObjects.get(i)).getName()));
            }
        }
        return fileNames;
    }

    public void setCurrentPath(String path) {
        this.searchPanel.setCurrentPath(path);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("selections")) {
            this.selectedObjects = new ArrayList();
            TableView table = (TableView)this.tablePanel.getViewComponent();
            int[] selectedRows = table.getSelectedRows();
            int length = selectedRows.length;
            for (int i = 0; i < length; ++i) {
                int realSelection = ((SortableTableModelAdapter)table.getModel()).convertRowIndexToModel(selectedRows[i]);
                RemoteFileMetadataInterface item = this.model.getNodeAt(realSelection);
                this.selectedObjects.add(item);
            }
        }
    }
}

