/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentInterface;
import com.sas.swing.visuals.remotefileselector.RemoteFileListComponent;
import com.sas.swing.visuals.remotefileselector.RemoteFileTableComponent;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RemoteFileComponentPanel
extends JPanel {
    private static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileComponentInterface viewComponent;
    private RemoteFileListComponent listComponent;
    private RemoteFileTableComponent tableComponent;
    private RemoteFileServerModelInterface remoteModel;
    private AutoSizingGridLayout layout;
    private BaseRemoteFileSelectorPanel parentComponent;

    public RemoteFileComponentPanel(BaseRemoteFileSelectorPanel parentComponent) {
        this.parentComponent = parentComponent;
        this.viewComponent = new RemoteFileListComponent(parentComponent, parentComponent.supportType);
        this.init();
    }

    protected void init() {
        this.layout = new AutoSizingGridLayout(1, 1, 10, 10, true, true, true);
        this.layout.setRemainderRow(1);
        this.setLayout((LayoutManager)this.layout);
        if (this.viewComponent instanceof RemoteFileListComponent) {
            this.listComponent = (RemoteFileListComponent)this.viewComponent;
        } else if (this.viewComponent instanceof RemoteFileTableComponent) {
            this.tableComponent = (RemoteFileTableComponent)this.viewComponent;
        }
        this.add((JComponent)((Object)this.viewComponent));
    }

    public RemoteFileComponentInterface getViewComponent() {
        return this.viewComponent;
    }

    public void setRemoteModel(RemoteFileServerModelInterface model) {
        this.remoteModel = model;
        this.viewComponent.setRemoteModel(model);
    }

    public void setViewComponent(String view) {
        boolean directoriesProperty = this.viewComponent.isShowDirectoriesOnly();
        Object selectionObject = this.viewComponent.getSelectionObject();
        this.remove((JComponent)((Object)this.viewComponent));
        if (view.equals(RB.getStringResource(RB_KEY, "listText.txt"))) {
            if (this.listComponent == null) {
                this.listComponent = new RemoteFileListComponent(this.parentComponent, this.parentComponent.supportType);
                this.listComponent.setRemoteModel(this.remoteModel);
                this.listComponent.setActionProvider(this.parentComponent.getActionProvider());
                this.listComponent.setColumnRenderers(this.viewComponent.getColumnRenderers());
            }
            this.viewComponent = this.listComponent;
        } else if (view.equals(RB.getStringResource(RB_KEY, "detailsText.txt"))) {
            if (this.tableComponent == null) {
                this.tableComponent = new RemoteFileTableComponent(this.parentComponent, this.parentComponent.supportType);
                this.tableComponent.setRemoteModel(this.remoteModel);
                this.tableComponent.setActionProvider(this.parentComponent.getActionProvider());
                this.tableComponent.setColumnRenderers(this.viewComponent.getColumnRenderers());
            }
            this.viewComponent = this.tableComponent;
        }
        this.viewComponent.setShowDirectoriesOnly(directoriesProperty);
        this.viewComponent.setSelectionObject(selectionObject);
        this.add((JComponent)((Object)this.viewComponent));
        this.paintAll(this.getGraphics());
    }
}

