/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.entities.AttributeSetException;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceModel;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;

public class RemoteFileButtonPanel
extends JPanel
implements PropertyChangeListener {
    private static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileComponentInterface viewComponent;
    private int previousDirectorySelectionIndex;
    private Insets nullInsets = new Insets(0, 0, 0, 0);
    private int directorySelectionServerLocation = 1;
    private ActionSupportFilter filter;
    private BaseRemoteFileSelectorPanel parentComponent;
    private boolean initialSelection;
    protected JToolBar toolBar;
    protected JComboBox directorySelection;

    public RemoteFileButtonPanel(JComponent parentComponent) {
        this.parentComponent = (BaseRemoteFileSelectorPanel)parentComponent;
        this.toolBar = new JToolBar();
        this.toolBar.setName("ToolBar");
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.populateToolbar(this.toolBar);
        this.directorySelection = new JComboBox();
        this.directorySelection.setName("DirectorySelection");
        this.directorySelection.setEditable(true);
        this.directorySelection.setEditor(new DirectorySelectionEditor());
        this.directorySelection.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        this.directorySelection.setRenderer(new DirectorySelectionRenderer());
        this.directorySelection.setPreferredSize(new Dimension(200, 26));
        this.directorySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent directorySelectionEvent) {
                JComboBox cb = (JComboBox)directorySelectionEvent.getSource();
                RemoteFileButtonPanel.this.setDirectorySelection(cb);
            }
        });
        JLabel choiceLabel = new JLabel(RB.getStringResource(RB_KEY, "choiceText.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "choiceMnemonic.txt"))));
        choiceLabel.setDisplayedMnemonic(keyEvent);
        choiceLabel.setLabelFor(this.directorySelection);
        choiceLabel.setName("ChoiceLabel");
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(1, 3, 5, 5, false, false, true);
        buttonLayout.setRemainderColumn(2);
        buttonLayout.setDefaultCellGravity(256);
        this.setLayout((LayoutManager)buttonLayout);
        this.add(choiceLabel);
        this.add(this.directorySelection);
        this.add(this.toolBar);
        this.previousDirectorySelectionIndex = this.directorySelection.getSelectedIndex();
    }

    public void setRemoteFileViewComponent(RemoteFileComponentInterface component) {
        this.viewComponent = component;
        this.viewComponent.addPropertyChangeListener(this);
        this.parentComponent.addPropertyChangeListener(this);
        String path = this.viewComponent.getRemoteModel().getPath();
        ArrayList<String> newVector = new ArrayList<String>();
        this.directorySelection.removeAllItems();
        JLabel label = new JLabel(RB.getStringResource(RB_KEY, "availableservers.txt"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.directorySelection.addItem(label);
        String text = this.parentComponent.getViewComponent().getRemoteModel().getServerName();
        label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        this.directorySelection.addItem(label);
        while (path != null && !path.equals("")) {
            String[] stringArray = this.viewComponent.getRemoteModel().splitDirectoryPathAndFileName(path);
            path = stringArray[1];
            String fileName = stringArray[0];
            if (fileName.equals("")) {
                if (!path.equals("")) {
                    newVector.add(path);
                }
                path = null;
                continue;
            }
            newVector.add(fileName);
        }
        int size = newVector.size();
        int position = 0;
        for (int i = size - 1; i >= 0; --i) {
            label = new JLabel((String)newVector.get(i));
            label.setBorder(BorderFactory.createEmptyBorder(0, 16 + 16 * (position + 1), 0, 0));
            this.directorySelection.insertItemAt(label, this.directorySelectionServerLocation + position + 1);
            ++position;
        }
        this.initialSelection = true;
        this.directorySelection.setSelectedIndex(this.directorySelection.getItemCount() - 1);
        this.initialSelection = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("path")) {
            this.directorySelection.removeAllItems();
            JLabel label = new JLabel(RB.getStringResource(RB_KEY, "availableservers.txt"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.directorySelection.addItem(label);
            String text = this.viewComponent.getRemoteModel().getServerName();
            label = new JLabel(text);
            label.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
            this.directorySelection.addItem(label);
            String path = (String)e.getNewValue();
            try {
                this.filter.setAttribute("path", e.getNewValue());
                this.filter.setAttribute("previousPath", (Object)this.viewComponent.getPreviousPath());
                this.toolBar.removeAll();
                this.populateToolbar(this.toolBar);
            }
            catch (AttributeSetException e1) {
                LoggerRepository2.getLogger((String)RemoteFileButtonPanel.class.getPackage().getName(), null).error(e1.getMessage(), (Throwable)e1);
            }
            ArrayList<String> newVector = new ArrayList<String>();
            while (path != null && !path.equals("")) {
                String[] stringArray = this.viewComponent.getRemoteModel().splitDirectoryPathAndFileName(path);
                path = stringArray[1];
                String fileName = stringArray[0];
                if (fileName.equals("")) {
                    if (!path.equals("")) {
                        newVector.add(path);
                    }
                    path = null;
                    continue;
                }
                newVector.add(fileName);
                if (!path.equals(".")) continue;
                path = null;
            }
            int size = newVector.size();
            int position = 0;
            for (int i = size - 1; i >= 0; --i) {
                label = new JLabel((String)newVector.get(i));
                label.setBorder(BorderFactory.createEmptyBorder(0, 16 + 16 * (position + 1), 0, 0));
                this.directorySelection.insertItemAt(label, this.directorySelectionServerLocation + position + 1);
                ++position;
            }
            this.initialSelection = true;
            this.directorySelection.setSelectedIndex(this.directorySelectionServerLocation + position);
            this.initialSelection = false;
        }
        if (e.getPropertyName().equals("viewType")) {
            this.toolBar.removeAll();
            this.populateToolbar(this.toolBar);
        }
    }

    private void setDirectorySelection(JComboBox cb) {
        int selectedIndex = cb.getSelectedIndex();
        if (selectedIndex != this.previousDirectorySelectionIndex && selectedIndex >= this.directorySelectionServerLocation) {
            if (selectedIndex != this.directorySelectionServerLocation) {
                ArrayList<String> names = new ArrayList<String>();
                for (int i = this.directorySelectionServerLocation + 1; i <= selectedIndex; ++i) {
                    names.add(((JLabel)this.directorySelection.getItemAt(i)).getText());
                }
                String path = this.viewComponent.getRemoteModel().createPathFromArray(names.toArray());
                this.viewComponent.setPath(path);
            } else if (!this.initialSelection) {
                RemoteFileServiceModelInterface serviceModel = this.viewComponent.getRemoteModel().getModel();
                if (serviceModel instanceof IFileServiceModel) {
                    ((IFileServiceModel)serviceModel).setPathMode(ListFilesMode.ListFilesModeRoot);
                }
                this.viewComponent.setPath("");
            }
        }
        this.previousDirectorySelectionIndex = selectedIndex;
    }

    public void setToolTipText(JComponent component, String text) {
        super.setToolTipText(text);
        component.setToolTipText(text);
    }

    protected void populateToolbar(JToolBar toolBar) {
        this.filter = this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.TOOLBAR_FILTER);
        ActionList actions = this.parentComponent.getActionProvider().getActions(this.filter);
        if (actions != null) {
            int size = actions.size();
            for (int i = 0; i < size; ++i) {
                List list = actions.getActions();
                SwingAction action = (SwingAction)list.get(i);
                JButton button = toolBar.add((Action)action);
                button.setMargin(this.nullInsets);
            }
        }
    }

    class DirectorySelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon directoryIcon = new ImageIcon(Resources.getImage((String)"Folder"));

        DirectorySelectionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = ((JLabel)value).getText();
            this.setText(s);
            this.setBorder(((JLabel)value).getBorder());
            this.setIcon(this.directoryIcon);
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    class DirectorySelectionEditor
    extends JLabel
    implements ComboBoxEditor {
        private ImageIcon directoryIcon = new ImageIcon(Resources.getImage((String)"Folder"));

        DirectorySelectionEditor() {
        }

        @Override
        public void addActionListener(ActionListener al) {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void removeActionListener(ActionListener al) {
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                this.setIcon(this.directoryIcon);
                this.setText(((JLabel)anObject).getText());
            }
        }
    }
}

