/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.List;
import java.util.TreeSet;

@SASScope
public class ROLAPUtil {
    public static DataItem findDataItem(BusinessQuery businessQuery, OLAPDataSetInterface dataSet, String uniqueLevelName) throws OLAPException, MetadataException {
        ResultSetMetadataInterface rsm = dataSet.getResultSetMetadata();
        AxisInterface[] axes = rsm.getAxes(0, -1);
        AxisInterface axis = null;
        int axisIndex = -1;
        for (int i = 0; i < axes.length && (axisIndex = ROLAPUtil.findUniqueLevelName(uniqueLevelName, axis = axes[i])) < 0; ++i) {
        }
        if (axisIndex < 0) {
            return null;
        }
        List resultItems = ROLAPUtil.getResultItems(businessQuery, axis);
        return ROLAPUtil.convertAxisIndexToDataItem(axisIndex, axis, resultItems, uniqueLevelName);
    }

    public static DataItem findDataItem(BusinessQuery businessQuery, TupleElementInterface tupleElement) throws OLAPException, MetadataException {
        TupleInterface tuple = tupleElement.getTuple();
        AxisInterface axis = tuple.getAxis();
        List resultItems = ROLAPUtil.getResultItems(businessQuery, axis);
        if (tupleElement.getType() == TupleElementType.MEASURE) {
            return ROLAPUtil.findMeasure(tupleElement, resultItems);
        }
        int count = tupleElement.getTupleElementIndex();
        TupleElementInterface[] tupleElements = tuple.getElements(0, count);
        int axisIndex = 0;
        for (int i = 0; i < count; ++i) {
            axisIndex += tupleElements[i].getSpan();
        }
        return ROLAPUtil.convertAxisIndexToDataItem(axisIndex, axis, resultItems, tupleElement);
    }

    private static DataItem convertAxisIndexToDataItem(int axisIndex, AxisInterface axis, List resultItems, Object label) throws OLAPException {
        int index;
        int nDimensions = ROLAPUtil.countUniqueDimensions(axis, axisIndex);
        int offset = ROLAPUtil.countMeasures(resultItems, axisIndex);
        if (offset > 0) {
            --offset;
        }
        if ((index = nDimensions - 1 + offset) >= 0 && index < resultItems.size()) {
            return (DataItem)resultItems.get(index);
        }
        return null;
    }

    private static int findUniqueLevelName(String uniqueLevelName, AxisInterface axis) throws OLAPException {
        String[] uniqueLevelNames = axis.getUniqueLevelNames();
        for (int j = 0; j < uniqueLevelNames.length; ++j) {
            if (!uniqueLevelName.equals(uniqueLevelNames[j])) continue;
            return j;
        }
        return -1;
    }

    private static DataItem findMeasure(TupleElementInterface tupleElement, List resultItems) throws OLAPException {
        for (int i = 0; i < resultItems.size(); ++i) {
            DataItem di = (DataItem)resultItems.get(i);
            if (!di.getLabel().equalsIgnoreCase(tupleElement.getLabel())) continue;
            return di;
        }
        return null;
    }

    private static int countMeasures(List resultItems, int max) {
        int count = 0;
        for (int i = 0; i < resultItems.size() && (i < max || count > 0); ++i) {
            DataItem di = (DataItem)resultItems.get(i);
            if (!ROLAPUtil.isMeasure(di)) continue;
            ++count;
        }
        return count;
    }

    private static int countUniqueDimensions(AxisInterface axis, int relativeIndex) throws OLAPException {
        String[] dimensionNames = axis.getDimensionNames();
        TreeSet<String> dimensionNameMap = new TreeSet<String>();
        int nDimensions = 0;
        for (int i = 0; i <= relativeIndex; ++i) {
            if (dimensionNameMap.contains(dimensionNames[i])) continue;
            dimensionNameMap.add(dimensionNames[i]);
            ++nDimensions;
        }
        return nDimensions;
    }

    private static List getResultItems(BusinessQuery businessQuery, AxisInterface axis) throws OLAPException, MetadataException {
        Role role = Role.COLUMN;
        if (axis.getAxisNumber() == 1) {
            role = Role.ROW;
        }
        List resultItems = businessQuery.getResultItems(role);
        return resultItems;
    }

    public static boolean isMeasure(DataItem dataItem) {
        StructureOfDataItem dataItemStructure = dataItem.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && dataItem.getExpressionType() == 2 && dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }
}

