/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.actionprovider.util.olap.OLAPActionProviderUtil;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.models.OLAPDataSetInterfaceProvider;
import com.sas.swing.models.OLAPTableModelAdapter;
import com.sas.swing.visuals.olaptableview.OLAPCellRendererManager;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeaderSelectionModel;
import com.sas.swing.visuals.olaptableview.OLAPOriginComponent;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.olaptableview.OLAPRowHeaderSelectionModel;
import com.sas.swing.visuals.olaptableview.RB;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class OLAPTableView
extends TableView {
    private static final String uiClassID = "OLAPTableViewUI";
    public static final String RB_KEY = "OLAPTableView.";
    private Filter metadataFilter = new Filter();

    public OLAPTableView() {
    }

    public OLAPTableView(TableModel tableModel) {
        super(tableModel);
    }

    public OLAPTableView(TableModel tableModel, TableColumnModel columnModel) {
        super(tableModel, columnModel);
    }

    public OLAPTableView(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        super(tableModel, columnModel, selectionModel);
        this.updateUI();
    }

    public OLAPTableView(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public OLAPTableView(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public OLAPTableView(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    public void setModel(TableModel newModel) {
        JScrollPane scrollPane;
        super.setModel(newModel);
        if (this.tableInitialized) {
            if (newModel instanceof OLAPDataSetInterfaceProvider) {
                if (!(this.getTableHeader() instanceof OLAPColumnHeader)) {
                    this.setTableHeader(this.createDefaultTableHeader());
                }
                if (!(this.getRowHeader() instanceof OLAPRowHeader)) {
                    this.setRowHeader(this.createDefaultRowHeader());
                }
                if (!(this.getOriginComponent() instanceof OLAPOriginComponent)) {
                    this.setOriginComponent(this.createDefaultOriginComponent());
                }
            } else {
                if (this.getTableHeader() instanceof OLAPColumnHeader) {
                    this.setTableHeader(this.createDefaultTableHeader());
                }
                if (this.getRowHeader() instanceof OLAPRowHeader) {
                    this.setRowHeader(this.createDefaultRowHeader());
                }
                if (this.getOriginComponent() instanceof OLAPOriginComponent) {
                    this.setOriginComponent(this.createDefaultOriginComponent());
                }
            }
        }
        if ((scrollPane = this.getScrollPane()) != null && scrollPane.getColumnHeader() != null && scrollPane.getColumnHeader().getView() != this.getTableHeader()) {
            this.configureEnclosingScrollPane();
        }
        if (this.getTableHeader() instanceof OLAPColumnHeader) {
            ((OLAPColumnHeader)((Object)this.getTableHeader())).setAxis(this.getAxis(0));
        }
        if (this.getRowHeader() instanceof OLAPRowHeader) {
            ((OLAPRowHeader)this.getRowHeader()).setAxis(this.getAxis(1));
        }
    }

    public AxisInterface getAxis(int axis) {
        try {
            OLAPDataSetInterface odsi;
            if (this.getModel() instanceof OLAPDataSetInterfaceProvider && (odsi = ((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface()).getResultSetMetadata() != null) {
                AxisInterface[] axes = odsi.getResultSetMetadata().getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    if (axes[i].getAxisNumber() != axis) continue;
                    return axes[i];
                }
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected TableModel createDefaultDataModel() {
        return new OLAPTableModelAdapter();
    }

    protected JTableHeader createDefaultTableHeader() {
        if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
            OLAPColumnHeader header = new OLAPColumnHeader(this.getColumnModel());
            header.setAxis(this.getAxis(0));
            return header;
        }
        ColumnHeader header = new ColumnHeader(this.getColumnModel());
        return header;
    }

    protected TableColumnModel createDefaultColumnModel() {
        TableColumnModel cm = super.createDefaultColumnModel();
        cm.setSelectionModel((ListSelectionModel)((Object)new OLAPColumnHeaderSelectionModel(this)));
        return cm;
    }

    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < m.getColumnCount(); ++i) {
                TableColumn newColumn = new TableColumn(i);
                this.addColumn(newColumn);
            }
        }
    }

    public void createDefaultViewerSupport() {
        this.viewerSupport = new SwingViewerSupport((ActionProviderViewInterface)this);
        this.viewerSupport.setActionSupportType("OLAP_TABLEVIEW_SUPPORT");
    }

    public void createDefaultActionProviderFilters() {
        this.dataCellFilter = new ActionSupportFilter(this.getActionSupportType(), "DATA_CELL_AREA", (ActionProviderViewInterface)this);
        this.rowHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "ROW_HEADER_AREA", (ActionProviderViewInterface)this);
        this.columnHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "COLUMN_HEADER_AREA", (ActionProviderViewInterface)this);
        this.titleFilter = new ActionSupportFilter(this.getActionSupportType(), "TITLE_AREA", (ActionProviderViewInterface)this);
        this.toolbarFilter = new ActionSupportFilter(this.getActionSupportType(), "TOOLBAR_AREA", (ActionProviderViewInterface)this);
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    private void setLazyRenderer(Class c, String s) {
        this.setLazyValue(this.defaultRenderersByColumnClass, c, s);
    }

    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setLazyRenderer(Object.class, "com.sas.swing.visuals.tableview.NumberRenderer");
    }

    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.olaptableview.BasicOLAPTableViewUI");
        }
        super.updateUI();
        this.setUI((TableUI)UIManager.getUI((JComponent)((Object)this)));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected RowHeader createDefaultRowHeader() {
        if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
            if (this.getRowModel() == null) {
                this.setRowModel(this.createDefaultRowModel());
            }
            OLAPRowHeader header = new OLAPRowHeader(this.getRowModel());
            header.setAxis(this.getAxis(1));
            return header;
        }
        RowHeader header = new RowHeader(this.getRowModel());
        return header;
    }

    protected TableRowModel createDefaultRowModel() {
        TableRowModel rm = super.createDefaultRowModel();
        rm.setSelectionModel((ListSelectionModel)((Object)new OLAPRowHeaderSelectionModel(this)));
        return rm;
    }

    protected JComponent createDefaultOriginComponent() {
        if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
            return new OLAPOriginComponent(this);
        }
        return super.createDefaultOriginComponent();
    }

    protected void repaintCurrentCell() {
        int currentRow = this.getCurrentRow();
        int currentColumn = this.getCurrentColumn();
        if (currentRow >= 0 && currentColumn >= 0) {
            this.repaint(this.getCellRect(currentRow, currentColumn, false));
        } else if (currentRow < 0 && currentColumn >= 0) {
            if (this.getColumnHeader() != null) {
                this.getColumnHeader().repaint();
            }
        } else if (currentRow >= 0 && currentColumn < 0) {
            if (this.getRowHeader() != null) {
                this.getRowHeader().repaint();
            }
        } else if (this.getOriginComponent() != null) {
            this.getOriginComponent().repaint();
        }
    }

    protected void repaintCells(int oldRow, int newRow, int oldColumn, int newColumn) {
        if (oldRow >= 0 && oldColumn >= 0) {
            Rectangle oldRect = this.getCellRect(oldRow, oldColumn, false);
            if (newRow >= 0 && newColumn >= 0) {
                Rectangle newRect = this.getCellRect(newRow, newColumn, false);
                Rectangle dirtyRegion = oldRect.union(newRect);
                this.repaint(dirtyRegion);
            } else {
                this.repaint(oldRect);
                this.repaintCurrentCell();
            }
        } else if (oldRow < 0 && oldColumn >= 0) {
            if (this.getColumnHeader() != null) {
                if (newRow < 0 && newColumn >= 0) {
                    this.getColumnHeader().repaint();
                } else {
                    this.getColumnHeader().repaint();
                    this.repaintCurrentCell();
                }
            }
        } else if (oldRow >= 0 && oldColumn < 0) {
            if (this.getRowHeader() != null) {
                if (newRow >= 0 && newColumn < 0) {
                    this.getRowHeader().repaint();
                } else {
                    this.getRowHeader().repaint();
                    this.repaintCurrentCell();
                }
            }
        } else {
            if (this.getOriginComponent() != null) {
                this.getOriginComponent().repaint();
            }
            if (newRow >= 0 || newColumn >= 0) {
                this.repaintCurrentCell();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateCurrentCell() {
        int levelCount;
        int mult;
        int currentRow = this.getCurrentRow();
        int currentColumn = this.getCurrentColumn();
        int oldCurrentRow = currentRow;
        int oldCurrentColumn = currentColumn;
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        if (currentRow >= rowCount) {
            mult = 1;
            if (currentColumn < 0) {
                mult = -1;
            }
            currentColumn = mult * (currentRow / Math.max(1, rowCount) + 1);
            currentRow %= Math.max(1, rowCount);
        }
        if (currentColumn >= colCount) {
            mult = 1;
            if (currentRow < 0) {
                mult = -1;
            }
            currentRow = mult * (currentColumn / Math.max(1, colCount) + 1);
            currentColumn %= Math.max(1, colCount);
        }
        if (currentRow < 0 && currentColumn >= 0) {
            levelCount = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
            currentRow = Math.max(currentRow, -levelCount);
        } else if (currentColumn < 0 && currentRow >= 0) {
            levelCount = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
            currentColumn = Math.max(currentColumn, -levelCount);
        } else if (currentRow < 0 && currentColumn < 0) {
            int rowLevelCount = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
            int colLevelCount = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
            currentRow = Math.max(currentRow, -(rowLevelCount + 1));
            currentColumn = Math.max(currentColumn, -colLevelCount);
        }
        boolean oldChange = this.changingCurrentCell;
        try {
            this.changingCurrentCell = true;
            if (oldCurrentColumn != currentColumn) {
                this.setCurrentColumn(currentColumn);
            }
            if (oldCurrentRow != currentRow) {
                this.setCurrentRow(currentRow);
            }
        }
        finally {
            this.changingCurrentCell = oldChange;
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (this.getModel() instanceof AbstractTableModel) {
            ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
        } else {
            this.tableChanged(new TableModelEvent(this.getModel(), -1));
        }
    }

    public void showPopup(int row, int column) {
        Point point = null;
        if (row < 0 && column < 0) {
            Dimension dim = this.getOriginComponent().getSize();
            if (row == -1) {
                int maxLevel = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
                int width = 0;
                int rowLevel = maxLevel - 1 - (Math.abs(column) - 1);
                for (int i = 0; i <= rowLevel; ++i) {
                    width += ((OLAPRowHeader)this.getRowHeader()).getLevelWidth(i);
                }
                point = new Point(-(dim.width - width), 0);
            } else {
                int maxLevel = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
                int height = 0;
                int columnLevel = maxLevel - 1 - (Math.abs(row) - 2);
                if (columnLevel == maxLevel - 1) {
                    height = -((OLAPOriginComponent)((Object)this.getOriginComponent())).getRowLevelHeight();
                }
                for (int i = 0; i <= columnLevel; ++i) {
                    height += ((OLAPColumnHeader)this.getColumnHeader()).getLevelHeight(i);
                }
                point = new Point(0, -(dim.height - height));
            }
        } else if (row < 0) {
            int levelCount = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
            Rectangle rect = ((OLAPColumnHeader)this.getColumnHeader()).getHeaderRect(column, levelCount - 1 - (Math.abs(row) - 1));
            Rectangle visRect = this.getVisibleRect();
            int x = rect.x + rect.width;
            if (x < visRect.x) {
                x = visRect.x;
            }
            if (x > visRect.x + visRect.width) {
                x = visRect.x + visRect.width;
            }
            point = new Point(x, -(this.getColumnHeader().getHeight() - (rect.y + rect.height)));
        } else if (column < 0) {
            int levelCount = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
            Rectangle rect = ((OLAPRowHeader)this.getRowHeader()).getHeaderRect(row, levelCount - 1 - (Math.abs(column) - 1));
            Rectangle visRect = this.getVisibleRect();
            int y = rect.y + rect.height;
            if (y < visRect.y) {
                y = visRect.y;
            }
            if (y > visRect.y + visRect.height) {
                y = visRect.y + visRect.height;
            }
            point = new Point(-(this.getRowHeader().getWidth() - (rect.x + rect.width)), y);
        } else {
            Rectangle rect = this.getCellRect(row, column, true);
            point = new Point(rect.x + rect.width, rect.y + rect.height);
        }
        this.showPopup(row, column, point);
    }

    public void showPopup(Point point) {
        int row = -1;
        int column = -1;
        if (point.y > this.getCellAreaHeight() || point.x > this.getCellAreaWidth()) {
            row = point.y > 0 ? Integer.MAX_VALUE : -1;
            column = point.x > 0 ? Integer.MAX_VALUE : -1;
        } else if (point.x >= 0 && point.y >= 0) {
            row = this.rowAtPoint(point);
            column = this.columnAtPoint(point);
        } else if (point.x >= 0) {
            column = this.columnAtPoint(point);
            Point p = new Point(point.x, point.y + this.getTableHeader().getHeight());
            row = -(((OLAPColumnHeader)((Object)this.getTableHeader())).getMaxLevelCount() - ((OLAPColumnHeader)((Object)this.getTableHeader())).levelAtPoint(p));
        } else if (point.y >= 0) {
            row = this.rowAtPoint(point);
            Point p = new Point(point.x + this.getRowHeader().getWidth(), point.y);
            column = -(((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount() - ((OLAPRowHeader)this.getRowHeader()).levelAtPoint(p));
        } else {
            Point p = new Point(point.x + this.getRowHeader().getWidth(), point.y + this.getTableHeader().getHeight());
            row = ((OLAPOriginComponent)((Object)this.getOriginComponent())).getColumnLevelAtPoint(p);
            if (row == -1) {
                int maxLevel = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
                column = ((OLAPOriginComponent)((Object)this.getOriginComponent())).getRowLevelAtPoint(p);
                column = -(maxLevel - 1 - (Math.abs(column) - 1));
            } else {
                int maxLevel = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
                row = -(maxLevel - (Math.abs(row) - 1));
                column = -1;
            }
        }
        this.showPopup(row, column, point);
    }

    protected ActionSupportFilter configureToolBarActionFilter() {
        ActionSupportFilter filter = this.toolbarFilter;
        try {
            filter.setAttribute("table", (Object)this);
            if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
                filter.setAttribute("model", (Object)((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface());
            } else {
                filter.setAttribute("model", (Object)this.getModel());
            }
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return filter;
    }

    protected ActionSupportFilter configureRowHeaderActionFilter(int row, int column) {
        try {
            this.rowHeaderFilter.setAttribute("table", (Object)this);
            int levelCount = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
            TupleElementInterface tupleElement = ((OLAPRowHeader)this.getRowHeader()).getTupleElementAt(row, levelCount - 1 - (Math.abs(column) - 1));
            this.rowHeaderFilter.setAttribute("tupleElement", (Object)tupleElement);
            OLAPDataSetInterface model = null;
            if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
                model = ((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface();
            }
            this.rowHeaderFilter.setAttribute("model", (Object)model);
            if (this.getRowHeader() instanceof OLAPRowHeader && tupleElement != null) {
                this.rowHeaderFilter.setAttribute("tupleElements", (Object)tupleElement.getTuple().getElements(0, tupleElement.getTupleElementIndex() + 1));
                AxisInterface axis = ((OLAPRowHeader)this.getRowHeader()).getAxis();
                this.rowHeaderFilter.setAttribute("axis", (Object)axis);
                this.rowHeaderFilter.setAttribute("isMeasure", (Object)(OLAPActionProviderUtil.isMeasure(tupleElement, model, axis, this.metadataFilter) ? Boolean.TRUE : Boolean.FALSE));
                if (model instanceof BusinessQueryProviderInterface) {
                    BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                    this.rowHeaderFilter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem(bq, tupleElement));
                }
            } else {
                this.rowHeaderFilter.setAttribute("tupleElements", null);
            }
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return this.rowHeaderFilter;
    }

    protected ActionSupportFilter configureColumnHeaderActionFilter(int row, int column) {
        try {
            this.columnHeaderFilter.setAttribute("table", (Object)this);
            int levelCount = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
            TupleElementInterface tupleElement = ((OLAPColumnHeader)this.getColumnHeader()).getTupleElementAt(column, levelCount - 1 - (Math.abs(row) - 1));
            this.columnHeaderFilter.setAttribute("tupleElement", (Object)tupleElement);
            OLAPDataSetInterface model = null;
            if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
                model = ((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface();
            }
            this.columnHeaderFilter.setAttribute("model", (Object)model);
            if (this.getColumnHeader() instanceof OLAPColumnHeader && tupleElement != null) {
                this.columnHeaderFilter.setAttribute("tupleElements", (Object)tupleElement.getTuple().getElements(0, tupleElement.getTupleElementIndex() + 1));
                AxisInterface axis = ((OLAPColumnHeader)this.getColumnHeader()).getAxis();
                this.columnHeaderFilter.setAttribute("axis", (Object)axis);
                this.columnHeaderFilter.setAttribute("isMeasure", (Object)(OLAPActionProviderUtil.isMeasure(tupleElement, model, axis, this.metadataFilter) ? Boolean.TRUE : Boolean.FALSE));
                if (model instanceof BusinessQueryProviderInterface) {
                    BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                    this.columnHeaderFilter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem(bq, tupleElement));
                }
            } else {
                this.columnHeaderFilter.setAttribute("tupleElements", null);
            }
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return this.columnHeaderFilter;
    }

    protected ActionSupportFilter configureTitleActionFilter(int row, int column) {
        try {
            this.titleFilter.setAttribute("table", (Object)this);
            String uniqueLevelName = null;
            String axisLabel = null;
            String levelLabel = null;
            AxisInterface axis = null;
            if (row == -1) {
                int maxRowLevel = ((OLAPRowHeader)this.getRowHeader()).getMaxLevelCount();
                int c = maxRowLevel - 1 - (Math.abs(column) - 1);
                axis = ((OLAPRowHeader)this.getRowHeader()).getAxis();
                uniqueLevelName = axis.getUniqueLevelNames()[c];
                axisLabel = ((OLAPOriginComponent)((Object)this.getOriginComponent())).getRowLabel(c);
                levelLabel = axis.getAxisHeaders()[c];
            } else {
                int maxColumnLevel = ((OLAPColumnHeader)this.getColumnHeader()).getMaxLevelCount();
                int r = maxColumnLevel - 1 - (Math.abs(++row) - 1);
                axis = ((OLAPColumnHeader)this.getColumnHeader()).getAxis();
                uniqueLevelName = axis.getUniqueLevelNames()[r];
                axisLabel = ((OLAPOriginComponent)((Object)this.getOriginComponent())).getColumnLabel(r);
                levelLabel = axis.getAxisHeaders()[r];
            }
            OLAPDataSetInterface model = null;
            if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
                model = ((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface();
            }
            this.titleFilter.setAttribute("model", (Object)model);
            this.titleFilter.setAttribute("uniqueLevelName", (Object)uniqueLevelName);
            this.titleFilter.setAttribute("axisLabel", (Object)axisLabel);
            this.titleFilter.setAttribute("axis", (Object)axis);
            this.titleFilter.setAttribute("levelLabel", (Object)levelLabel);
            this.titleFilter.setAttribute("isMeasure", (Object)(OLAPActionProviderUtil.isMeasure(uniqueLevelName, model, axis, this.metadataFilter) ? Boolean.TRUE : Boolean.FALSE));
            if (model instanceof BusinessQueryProviderInterface) {
                BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                this.titleFilter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem(bq, model, uniqueLevelName));
            }
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return this.titleFilter;
    }

    protected ActionSupportFilter configureDataCellActionFilter(int row, int column) {
        int modelRowIndex = Integer.MAX_VALUE;
        int modelColumnIndex = Integer.MAX_VALUE;
        if (row != Integer.MAX_VALUE) {
            modelRowIndex = this.convertRowIndexToModel(row);
        }
        if (column != Integer.MAX_VALUE) {
            modelColumnIndex = this.convertColumnIndexToModel(column);
        }
        int columnCount = this.getColumnCount();
        try {
            this.dataCellFilter.setAttribute("table", (Object)this);
            if (this.getModel() instanceof OLAPDataSetInterfaceProvider) {
                this.dataCellFilter.setAttribute("model", (Object)((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface());
                if (modelRowIndex != Integer.MAX_VALUE && modelColumnIndex != Integer.MAX_VALUE) {
                    this.dataCellFilter.setAttribute("cellOrdinal", (Object)new Integer(OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)((OLAPDataSetInterfaceProvider)this.getModel()).getOLAPDataSetInterface().getResultSetMetadata(), (int[])new int[]{modelColumnIndex, modelRowIndex})));
                }
                if (row != Integer.MAX_VALUE && column != Integer.MAX_VALUE) {
                    int i;
                    TupleElementInterface[] colElements = null;
                    TupleElementInterface[] rowElements = null;
                    if (this.getColumnHeader() instanceof OLAPColumnHeader) {
                        colElements = ((OLAPColumnHeader)this.getColumnHeader()).getTupleElementsForCoordinate(column);
                    }
                    if (this.getRowHeader() instanceof OLAPRowHeader) {
                        rowElements = ((OLAPRowHeader)this.getRowHeader()).getTupleElementsForCoordinate(row);
                    }
                    if (colElements != null && colElements.length > 0) {
                        this.dataCellFilter.setAttribute("tupleElement", (Object)colElements[colElements.length - 1]);
                    }
                    int size = 0;
                    int colSize = 0;
                    if (colElements != null) {
                        colSize = size = colElements.length;
                    }
                    if (rowElements != null) {
                        size += rowElements.length;
                    }
                    TupleElementInterface[] elements = new TupleElementInterface[size];
                    if (colElements != null) {
                        for (i = 0; i < colSize; ++i) {
                            elements[i] = colElements[i];
                        }
                    }
                    if (rowElements != null) {
                        for (i = colSize; i < size; ++i) {
                            elements[i] = rowElements[i - colSize];
                        }
                    }
                    this.dataCellFilter.setAttribute("tupleElements", (Object)elements);
                    this.dataCellFilter.setAttribute("rowAxis", (Object)((OLAPRowHeader)this.getRowHeader()).getAxis());
                    this.dataCellFilter.setAttribute("columnAxis", (Object)((OLAPColumnHeader)this.getColumnHeader()).getAxis());
                }
            } else {
                this.dataCellFilter.setAttribute("model", null);
                this.dataCellFilter.setAttribute("cellOrdinal", null);
                this.dataCellFilter.setAttribute("tupleElement", null);
                this.dataCellFilter.setAttribute("tupleElements", null);
            }
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return this.dataCellFilter;
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e == null || e.getFirstRow() == -1) {
            if (this.getTableHeader() instanceof OLAPColumnHeader) {
                ((OLAPColumnHeader)((Object)this.getTableHeader())).setAxis(this.getAxis(0));
                this.columnsSized = true;
            }
            if (this.getRowHeader() instanceof OLAPRowHeader) {
                ((OLAPRowHeader)this.getRowHeader()).setAxis(this.getAxis(1));
            }
            if (this.getOriginComponent() instanceof TableModelListener) {
                ((TableModelListener)((Object)this.getOriginComponent())).tableChanged(e);
            }
            this.validateCurrentCell();
        }
    }
}

