/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.CellSelectionModel;
import com.sas.swing.visuals.tableview.TableView;
import java.util.BitSet;

@SASScope(value="ALL")
public class OLAPRowHeaderSelectionModel
extends CellSelectionModel {
    public OLAPRowHeaderSelectionModel() {
        this(null);
    }

    public OLAPRowHeaderSelectionModel(OLAPTableView table) {
        super((TableView)table);
    }

    protected int getMinRow(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        if (this.getTable() != null) {
            int row = 0;
            int rowCount = 0;
            rowCount = this.getTable().getRowCount();
            row = ordinal % rowCount;
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getRowHeader() instanceof OLAPRowHeader) {
                int level = 0;
                int levelCount = 1;
                OLAPRowHeader header = (OLAPRowHeader)((OLAPTableView)this.getTable()).getRowHeader();
                try {
                    levelCount = header.getMaxLevelCount();
                    TupleElementInterface[] elements = header.getTupleElementsForCoordinate(row);
                    level = levelCount - 1 - ordinal / rowCount;
                    TupleElementInterface tupleElement = header.getTupleElementAt(row, level);
                    if (tupleElement != null) {
                        return tupleElement.getMinimumCoordinate();
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return ordinal;
    }

    protected int getMaxRow(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        if (this.getTable() != null) {
            int row = 0;
            int rowCount = 0;
            rowCount = this.getTable().getRowCount();
            row = ordinal % rowCount;
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getRowHeader() instanceof OLAPRowHeader) {
                int level = 0;
                int levelCount = 1;
                OLAPRowHeader header = (OLAPRowHeader)((OLAPTableView)this.getTable()).getRowHeader();
                try {
                    levelCount = header.getMaxLevelCount();
                    TupleElementInterface[] elements = header.getTupleElementsForCoordinate(row);
                    level = levelCount - 1 - ordinal / rowCount;
                    TupleElementInterface tupleElement = header.getTupleElementAt(row, level);
                    if (tupleElement != null) {
                        return tupleElement.getMaximumCoordinate();
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return ordinal;
    }

    protected int getMinLevel(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        return 0;
    }

    protected int getMaxLevel(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        if (this.getTable() != null) {
            int row = 0;
            int rowCount = 0;
            rowCount = this.getTable().getRowCount();
            row = ordinal % rowCount;
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getRowHeader() instanceof OLAPRowHeader) {
                OLAPRowHeader header = (OLAPRowHeader)((OLAPTableView)this.getTable()).getRowHeader();
                int levelCount = header.getMaxLevelCount();
                int level = ordinal / rowCount;
                row = ordinal % rowCount;
                int levelCount2 = header.getLevelCount(row);
                if (levelCount != levelCount2) {
                    TupleElementInterface[] elements = header.getTupleElementsForCoordinate(row);
                    int levelDepth = 0;
                    for (int i = elements.length - 1; i >= 0; --i) {
                        try {
                            if ((levelDepth += elements[i].getSpan()) > level) {
                                return levelDepth - 1;
                            }
                            continue;
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                    }
                }
                return level;
            }
        }
        return 0;
    }

    protected int createOrdinal(int row, int column) {
        if (row == -1 || column == -1) {
            return -1;
        }
        if (row == Integer.MAX_VALUE || column == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int rowCount = 0;
        if (this.getTable() != null) {
            rowCount = this.getTable().getRowCount();
        }
        return row + column * rowCount;
    }

    public void clearSelection() {
        int rowCount = 1;
        if (this.getTable() != null) {
            rowCount = this.getTable().getRowCount();
        }
        if (rowCount > 0) {
            int row1 = this.minOrdinal % rowCount;
            int column1 = this.minOrdinal / rowCount;
            int row2 = this.maxOrdinal % rowCount;
            int column2 = this.maxOrdinal / rowCount;
            this.removeSelectionInterval(row1, column1, row2, column2);
        }
    }

    protected void changeSelection(BitSet bits, int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        int levelCount = 1;
        int rowCount = 0;
        if (this.getTable() != null) {
            rowCount = this.getTable().getRowCount();
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getRowHeader() instanceof OLAPRowHeader) {
                OLAPRowHeader header = (OLAPRowHeader)((OLAPTableView)this.getTable()).getRowHeader();
                levelCount = header.getMaxLevelCount();
            }
        }
        int clearLevel1 = Math.min(this.getMinLevel(clearMin), this.getMinLevel(clearMax));
        int clearLevel2 = Math.max(this.getMaxLevel(clearMin), this.getMaxLevel(clearMax));
        int clearMaxLevel = Math.max(clearLevel1, clearLevel2);
        if (clearMax == -1) {
            clearMaxLevel = -1;
        }
        if (clearMaxLevel == Integer.MAX_VALUE) {
            clearMaxLevel = levelCount - 1;
        }
        int clearRow1 = Integer.MAX_VALUE;
        int clearRow2 = -1;
        if (clearMin != Integer.MAX_VALUE) {
            clearRow1 = clearMin % rowCount;
        }
        if (clearMax != -1) {
            clearRow2 = clearMax % rowCount;
        }
        clearMaxLevel = Math.min(levelCount - 1, clearMaxLevel);
        int ord1 = this.createOrdinal(clearRow1, clearMaxLevel);
        int ord2 = this.createOrdinal(clearRow2, clearMaxLevel);
        int clearMinRow = Math.min(this.getMinRow(ord1), this.getMinRow(ord2));
        int clearMaxRow = Math.max(this.getMaxRow(ord1), this.getMaxRow(ord2));
        if (clearMinRow == -1) {
            clearMinRow = clearRow1;
        }
        if (clearMaxRow == Integer.MAX_VALUE) {
            clearMaxRow = clearRow2;
        }
        int level1 = Math.min(this.getMinLevel(setMin), this.getMinLevel(setMax));
        int level2 = Math.max(this.getMaxLevel(setMin), this.getMaxLevel(setMax));
        int maxLevel = Math.max(level1, level2);
        if (setMax == -1) {
            maxLevel = -1;
        }
        if (maxLevel == Integer.MAX_VALUE) {
            maxLevel = levelCount - 1;
        }
        int row1 = Integer.MAX_VALUE;
        int row2 = -1;
        if (setMin != Integer.MAX_VALUE) {
            row1 = setMin % rowCount;
        }
        if (setMax != -1) {
            row2 = setMax % rowCount;
        }
        maxLevel = Math.min(levelCount - 1, maxLevel);
        ord1 = this.createOrdinal(row1, maxLevel);
        ord2 = this.createOrdinal(row2, maxLevel);
        int minRow = Math.min(this.getMinRow(ord1), this.getMinRow(ord2));
        int maxRow = Math.max(this.getMaxRow(ord1), this.getMaxRow(ord2));
        if (minRow == -1) {
            minRow = row1;
        }
        if (maxRow == Integer.MAX_VALUE) {
            maxRow = row2;
        }
        clearMin = Integer.MAX_VALUE;
        clearMax = -1;
        setMin = Integer.MAX_VALUE;
        setMax = -1;
        int max = Math.max(clearMaxLevel, maxLevel);
        for (int i = 0; i <= max; ++i) {
            if (i > clearMaxLevel) {
                clearMinRow = Integer.MAX_VALUE;
                clearMaxRow = -1;
                clearMin = Integer.MAX_VALUE;
                clearMax = -1;
            }
            if (i > maxLevel) {
                minRow = Integer.MAX_VALUE;
                maxRow = -1;
                setMin = Integer.MAX_VALUE;
                setMax = -1;
            }
            if (clearMinRow != Integer.MAX_VALUE) {
                clearMin = this.createOrdinal(clearMinRow, i);
            }
            if (clearMaxRow != -1) {
                clearMax = this.createOrdinal(clearMaxRow, i);
            }
            if (minRow != Integer.MAX_VALUE) {
                setMin = this.createOrdinal(minRow, i);
            }
            if (maxRow != -1) {
                setMax = this.createOrdinal(maxRow, i);
            }
            int max2 = Math.max(setMax, clearMax);
            for (int j = Math.min(setMin, clearMin); j <= max2; ++j) {
                boolean shouldClear = this.contains(clearMin, clearMax, j);
                boolean shouldSet = this.contains(setMin, setMax, j);
                if (shouldSet && shouldClear) {
                    if (clearFirst) {
                        shouldClear = false;
                    } else {
                        shouldSet = false;
                    }
                }
                if (shouldSet) {
                    this.set(bits, j);
                }
                if (!shouldClear) continue;
                this.clear(bits, j);
            }
        }
        this.validateMinAndMaxOrdinal();
        this.fireValueChanged();
    }

    protected void validateMinAndMaxOrdinal() {
        if (this.getTable() != null) {
            int rowCount = this.getTable().getRowCount();
            int minRow = Integer.MAX_VALUE;
            int maxRow = -1;
            int minColumn = Integer.MAX_VALUE;
            int maxColumn = -1;
            if (minRow > 0 || maxRow < rowCount - 1) {
                int col;
                int col2;
                int row;
                int i;
                int column;
                boolean gotFirst = false;
                int size = this.value.length();
                if (size > 0 && (column = (size - 1) / rowCount) > maxColumn) {
                    maxColumn = column;
                }
                for (i = 0; i < size && (minRow > 0 || maxRow < rowCount - 1); ++i) {
                    if (!this.value.get(i)) continue;
                    row = i % rowCount;
                    if (row < minRow) {
                        minRow = row;
                    }
                    if (row > maxRow) {
                        maxRow = row;
                    }
                    if (gotFirst) continue;
                    gotFirst = true;
                    col2 = i / rowCount;
                    if (col2 >= minColumn) continue;
                    minColumn = col2;
                }
                gotFirst = false;
                size = this.extendedValue.length();
                if (size > 0 && (col = (size - 1) / rowCount) > maxColumn) {
                    maxColumn = col;
                }
                for (i = 0; i < size && (minRow > 0 || maxRow < rowCount - 1); ++i) {
                    if (!this.extendedValue.get(i)) continue;
                    row = i % rowCount;
                    if (row < minRow) {
                        minRow = row;
                    }
                    if (row > maxRow) {
                        maxRow = row;
                    }
                    if (gotFirst) continue;
                    gotFirst = true;
                    col2 = i / rowCount;
                    if (col2 >= minColumn) continue;
                    minColumn = col2;
                }
            }
            this.minOrdinal = this.createOrdinal(minRow, minColumn);
            this.maxOrdinal = this.createOrdinal(maxRow, maxColumn);
        }
    }
}

