/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.visuals.olaptableview.OLAPHeaderRenderer;
import com.sas.swing.visuals.olaptableview.OLAPOriginComponent;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.RowHeaderUI;
import com.sas.swing.visuals.tableview.TableRowModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SizeSequence;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

@SASScope(value="ALL")
public class OLAPRowHeader
extends RowHeader {
    private static final String uiClassID = "OLAPRowHeaderUI";
    protected AxisInterface axis;
    protected SizeSequence levelWidths;
    protected List rowLevelWidths;
    private TupleInterface[] tuples;

    public OLAPRowHeader() {
        this(null);
    }

    public OLAPRowHeader(TableRowModel model) {
        super(model);
    }

    private TupleInterface[] getTuples() throws OLAPException {
        if (this.tuples == null) {
            this.tuples = this.getAxis().getTuples(0, -1);
        }
        return this.tuples == null ? new TupleInterface[]{} : this.tuples;
    }

    public int levelAtPoint(Point point) {
        int row = this.rowAtPoint(point);
        if (row == -1) {
            return -1;
        }
        int x = point.x;
        int width = 0;
        if (!this.getComponentOrientation().isLeftToRight()) {
            width = this.getWidth() - 1;
        }
        int maxLevelCount = this.getMaxLevelCount();
        int result = 0;
        if (this.getComponentOrientation().isLeftToRight()) {
            int i = 0;
            while (width <= x) {
                if (i == maxLevelCount) {
                    result = maxLevelCount - 1;
                    break;
                }
                int levelWidth = this.getLevelWidth(i);
                if ((width += levelWidth) > x) {
                    result = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (width >= x) {
                if (i == maxLevelCount) {
                    result = maxLevelCount - 1;
                    break;
                }
                int levelWidth = this.getLevelWidth(i);
                if ((width -= levelWidth) < x) {
                    result = i;
                }
                ++i;
            }
        }
        if (result < 0) {
            return -1;
        }
        if (result >= maxLevelCount) {
            return -1;
        }
        return result;
    }

    public Rectangle getHeaderRect(int row, int level) {
        Rectangle r = new Rectangle();
        TableRowModel tm = this.getRowModel();
        int maxLevelCount = this.getMaxLevelCount();
        int levelCount = this.getLevelCount(row);
        if (row >= 0) {
            if (row >= tm.getRowCount()) {
                r.y = this.getHeight();
            } else {
                int spanCount;
                int i;
                TupleElementInterface[] tupleElements = this.getTupleElementsForCoordinate(row);
                int min = 0;
                int max = 0;
                int span = 0;
                try {
                    int elementIndex = 0;
                    i = 0;
                    for (spanCount = 0; spanCount <= level; spanCount += tupleElements[i].getSpan()) {
                        elementIndex = i++;
                    }
                    min = tupleElements[elementIndex].getMinimumCoordinate();
                    max = tupleElements[elementIndex].getMaximumCoordinate();
                    span = tupleElements[elementIndex].getSpan();
                }
                catch (OLAPException elementIndex) {
                    // empty catch block
                }
                int colHeight = 0;
                for (i = 0; i <= max; ++i) {
                    if (i <= min) {
                        r.y += colHeight;
                    }
                    colHeight = this.table.getRowHeight(i);
                    if (i < min) continue;
                    r.height += colHeight;
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    for (i = 0; i < spanCount - span; ++i) {
                        r.x += this.getLevelWidth(i);
                    }
                } else {
                    r.x = this.getWidth();
                    for (i = 0; i < spanCount; ++i) {
                        r.x -= this.getLevelWidth(i);
                    }
                }
                r.width = 0;
                for (i = spanCount - span; i < spanCount; ++i) {
                    r.width += this.getLevelWidth(i);
                }
            }
        }
        return r;
    }

    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.reorderingAllowed = false;
        this.holdingEnabled = false;
        this.tuples = null;
    }

    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void setHoldingEnabled(boolean b) {
        this.holdingEnabled = false;
    }

    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.olaptableview.BasicOLAPRowHeaderUI");
        }
        this.setUI((RowHeaderUI)UIManager.getUI((JComponent)((Object)this)));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setAxis(AxisInterface newAxis) {
        if (this.axis != newAxis) {
            AxisInterface oldValue = this.axis;
            this.axis = newAxis;
            this.tuples = null;
            if (this.rowLevelWidths != null) {
                this.rowLevelWidths.clear();
            }
            this.levelWidths = null;
            this.sizeRowsToFit(true, true);
            this.firePropertyChange("axis", oldValue, this.axis);
        }
    }

    public AxisInterface getAxis() {
        return this.axis;
    }

    public Object getValueAt(int rowIndex) {
        TupleElementInterface[] labels = this.getTupleElementsForCoordinate(rowIndex);
        if (labels != null) {
            try {
                return labels[labels.length - 1].getLabel();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return null;
    }

    public TupleElementInterface getTupleElementAt(int rowIndex, int levelIndex) {
        TupleElementInterface[] labels;
        if (levelIndex != -1 && (labels = this.getTupleElementsForCoordinate(rowIndex)) != null && levelIndex != -1) {
            try {
                int count = 0;
                for (int i = 0; i < labels.length; ++i) {
                    if ((count += labels[i].getSpan()) <= levelIndex) continue;
                    return labels[i];
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        TupleElementInterface tup;
        String tip = null;
        Point p = event.getPoint();
        int row = this.rowAtPoint(p);
        int level = this.levelAtPoint(p);
        if (row != -1 && level != -1 && (tup = this.getTupleElementAt(row, level)) != null) {
            try {
                Component component = this.getDefaultRenderer().getTableCellRendererComponent((JTable)this.getTable(), tup.getLabel(), false, false, row, level);
                if (component instanceof JComponent) {
                    Rectangle cellRect = this.getHeaderRect(row, level);
                    p.translate(-cellRect.x, -cellRect.y);
                    MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                    tip = ((JComponent)component).getToolTipText(newEvent);
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    public TupleElementInterface[] getTupleElementsForCoordinate(int axisCoordinate) {
        TupleElementInterface[] axisLabels = new TupleElementInterface[]{};
        try {
            TupleInterface[] axisTuples;
            if (this.getAxis() != null && (axisTuples = this.getTuples()) != null && axisTuples.length > axisCoordinate && axisCoordinate != -1) {
                axisLabels = axisTuples[axisCoordinate].getElements(0, -1);
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return axisLabels;
    }

    public int getMaxLevelCount() {
        try {
            if (this.getAxis() != null) {
                return this.getAxis().getAxisHeaders().length;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return 0;
    }

    public int getLevelCount(int rowNumber) {
        try {
            TupleInterface[] tuples;
            if (this.getAxis() != null && (tuples = this.getTuples()).length > rowNumber) {
                int tupleDepth = tuples[rowNumber].getElements(0, -1).length;
                return tupleDepth;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return 0;
    }

    protected SizeSequence getLevelWidths() {
        if (this.levelWidths == null) {
            this.levelWidths = new SizeSequence(this.getMaxLevelCount(), -1);
        }
        return this.levelWidths;
    }

    public int getLevelWidth(int level) {
        int i;
        Object obj;
        int listSize;
        int size;
        if (this.levelWidths != null && (size = this.levelWidths.getSize(level)) != -1) {
            return size;
        }
        if (this.rowLevelWidths == null) {
            this.rowLevelWidths = new ArrayList();
        }
        if ((listSize = this.rowLevelWidths.size()) > level && level >= 0 && (obj = this.rowLevelWidths.get(level)) != null && obj instanceof Integer && (i = ((Integer)obj).intValue()) != -1) {
            return i;
        }
        int rowLevelWidth = 0;
        if (((OLAPTableView)this.getTable()).getOriginComponent() instanceof OLAPOriginComponent) {
            rowLevelWidth = ((OLAPOriginComponent)((Object)((OLAPTableView)this.getTable()).getOriginComponent())).getPreferredRowLevelWidth(level);
        }
        rowLevelWidth = Math.max(this.getPreferredLevelWidth(level), rowLevelWidth);
        for (i = listSize; i < level + 1; ++i) {
            this.rowLevelWidths.add(i, new Integer(-1));
        }
        this.rowLevelWidths.set(level, new Integer(rowLevelWidth));
        return rowLevelWidth;
    }

    public int getPreferredLevelWidth(int level) {
        int levelWidth = 0;
        try {
            TupleElementInterface[] tupleElements = OLAPUtil.getTupleElementsForLevel((int)level, (TupleInterface[])this.getTuples(), (boolean)false, (int)-1);
            for (int j = 0; j < tupleElements.length; ++j) {
                Component comp = this.getHeaderRendererComponent(tupleElements[j], level, tupleElements[j].getMaximumCoordinate());
                int rendererWidth = comp.getPreferredSize().width;
                levelWidth = Math.max(levelWidth, rendererWidth);
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return levelWidth;
    }

    public Component getHeaderRendererComponent(TupleElementInterface element, int level, int row) {
        TableCellRenderer renderer = null;
        if (renderer == null) {
            renderer = this.getDefaultRenderer();
        }
        boolean selected = false;
        int levelCount = this.getMaxLevelCount();
        int rowCount = this.table.getRowCount();
        TupleElementInterface[] elements = this.getTupleElementsForCoordinate(row);
        int span = 0;
        try {
            for (int i = 0; i < elements.length && i <= level; ++i) {
                int sp = elements[i].getSpan();
                if (sp <= 1) continue;
                span += sp - 1;
            }
            span += element.getSpanDepth() - 1;
        }
        catch (OLAPException i) {
            // empty catch block
        }
        int ordinal = row + Math.max(0, levelCount - 1 - level - span) * rowCount;
        if (this.getTable().isRowSelected(ordinal)) {
            selected = true;
        }
        boolean hasFocus = false;
        if (this.getTable().isFocusOwner()) {
            int curCol = ((OLAPTableView)this.getTable()).getCurrentColumn();
            int curRow = ((OLAPTableView)this.getTable()).getCurrentRow();
            if (curCol < 0 && curRow >= 0) {
                int curLevel = this.getMaxLevelCount() - 1 - (Math.abs(curCol) - 1);
                try {
                    TupleElementInterface tupleElement = this.getTupleElementAt(curRow, curLevel);
                    if (tupleElement != null && tupleElement.getMinimumCoordinate() == element.getMinimumCoordinate() && tupleElement.getMaximumCoordinate() == element.getMaximumCoordinate() && tupleElement.getTupleElementIndex() == element.getTupleElementIndex()) {
                        hasFocus = true;
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return renderer.getTableCellRendererComponent((JTable)this.getTable(), element, selected, hasFocus, row, level);
    }

    protected TableCellRenderer createDefaultRenderer() {
        OLAPHeaderRenderer label = new OLAPHeaderRenderer();
        label.setHorizontalAlignment(10);
        return label;
    }

    public void setLevelWidth(int level, int levelWidth) {
        if (levelWidth < 0) {
            throw new IllegalArgumentException("New level width less than 0");
        }
        this.getLevelWidths().setSize(level, levelWidth);
        this.resizeAndRepaint();
    }

    public int calculatePreferredHeightForRow(int row) {
        if (this.getTable() != null && this.getAxis() != null && this.getResizingAllowed()) {
            int rowCount = this.getTable().getRowCount();
            int rowSize = 0;
            int cellSpacing = this.getTable().getRowMargin();
            int maxCellHeight = 0;
            int colCount = this.cellsToSizeCount < 0 ? this.table.getColumnCount() : Math.min(this.table.getColumnCount(), this.cellsToSizeCount);
            for (int c = 0; c < colCount; ++c) {
                Component component = this.getTable().prepareRenderer(this.getTable().getCellRenderer(row, c), row, c);
                int cellHeight = component.getPreferredSize().height;
                if (cellHeight <= maxCellHeight) continue;
                maxCellHeight = cellHeight;
            }
            rowSize = maxCellHeight += cellSpacing;
            try {
                TupleElementInterface[] elements = this.getTupleElementsForCoordinate(row);
                for (int i = 0; i < elements.length; ++i) {
                    Component component = this.getHeaderRendererComponent(elements[i], i, row);
                    int headerHeight = component.getPreferredSize().height;
                    if (headerHeight <= rowSize) continue;
                    int min = elements[i].getMinimumCoordinate();
                    int max = elements[i].getMaximumCoordinate();
                    if (max >= rowCount) {
                        return -1;
                    }
                    if (min != max) {
                        rowSize = headerHeight;
                        int height = 0;
                        int mmax = Math.min(max, rowCount - 1);
                        for (int j = min; j <= mmax; ++j) {
                            if (j == row) {
                                height += rowSize;
                                continue;
                            }
                            height += this.getTable().getRowHeight(j);
                        }
                        if (height < headerHeight) {
                            rowSize += headerHeight - height;
                        }
                        i = max;
                        continue;
                    }
                    rowSize = headerHeight;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            return rowSize;
        }
        return -1;
    }
}

