/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.SortHeaderRenderer;
import com.sas.swing.visuals.util.LayoutConstants;
import java.awt.Component;
import javax.swing.JTable;

@SASScope(value="ALL")
public class OLAPHeaderRenderer
extends SortHeaderRenderer
implements LayoutConstants {
    public OLAPHeaderRenderer() {
        this(null);
    }

    public OLAPHeaderRenderer(Character splitCharacter) {
        super(splitCharacter);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setLeadingContentOffset(0);
        this.setTopContentOffset(0);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setIcon(null);
        if (value instanceof TupleElementInterface) {
            try {
                TupleElementInterface element = (TupleElementInterface)value;
                int depth = element.getSpanDepth();
                if (depth > 1) {
                    OLAPTableView olapTable = (OLAPTableView)((Object)table);
                    int axisNumber = element.getTuple().getAxis().getAxisNumber();
                    if (axisNumber == 1) {
                        OLAPRowHeader header = (OLAPRowHeader)olapTable.getRowHeader();
                        int offset = 0;
                        for (int i = 1; i < depth; ++i) {
                            if (column - i < 0) continue;
                            offset += header.getLevelWidth(column - i);
                        }
                        this.setLeadingContentOffset(offset);
                    } else if (axisNumber == 0) {
                        OLAPColumnHeader header = (OLAPColumnHeader)olapTable.getColumnHeader();
                        int offset = 0;
                        for (int i = 1; i < depth; ++i) {
                            if (row - i < 0) continue;
                            offset += header.getLevelHeight(row - i);
                        }
                        this.setTopContentOffset(offset);
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return this;
    }
}

