/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.SwingActionProviderViewInterface;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.util.Action;
import com.sas.swing.visuals.BasicButton;
import com.sas.swing.visuals.olaptableview.OLAPCellRendererManager;
import com.sas.swing.visuals.olaptableview.OLAPDrillStateUtil;
import com.sas.swing.visuals.olaptableview.RB;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@SASScope(value="ALL")
public class OLAPDrillState
extends JComponent
implements SwingActionProviderViewInterface,
ContentsChangedListener {
    public static final String RB_KEY = "OLAPDrillState.";
    private JPanel drillStatePanel;
    private SwingViewerSupport viewerSupport;
    private OLAPDataSetInterface model;
    private int labelType;
    private boolean includeAllMember;
    private List drillStateActionList = new ArrayList();
    private List labelList = new ArrayList();
    private Icon lineIcon;
    private Icon noLineIcon;
    private String separator;
    private String separatorImage;
    private Color color;
    private Font font;
    private Color separatorColor;
    private Font separatorFont;
    private Color labelColor;
    private Font labelFont;

    public OLAPDrillState() {
        this.viewerSupport = new SwingViewerSupport((ActionProviderViewInterface)this);
        this.viewerSupport.setActionSupportType("OLAP_DRILLSTATE_SUPPORT");
        this.viewerSupport.setActionProvider(new SwingActionProvider());
        this.lineIcon = new LineIcon(true);
        this.noLineIcon = new LineIcon(false);
        this.color = SystemColor.activeCaption;
        this.separatorColor = SystemColor.activeCaption;
        this.labelColor = SystemColor.controlText;
        this.separator = ">";
        this.labelType = 0;
        this.createLayout();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OLAPDrillState.this.refresh();
            }
        });
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    protected void createLayout() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 0, 0, true, true, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)layout);
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setModel(OLAPDataSetInterface model) {
        OLAPDataSetInterface oldModel = this.getModel();
        if (oldModel != model) {
            this.model = model;
            this.getDrillStateActions();
            this.refreshDrillStateView();
            this.firePropertyChange("model", oldModel, model);
        }
    }

    public void setLabelType(int labelType) {
        if (labelType != 1 && labelType != 2 && labelType != 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidLabelType.txt"));
        }
        this.labelType = labelType;
    }

    public int getLabelType() {
        return this.labelType;
    }

    @SASScope
    public void setIncludeAllMember(boolean includeAllMember) {
        if (this.includeAllMember != includeAllMember) {
            this.includeAllMember = includeAllMember;
            this.getDrillStateActions();
            this.refreshDrillStateView();
        }
    }

    @SASScope
    public boolean getIncludeAllMember() {
        return this.includeAllMember;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        this.getDrillStateActions();
        this.refreshDrillStateView();
    }

    protected void getDrillStateActions() {
        List drillState = OLAPDrillStateUtil.getOLAPDrillStateInfo(this.model, this.includeAllMember);
        if (drillState != null) {
            this.drillStateActionList.clear();
            this.labelList.clear();
            for (List dimensionDrillInfo : drillState) {
                if (dimensionDrillInfo.size() != 7) continue;
                ArrayList labels = new ArrayList(2);
                labels.add(dimensionDrillInfo.get(0));
                labels.add(dimensionDrillInfo.get(1));
                this.labelList.add(labels);
                ActionSupportFilter filter = new ActionSupportFilter(this.getActionSupportType(), "DRILL_STATE_AREA", (ActionProviderViewInterface)this);
                try {
                    filter.setAttribute("model", (Object)this.getModel());
                    filter.setAttribute("isAllLevel", dimensionDrillInfo.get(2));
                    filter.setAttribute("drillStateLabels", dimensionDrillInfo.get(3));
                    filter.setAttribute("drillStateUniqueNames", dimensionDrillInfo.get(4));
                    filter.setAttribute("tupleElement", dimensionDrillInfo.get(5));
                    if (this.getModel() instanceof BusinessQueryProviderInterface) {
                        BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.getModel()).getBusinessQuery();
                        filter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem(businessQuery, (TupleElementInterface)dimensionDrillInfo.get(5)));
                    }
                    filter.setAttribute("includeAllLevel", dimensionDrillInfo.get(6));
                }
                catch (AttributeSetException ase) {
                    throw new IllegalStateException(ase.getMessage());
                }
                ActionList actionList = null;
                SwingActionProvider actionProvider = this.getActionProvider();
                if (actionProvider == null) continue;
                actionList = actionProvider.getActions(filter);
                this.drillStateActionList.add(actionList);
            }
        }
    }

    protected void refreshDrillStateView() {
        this.removeAll();
        if (this.drillStateActionList != null) {
            ImageIcon imageIcon = null;
            if (this.separatorImage != null) {
                imageIcon = new ImageIcon(this.separatorImage);
            }
            int size = this.drillStateActionList.size();
            for (int i = 0; i < size; ++i) {
                ActionList actionList = (ActionList)this.drillStateActionList.get(i);
                if (actionList == null) continue;
                JPanel panel = new JPanel(new DrillStateLayout(0, 0, 0));
                this.add(panel);
                JLabel label = this.getLabel(i);
                if (label != null) {
                    panel.add(label);
                }
                List actions = actionList.getActions();
                Iterator actionIterator = actions.iterator();
                while (actionIterator.hasNext()) {
                    Action action = (Action)actionIterator.next();
                    Object linkValue = action.getValue("link");
                    if (linkValue instanceof Boolean && ((Boolean)linkValue).booleanValue()) {
                        AbstractButton button = this.getButton(action);
                        panel.add(button);
                    } else {
                        JLabel labelItem = this.getLabel((String)action.getValue("Name"));
                        panel.add(labelItem);
                    }
                    if (!actionIterator.hasNext()) continue;
                    if (imageIcon != null) {
                        panel.add(new JLabel(imageIcon));
                        continue;
                    }
                    JLabel sepLabel = new JLabel(this.getSeparator());
                    sepLabel.setFont(this.getSeparatorFont());
                    sepLabel.setForeground(this.getSeparatorColor());
                    panel.add(sepLabel);
                }
            }
        }
        this.refresh();
    }

    private JLabel getLabel(int i) {
        JLabel label = null;
        String labelText = null;
        if (this.getLabelType() == 1) {
            List labels = (List)this.labelList.get(i);
            labelText = (String)labels.get(0);
        } else if (this.getLabelType() == 2) {
            List labels = (List)this.labelList.get(i);
            labelText = (String)labels.get(1);
        }
        if (labelText != null && labelText.length() > 0) {
            label = new JLabel(Message.format((String)RB.getStringResource("label.txt"), (Object)labelText));
            label.setFont(this.getLabelFont());
            label.setForeground(this.getLabelColor());
        }
        return label;
    }

    private JLabel getLabel(String text) {
        JLabel label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        if (this.getFont() != null) {
            label.setFont(this.font);
        }
        label.setForeground(this.getColor());
        return label;
    }

    private AbstractButton getButton(Action action) {
        BasicButton button = new BasicButton((javax.swing.Action)action);
        button.setFocusPainted(false);
        button.setMargin(new Insets(0, 0, 0, 3));
        button.setIcon(this.noLineIcon);
        button.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        if (this.getFont() != null) {
            button.setFont(this.font);
        }
        button.setForeground(this.getColor());
        button.setBorderPainted(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                button.setForeground(OLAPDrillState.this.color.darker().darker());
                button.setIcon(OLAPDrillState.this.lineIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                button.setForeground(OLAPDrillState.this.color);
                button.setIcon(OLAPDrillState.this.noLineIcon);
            }
        });
        return button;
    }

    private void refresh() {
        Component component = SwingUtilities.getRoot(this);
        if (component != null) {
            this.validate();
            this.invalidate();
            component.validate();
        }
    }

    @Override
    public void setFont(Font font) {
        Font old = this.getFont();
        if (old != font) {
            this.font = font;
            this.refreshDrillStateView();
            this.firePropertyChange("font", old, font);
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public void setLabelFont(Font labelFont) {
        Font old = this.getLabelFont();
        if (old != labelFont) {
            this.labelFont = labelFont;
            this.refreshDrillStateView();
            this.firePropertyChange("labelFont", old, labelFont);
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setColor(Color color) {
        Color old = this.getColor();
        if (old != color) {
            this.color = color;
            this.refreshDrillStateView();
            this.firePropertyChange("color", old, color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setLabelColor(Color labelColor) {
        Color old = this.getLabelColor();
        if (old != labelColor) {
            this.labelColor = labelColor;
            this.refreshDrillStateView();
            this.firePropertyChange("lableColor", old, labelColor);
        }
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setSeparator(String value) {
        String old = this.getSeparator();
        if (!old.equals(value)) {
            this.separator = value;
            this.refreshDrillStateView();
            this.firePropertyChange("separator", old, value);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparatorImage(String value) {
        String old = this.getSeparatorImage();
        if (!old.equals(value)) {
            this.separatorImage = value;
            this.refreshDrillStateView();
            this.firePropertyChange("separatorImage", old, value);
        }
    }

    public String getSeparatorImage() {
        return this.separatorImage;
    }

    public void setSeparatorColor(Color separatorColor) {
        Color old = this.getSeparatorColor();
        if (old != separatorColor) {
            this.separatorColor = separatorColor;
            this.refreshDrillStateView();
            this.firePropertyChange("separatorColor", old, separatorColor);
        }
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorFont(Font separatorFont) {
        Font old = this.getSeparatorFont();
        if (old != separatorFont) {
            this.separatorFont = separatorFont;
            this.refreshDrillStateView();
            this.firePropertyChange("separatorFont", old, separatorFont);
        }
    }

    public Font getSeparatorFont() {
        return this.separatorFont;
    }

    public void setActionProvider(SwingActionProvider actionProvider) {
        if (this.viewerSupport.getActionProvider() != actionProvider) {
            SwingActionProvider old = this.viewerSupport.getActionProvider();
            if (old != null) {
                old.removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.viewerSupport.setActionProvider(actionProvider);
            if (actionProvider != null) {
                actionProvider.addContentsChangedListener((ContentsChangedListener)this);
            }
            this.getDrillStateActions();
            this.refreshDrillStateView();
            this.firePropertyChange("actionProvider", old, actionProvider);
        }
    }

    public SwingActionProvider getActionProvider() {
        if (this.viewerSupport.getActionProvider() == null) {
            this.setActionProvider(new SwingActionProvider());
        }
        return this.viewerSupport.getActionProvider();
    }

    public void setActionVisible(String actionType, String areaType, boolean visible) {
        this.viewerSupport.setActionVisible(actionType, areaType, visible);
    }

    public boolean isActionVisible(String actionType, String areaType) {
        return this.viewerSupport.isActionVisible(actionType, areaType);
    }

    public Object getUniqueId() {
        return this.viewerSupport.getUniqueId();
    }

    public void setUniqueId(Object uniqueId) {
        this.viewerSupport.setUniqueId(uniqueId);
    }

    public Collection listAreaTypes() {
        return this.viewerSupport.listAreaTypes();
    }

    public Collection listActionTypes(String areaType) {
        return this.viewerSupport.listActionTypes(areaType);
    }

    public void setActionSupportType(String actionSupportType) {
        if (this.viewerSupport.getActionSupportType().equals(actionSupportType)) {
            String old = this.viewerSupport.getActionSupportType();
            this.viewerSupport.setActionSupportType(actionSupportType);
            this.firePropertyChange("actionSupportType", old, actionSupportType);
        }
    }

    public String getActionSupportType() {
        return this.viewerSupport.getActionSupportType();
    }

    @SASScope
    class LineIcon
    implements Icon {
        private boolean draw;

        public LineIcon(boolean draw) {
            this.draw = draw;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.draw) {
                String label = ((AbstractButton)c).getText();
                FontMetrics fm = g.getFontMetrics();
                int lineWidth = fm.stringWidth(label);
                int heightOffSet = fm.getHeight() / 2 - 1;
                g.setColor(c.getForeground());
                int leftInsets = ((AbstractButton)c).getInsets().left;
                int xStart = x + leftInsets + 3;
                g.drawLine(xStart, y + heightOffSet, xStart + lineWidth, y + heightOffSet);
            }
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    @SASScope
    class DrillStateLayout
    extends FlowLayout {
        public DrillStateLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getWrappedHeight(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                boolean spanned = false;
                Insets insets = target.getInsets();
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                int width = target.getSize().width;
                if (width == 0) {
                    return -1;
                }
                int maxwidth = width - (insets.left + insets.right + hgap * 2);
                int nmembers = target.getComponentCount();
                int x = 0;
                int rowh = 0;
                int totalHeight = 0;
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = m.getPreferredSize();
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        if (spanned && d.height > rowh) {
                            totalHeight = totalHeight - rowh + d.height;
                        }
                        rowh = Math.max(rowh, d.height);
                        continue;
                    }
                    if (!spanned && rowh != 0) {
                        totalHeight += vgap + rowh;
                    }
                    spanned = true;
                    x = d.width;
                    rowh = d.height;
                    totalHeight += vgap + rowh;
                }
                if (!spanned) {
                    totalHeight = rowh + vgap * 2;
                }
                return totalHeight;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container target) {
            Dimension dim = super.preferredLayoutSize(target);
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets = target.getInsets();
                int height = this.getWrappedHeight(target);
                if (height > 0) {
                    dim.height = height + insets.top + insets.bottom;
                }
                return dim;
            }
        }
    }
}

