/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.CellSelectionModel;
import com.sas.swing.visuals.tableview.TableView;
import java.util.BitSet;

@SASScope(value="ALL")
public class OLAPColumnHeaderSelectionModel
extends CellSelectionModel {
    public OLAPColumnHeaderSelectionModel() {
        this(null);
    }

    public OLAPColumnHeaderSelectionModel(OLAPTableView table) {
        super((TableView)table);
    }

    protected int getMinColumn(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        if (this.getTable() != null) {
            int column = 0;
            int columnCount = 0;
            columnCount = this.getTable().getColumnCount();
            column = ordinal % columnCount;
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getTableHeader() instanceof OLAPColumnHeader) {
                int level = 0;
                int levelCount = 1;
                OLAPColumnHeader header = (OLAPColumnHeader)((Object)((OLAPTableView)this.getTable()).getTableHeader());
                try {
                    levelCount = header.getMaxLevelCount();
                    TupleElementInterface[] elements = header.getTupleElementsForCoordinate(column);
                    level = levelCount - 1 - ordinal / columnCount;
                    TupleElementInterface tupleElement = header.getTupleElementAt(column, level);
                    return tupleElement.getMinimumCoordinate();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return ordinal;
    }

    protected int getMaxColumn(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        if (this.getTable() != null) {
            int column = 0;
            int columnCount = 0;
            columnCount = this.getTable().getColumnCount();
            column = ordinal % columnCount;
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getTableHeader() instanceof OLAPColumnHeader) {
                int level = 0;
                int levelCount = 1;
                OLAPColumnHeader header = (OLAPColumnHeader)((Object)((OLAPTableView)this.getTable()).getTableHeader());
                try {
                    levelCount = header.getMaxLevelCount();
                    TupleElementInterface[] elements = header.getTupleElementsForCoordinate(column);
                    level = levelCount - 1 - ordinal / columnCount;
                    TupleElementInterface tupleElement = header.getTupleElementAt(column, level);
                    return tupleElement.getMaximumCoordinate();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return ordinal;
    }

    protected int getMinLevel(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        return 0;
    }

    protected int getMaxLevel(int ordinal) {
        if (ordinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (ordinal == -1) {
            return -1;
        }
        if (this.getTable() != null) {
            int column = 0;
            int columnCount = 0;
            columnCount = this.getTable().getColumnCount();
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getTableHeader() instanceof OLAPColumnHeader) {
                int level = 0;
                int levelCount = 1;
                OLAPColumnHeader header = (OLAPColumnHeader)((Object)((OLAPTableView)this.getTable()).getTableHeader());
                levelCount = header.getMaxLevelCount();
                level = ordinal / columnCount;
                column = ordinal % columnCount;
                int levelCount2 = header.getLevelCount(column);
                if (levelCount != levelCount2) {
                    TupleElementInterface[] elements = header.getTupleElementsForCoordinate(column);
                    int levelDepth = 0;
                    for (int i = elements.length - 1; i >= 0; --i) {
                        try {
                            if ((levelDepth += elements[i].getSpan()) > level) {
                                return levelDepth - 1;
                            }
                            continue;
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                    }
                }
                return level;
            }
        }
        return 0;
    }

    protected void changeSelection(BitSet bits, int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        int levelCount = 1;
        int columnCount = 0;
        if (this.getTable() != null) {
            columnCount = this.getTable().getColumnCount();
            if (this.getTable() instanceof OLAPTableView && ((OLAPTableView)this.getTable()).getTableHeader() instanceof OLAPColumnHeader) {
                OLAPColumnHeader header = (OLAPColumnHeader)((Object)((OLAPTableView)this.getTable()).getTableHeader());
                levelCount = header.getMaxLevelCount();
            }
        }
        int clearLevel1 = Math.min(this.getMinLevel(clearMin), this.getMinLevel(clearMax));
        int clearLevel2 = Math.max(this.getMaxLevel(clearMin), this.getMaxLevel(clearMax));
        int clearMaxLevel = Math.max(clearLevel1, clearLevel2);
        if (clearMax == -1) {
            clearMaxLevel = -1;
        }
        if (clearMaxLevel == Integer.MAX_VALUE) {
            clearMaxLevel = levelCount - 1;
        }
        int clearColumn1 = Integer.MAX_VALUE;
        int clearColumn2 = -1;
        if (clearMin != Integer.MAX_VALUE) {
            clearColumn1 = clearMin % columnCount;
        }
        if (clearMax != -1) {
            clearColumn2 = clearMax % columnCount;
        }
        clearMaxLevel = Math.min(levelCount - 1, clearMaxLevel);
        int ord1 = this.createOrdinal(clearMaxLevel, clearColumn1);
        int ord2 = this.createOrdinal(clearMaxLevel, clearColumn2);
        int clearMinColumn = Math.min(this.getMinColumn(ord1), this.getMinColumn(ord2));
        int clearMaxColumn = Math.max(this.getMaxColumn(ord1), this.getMaxColumn(ord2));
        if (clearMinColumn == -1) {
            clearMinColumn = clearColumn1;
        }
        if (clearMaxColumn == Integer.MAX_VALUE) {
            clearMaxColumn = clearColumn2;
        }
        int level1 = Math.min(this.getMinLevel(setMin), this.getMinLevel(setMax));
        int level2 = Math.max(this.getMaxLevel(setMin), this.getMaxLevel(setMax));
        int maxLevel = Math.max(level1, level2);
        if (setMax == -1) {
            maxLevel = -1;
        }
        if (maxLevel == Integer.MAX_VALUE) {
            maxLevel = levelCount - 1;
        }
        int column1 = Integer.MAX_VALUE;
        int column2 = -1;
        if (setMin != Integer.MAX_VALUE) {
            column1 = setMin % columnCount;
        }
        if (setMax != -1) {
            column2 = setMax % columnCount;
        }
        maxLevel = Math.min(levelCount - 1, maxLevel);
        ord1 = this.createOrdinal(maxLevel, column1);
        ord2 = this.createOrdinal(maxLevel, column2);
        int minColumn = Math.min(this.getMinColumn(ord1), this.getMinColumn(ord2));
        int maxColumn = Math.max(this.getMaxColumn(ord1), this.getMaxColumn(ord2));
        if (minColumn == -1) {
            minColumn = column1;
        }
        if (maxColumn == Integer.MAX_VALUE) {
            maxColumn = column2;
        }
        clearMin = Integer.MAX_VALUE;
        clearMax = -1;
        setMin = Integer.MAX_VALUE;
        setMax = -1;
        int max = Math.max(clearMaxLevel, maxLevel);
        for (int i = 0; i <= max; ++i) {
            if (i > clearMaxLevel) {
                clearMinColumn = Integer.MAX_VALUE;
                clearMaxColumn = -1;
                clearMin = Integer.MAX_VALUE;
                clearMax = -1;
            }
            if (i > maxLevel) {
                minColumn = Integer.MAX_VALUE;
                maxColumn = -1;
                setMin = Integer.MAX_VALUE;
                setMax = -1;
            }
            if (clearMinColumn != Integer.MAX_VALUE) {
                clearMin = this.createOrdinal(i, clearMinColumn);
            }
            if (clearMaxColumn != -1) {
                clearMax = this.createOrdinal(i, clearMaxColumn);
            }
            if (minColumn != Integer.MAX_VALUE) {
                setMin = this.createOrdinal(i, minColumn);
            }
            if (maxColumn != -1) {
                setMax = this.createOrdinal(i, maxColumn);
            }
            int max2 = Math.max(setMax, clearMax);
            for (int j = Math.min(setMin, clearMin); j <= max2; ++j) {
                boolean shouldClear = this.contains(clearMin, clearMax, j);
                boolean shouldSet = this.contains(setMin, setMax, j);
                if (shouldSet && shouldClear) {
                    if (clearFirst) {
                        shouldClear = false;
                    } else {
                        shouldSet = false;
                    }
                }
                if (shouldSet) {
                    this.set(bits, j);
                }
                if (!shouldClear) continue;
                this.clear(bits, j);
            }
        }
        this.validateMinAndMaxOrdinal();
        this.fireValueChanged();
    }
}

