/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.visuals.olaptableview.OLAPTableFormatArea;
import com.sas.swing.visuals.olaptableview.ROLAPUtil;
import com.sas.swing.visuals.tableview.CombiningRendererInterface;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@SASScope
public class OLAPCellRendererManager {
    private Map renderers_ = new LinkedHashMap(1, 1000.0f);
    private OLAPDataSetInterface dataSet_ = null;
    private String matchingMeasure_;
    private int matchingMeasureLocation_ = Integer.MIN_VALUE;
    private TupleElementInterface[] slicer_;
    private TupleElementInterface matchingMeasureTupleElement_;
    private Map measureNameMap_ = new HashMap();
    private static final TupleElementInterface[] NO_TUPLE_ELEMENTS = new TupleElementInterface[0];

    public void setCellRenderer(String[][] levelMap, String measure, Object renderer) {
        OLAPTableFormatArea area = new OLAPTableFormatArea(levelMap, measure);
        this.setCellRenderer(area, renderer);
    }

    public void setCellRenderer(OLAPTableFormatArea area, Object renderer) {
        this.renderers_.put(area, renderer);
    }

    @SASScope
    public OLAPTableFormatArea[] getCellRendererAreas(Object renderer) {
        ArrayList areas = new ArrayList();
        for (Map.Entry entry : this.renderers_.entrySet()) {
            Object obj = entry.getValue();
            if (obj != renderer) continue;
            areas.add(entry.getKey());
        }
        return areas.toArray(new OLAPTableFormatArea[areas.size()]);
    }

    public Object getCellRenderer(TupleElementInterface[] column, TupleElementInterface[] row) {
        this.resetPerRendererCachedValues();
        boolean isTotal = OLAPCellRendererManager.isTotals(column) || OLAPCellRendererManager.isTotals(row);
        CombiningRendererInterface combiningRenderer = null;
        Object[] entries = this.renderers_.entrySet().toArray();
        for (int i = entries.length - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)entries[i];
            OLAPTableFormatArea area = (OLAPTableFormatArea)entry.getKey();
            if (!this.areasMatch(area, column, row, isTotal)) continue;
            Object renderer = entry.getValue();
            if (combiningRenderer != null) {
                boolean combinedOK = combiningRenderer.combineWith(renderer);
                if (combinedOK && combiningRenderer.isCombining()) continue;
                return combiningRenderer;
            }
            if (renderer instanceof CombiningRendererInterface) {
                combiningRenderer = (CombiningRendererInterface)renderer;
                if (combiningRenderer.isCombining()) continue;
                return renderer;
            }
            return renderer;
        }
        return combiningRenderer;
    }

    private boolean areasMatch(OLAPTableFormatArea area, TupleElementInterface[] column, TupleElementInterface[] row, boolean isTotal) {
        if (isTotal && area.getMeasure() != null) {
            return false;
        }
        String[][] levelMap = area.getLevelMap();
        for (int i = 0; i < levelMap.length; ++i) {
            if (this.levelMatches(levelMap[i], column, row)) continue;
            return false;
        }
        String measure = area.getMeasure();
        return measure == null || this.measureMatches(measure, column, row);
    }

    private boolean levelMatches(String[] levelInfo, TupleElementInterface[] column, TupleElementInterface[] row) {
        String dim = levelInfo[0];
        String hier = levelInfo[1];
        String level = levelInfo[2];
        return this.levelMatches(dim, hier, level, column) || this.levelMatches(dim, hier, level, row) || this.levelMatches(dim, hier, level, this.getSlicer());
    }

    private static boolean isTotals(TupleElementInterface[] tuples) {
        for (int i = 0; i < tuples.length; ++i) {
            try {
                TupleElementInterface tuple = tuples[i];
                if (tuple.getType() != TupleElementType.TOTAL && tuple.getType() != TupleElementType.SUBTOTAL) continue;
                return true;
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private boolean levelMatches(String dim, String hier, String level, TupleElementInterface[] tuples) {
        for (int i = 0; i < tuples.length; ++i) {
            try {
                TupleElementInterface tuple = tuples[i];
                if (tuple.isContextual() || !tuple.getUniqueLevelName().equalsIgnoreCase("[" + dim + "].[" + level + "]") && !tuple.getUniqueLevelName().equalsIgnoreCase("[" + dim + "].[" + hier + "].[" + level + "]")) continue;
                return true;
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private boolean measureMatches(String measure, TupleElementInterface[] column, TupleElementInterface[] row) {
        return this.measureMatches(measure, column, 0) || this.measureMatches(measure, row, 1) || this.measureMatches(measure, this.getSlicer(), -1);
    }

    private boolean measureMatches(String measure, TupleElementInterface[] tuples, int axis) {
        if (this.matchingMeasureLocation_ == Integer.MIN_VALUE || this.matchingMeasureLocation_ == axis) {
            return this.measureMatches(measure, tuples);
        }
        return false;
    }

    private boolean measureMatches(String measure, TupleElementInterface[] tuples) {
        for (int i = 0; i < tuples.length; ++i) {
            TupleElementInterface tuple = tuples[i];
            try {
                if (tuple.getType() != TupleElementType.MEASURE) continue;
                this.matchingMeasureLocation_ = tuple.getTuple().getAxis().getAxisNumber();
                String curMeasure = this.getMeasureName(tuple);
                if (!measure.equalsIgnoreCase(curMeasure)) continue;
                this.matchingMeasure_ = measure;
                this.matchingMeasureTupleElement_ = tuple;
                return true;
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public String getMeasureName(TupleElementInterface tupleElement) throws OLAPException {
        String measure = (String)this.measureNameMap_.get(tupleElement.getName());
        if (measure != null) {
            return measure;
        }
        DataItem di = this.findDataItem(tupleElement);
        measure = di == null ? tupleElement.getLabel() : di.getResultSetID();
        this.measureNameMap_.put(tupleElement.getName(), measure);
        return measure;
    }

    public void removeAll() {
        this.renderers_.clear();
    }

    public void remove(Collection collection) {
        TableViewUtil.removeCellRenderers((Map)this.renderers_, (Collection)collection);
    }

    public String getResultSetID(TupleElementInterface tupleElement) throws OLAPException {
        Map cache = this.measureNameMap_;
        String uln = tupleElement.getUniqueLevelName();
        String rid = (String)cache.get(uln);
        if (rid != null) {
            return rid;
        }
        DataItem di = this.findDataItem(tupleElement);
        rid = di == null ? tupleElement.getLabel() : di.getResultSetID();
        cache.put(uln, rid);
        return rid;
    }

    private DataItem findDataItem(TupleElementInterface tupleElement) {
        if (this.dataSet_ instanceof BusinessQueryProviderInterface) {
            BusinessQueryProviderInterface bqProvider = (BusinessQueryProviderInterface)this.dataSet_;
            return OLAPCellRendererManager.findDataItem(bqProvider.getBusinessQuery(), tupleElement);
        }
        return null;
    }

    public static DataItem findDataItem(BusinessQuery businessQuery, TupleElementInterface tupleElement) {
        DataItem dataItem = null;
        try {
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel == null) {
                return null;
            }
            StructureOfData structure = businessModel.getStructure();
            if (structure.isOLAP()) {
                dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, null, (Object)tupleElement, (int)1);
            } else if (structure.isRelational()) {
                dataItem = ROLAPUtil.findDataItem(businessQuery, tupleElement);
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return dataItem;
    }

    public static DataItem findDataItem(BusinessQuery businessQuery, OLAPDataSetInterface dataSet, String uniqueLevelName) {
        DataItem dataItem = null;
        try {
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel == null) {
                return null;
            }
            StructureOfData structure = businessModel.getStructure();
            if (structure.isOLAP()) {
                dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)dataSet, (Object)uniqueLevelName, (int)3);
            } else if (structure.isRelational()) {
                dataItem = ROLAPUtil.findDataItem(businessQuery, dataSet, uniqueLevelName);
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)OLAPCellRendererManager.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return dataItem;
    }

    public OLAPDataSetInterface getDataSet() {
        return this.dataSet_;
    }

    public void setDataSet(OLAPDataSetInterface dataSet) {
        this.dataSet_ = dataSet;
        this.slicer_ = null;
        this.measureNameMap_.clear();
        this.resetPerRendererCachedValues();
    }

    private void resetPerRendererCachedValues() {
        this.matchingMeasure_ = null;
        this.matchingMeasureLocation_ = Integer.MIN_VALUE;
        this.matchingMeasureTupleElement_ = null;
    }

    public String getMatchingMeasure() {
        return this.matchingMeasure_;
    }

    public TupleElementInterface[] getSlicer() {
        if (this.slicer_ != null) {
            return this.slicer_;
        }
        try {
            AxisInterface[] axes = this.dataSet_.getResultSetMetadata().getAxes(-1, 1);
            AxisInterface axis = axes[0];
            if (axis == null) {
                this.slicer_ = NO_TUPLE_ELEMENTS;
                return NO_TUPLE_ELEMENTS;
            }
            TupleInterface[] tuples = axis.getTuples(0, -1);
            if (tuples.length > 0) {
                TupleInterface tuple = tuples[0];
                this.slicer_ = tuple.getElements(0, tuple.getTupleDepth());
                return this.slicer_;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.slicer_ = NO_TUPLE_ELEMENTS;
        return NO_TUPLE_ELEMENTS;
    }

    public int getMatchingMeasureLocation() {
        return this.matchingMeasureLocation_;
    }

    public TupleElementInterface getMatchingMeasureTupleElement() {
        return this.matchingMeasureTupleElement_;
    }
}

