/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

@SASScope
class UpDownTreeDualSelectorAdapter
extends JTreeDualSelectorAdapter
implements DualSelectorUpDownInterface {
    public UpDownTreeDualSelectorAdapter(JComponent parent) {
        this(new JTree(), parent);
    }

    public UpDownTreeDualSelectorAdapter(JTree tree, JComponent parent) {
        super(tree, parent);
    }

    public int[] getSelectedIndices() {
        return this.component.getSelectionRows();
    }

    public boolean isSelectedIndex(int index) {
        return this.component.isRowSelected(index);
    }

    public void moveItems(int[] selectedIndices, int offset) {
        int i;
        DefaultTreeModel model = (DefaultTreeModel)this.component.getModel();
        TreePath[] paths = new TreePath[selectedIndices.length];
        for (i = 0; i < selectedIndices.length; ++i) {
            paths[i] = this.component.getPathForRow(selectedIndices[i]);
        }
        for (i = 0; i < paths.length; ++i) {
            int count = paths[i].getPathCount();
            if (count <= 1) continue;
            MutableTreeNode parent = (MutableTreeNode)paths[i].getPathComponent(count - 2);
            MutableTreeNode child = (MutableTreeNode)paths[i].getLastPathComponent();
            int index = model.getIndexOfChild(parent, child);
            int childCount = model.getChildCount(parent);
            if (index + offset < 0 || index + offset >= childCount) continue;
            model.removeNodeFromParent(child);
            model.insertNodeInto(child, parent, index + offset);
        }
    }

    public int getCount() {
        return this.component.getRowCount();
    }
}

