/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.ISUtility;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.visuals.BaseRemoteObjectPicker;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Component;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTextField;

@SASScope
public class SASLibraryPicker
extends BaseRemoteObjectPicker {
    public static final String RB_KEY = "SASLibraryPicker.";
    private static final long serialVersionUID = -4266846382290931710L;
    private UserContextInterface userContext;
    private RemoteFileModel2Interface model;
    private SASLibraryLocationInterface library;
    private InformationServicesSelectorPanel panel;
    private TextEditor librefValueLabel;

    public SASLibraryPicker(UserContextInterface userContext) {
        this(userContext, null);
    }

    public SASLibraryPicker(UserContextInterface userContext, RemoteFileModel2Interface model) {
        this.init(userContext, model);
    }

    private void init(UserContextInterface userContext, RemoteFileModel2Interface model) {
        this.userContext = userContext;
        this.model = model;
        this.init();
    }

    @Override
    protected void createUI() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 3, 5, 5, true, false, true);
        layout.setRemainderColumn(1);
        this.setLayout((LayoutManager)layout);
        JLabel locationLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"locationLabel.txt", (Locale)this.getLocale()));
        JLabel librefLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"librefLabel.txt", (Locale)this.getLocale()));
        this.add(locationLabel);
        this.add(librefLabel);
        this.add(new JLabel());
        this.locationComponent = this.createLocationComponent();
        this.rfsButton = this.createFileSelectorButton();
        this.addListeners();
        this.librefValueLabel = new TextEditor();
        if (this.librefValueLabel.getTextComponent() instanceof JTextField) {
            ((JTextField)this.librefValueLabel.getTextComponent()).setColumns(10);
        }
        this.librefValueLabel.getTextComponent().setEditable(false);
        this.librefValueLabel.getTextComponent().setOpaque(false);
        this.add(this.locationComponent);
        this.add((Component)this.librefValueLabel);
        this.add(this.rfsButton);
        int[] mins = new int[]{this.locationComponent.getPreferredSize().width, this.librefValueLabel.getPreferredSize().width, 0};
        layout.setColumnSpacePartitioner((SpacePartitionerInterface)new ProportionalSpacePartitioner(new double[]{0.8, 0.2, -2.0}, mins, null, true));
    }

    @Override
    protected BaseRemoteFileSelectorPanel getRemoteFileSelectorPanel() {
        if (null == this.userContext) {
            return this.panel;
        }
        LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
        ArrayList<String> types = new ArrayList<String>();
        fileTypes.put(ISUtility.getLocalizedTypeName((String)"Library", (Locale)this.getLocale()), "Library");
        types.add("Library");
        String startDir = "";
        SASLibraryLocationInterface slli = (SASLibraryLocationInterface)this.getValue();
        if (slli != null) {
            startDir = slli.getSASLibraryLocation();
        }
        if (startDir != null && startDir.length() > 0) {
            int index;
            try {
                try {
                    startDir = PathUrl.newPathUrlFromExistingUrl((ServerInterface)this.userContext.getAuthServer(), (PathUrl)new PathUrl(startDir)).toString();
                }
                catch (IllegalArgumentException ex) {
                    startDir = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.userContext.getAuthServer(), (String)startDir).toString();
                }
            }
            catch (ServiceException e) {
                startDir = null;
            }
            catch (RemoteException e) {
                startDir = null;
            }
            if (startDir != null && (index = startDir.lastIndexOf("/")) != -1) {
                startDir = startDir.substring(0, index) + "(Folder)";
            }
        }
        if (this.panel == null) {
            try {
                if (this.model == null) {
                    this.panel = new InformationServicesSelectorPanel(startDir, this.userContext.getAuthServer(), fileTypes, false);
                } else {
                    this.panel = new InformationServicesSelectorPanel(startDir, this.userContext.getAuthServer(), fileTypes, false);
                    this.panel.removeAll();
                    this.panel.initialize(startDir, this.model, this.panel.getActionSupportType(), fileTypes, this.panel.getViewComponent().getColumnRenderers());
                }
            }
            catch (ServiceException e) {
                this.handleError((Object)e);
            }
            catch (RemoteException e) {
                this.handleError(e);
            }
            this.panel.setShowSystemFolders(false);
            this.panel.setSelectionMode(InformationServicesSelectorPanel.FILES_ONLY);
            this.panel.setMultiSelectionEnabled(false);
        }
        return this.panel;
    }

    @Override
    protected String getRemoteObjectSelectorTitle() {
        return RB.getStringResource((String)RB_KEY, (String)"title.txt", (Locale)this.getLocale());
    }

    @Override
    public Object getValue() {
        if (this.library != null && Strings.equal((String)this.library.getSASLibraryLocation(), (String)this.getText(), (boolean)true, (boolean)false) && Strings.equal((String)this.library.getLibref(), (String)((String)this.librefValueLabel.getValue()), (boolean)true, (boolean)false)) {
            return this.library;
        }
        this.setValue(this.getText());
        return this.library;
    }

    private void setValueText() {
        if (this.library != null) {
            this.setText(this.library.getSASLibraryLocation());
            this.librefValueLabel.setValue((Object)this.library.getLibref());
        } else {
            this.setText(null);
            this.librefValueLabel.setValue(null);
        }
    }

    @Override
    public void setValue(Object anObject) {
        if (!Util.equal((Object)anObject, (Object)this.library)) {
            boolean change = false;
            if (anObject != null) {
                try {
                    if (anObject instanceof SASLibraryLocationInterface) {
                        this.library = DataSourceUtil.getSASLibrary(this.userContext, ((SASLibraryLocationInterface)anObject).getSASLibraryLocation());
                        change = true;
                    } else {
                        String path = anObject.toString().trim();
                        if (path.length() > 0) {
                            SASLibraryLocationInterface lib = DataSourceUtil.getSASLibrary(this.userContext, path);
                            if (lib != null) {
                                this.library = lib;
                                change = true;
                            } else {
                                this.handleError(RB.getStringResource((String)RB_KEY, (String)"illegalPath.ex.txt", (Locale)this.getLocale()));
                            }
                        } else if (this.library != null) {
                            this.library = null;
                            change = true;
                        }
                    }
                }
                catch (ServiceException ex) {
                    this.handleError((Object)ex);
                }
                catch (RemoteException ex) {
                    this.handleError(ex);
                }
                catch (IllegalArgumentException ex) {
                    this.handleError(ex);
                }
            } else if (this.library != null) {
                this.library = null;
                change = true;
            }
            this.setValueText();
            if (change) {
                this.fireValueChanged();
            }
        }
    }
}

