/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.RB;
import com.sas.util.FileValidatorInterface;

@SASScope
public class IFileValidator
implements FileValidatorInterface {
    private static final String RB_KEY = "IFilePicker.";
    protected PromptDataProviderInterface dataProvider;
    protected String logicalServerName;
    private IWorkspace workspace;
    private boolean attemptedWorkspaceFetch;

    public IFileValidator(PromptDataProviderInterface dp, String logicalServerName) {
        this.dataProvider = dp;
        this.logicalServerName = logicalServerName;
    }

    public IFileValidator(IWorkspace ws) {
        this.workspace = ws;
    }

    public String getFileType(String path) {
        if (this.getWorkspace() != null) {
            String fileType = IFileServiceAdapterSupport.getFileType(this.workspace, null, null, path);
            if (fileType == null && RemoteFileModelsUtil.isAFolder(this.workspace, path)) {
                fileType = "Folder";
            }
            return fileType;
        }
        return null;
    }

    public boolean isFileExisiting(String path) {
        if (this.getWorkspace() != null) {
            return DataSourceUtil.isExistingFile(this.workspace, path);
        }
        return false;
    }

    private IWorkspace getWorkspace() {
        if (this.workspace != null) {
            return this.workspace;
        }
        if (this.attemptedWorkspaceFetch) {
            return this.workspace;
        }
        if (this.workspace == null) {
            this.attemptedWorkspaceFetch = true;
            if (this.logicalServerName != null && this.dataProvider != null) {
                try {
                    this.workspace = this.dataProvider.getIWorkspace(this.logicalServerName);
                }
                catch (ServerConnectionException e) {
                    IllegalStateException ex = new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"errorGettingServer.ex.txt"));
                    ex.initCause(e);
                    throw ex;
                }
            } else {
                throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"errorGettingServer.ex.txt"));
            }
        }
        if (this.workspace == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"nullWorkspace.ex.txt"));
        }
        return this.workspace;
    }
}

