/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.metadata.IntelligentQueryMetadataService;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.models.SASLibraryLocation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.iquery.InformationMapMetaData;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.List;

@SASScope
public abstract class DataSourceUtil {
    public static long getDataSourceType(UserContextInterface userContext, String path) throws ServiceException, RemoteException, IllegalArgumentException {
        DataSourceInterface ds = DataSourceUtil.getDataSource(userContext, path);
        if (ds != null) {
            return ds.getDataSourceType();
        }
        return -1L;
    }

    public static DataSourceInterface getDataSource(UserContextInterface userContext, String path) throws ServiceException, RemoteException, IllegalArgumentException {
        if (null != userContext && path != null) {
            MetadataInterface mi;
            ServerInterface server = userContext.getAuthServer();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
            }
            if (pathUrl != null && (mi = server.getObjectByPath(pathUrl)) != null) {
                long type = DataSourceUtil.getDataSourceType(userContext, mi);
                if (pathUrl.getType() == null) {
                    if (!pathUrl.isWritable()) {
                        pathUrl = new PathUrl(pathUrl.toString());
                    }
                    if (type == 2L) {
                        pathUrl.setType("Cube");
                    } else if (type == 1L) {
                        pathUrl.setType("Table");
                    } else if (type == 8L) {
                        pathUrl.setType("InformationMap");
                    } else if (type == 4L) {
                        pathUrl.setType("InformationMap");
                    }
                }
                BaseDataSource ds = new BaseDataSource(type, pathUrl.getAbsolutePath());
                return ds;
            }
        }
        return null;
    }

    public static long getDataSourceType(UserContextInterface userContext, MetadataInterface mi) throws ServiceException, RemoteException {
        String type = mi.getType();
        if ("InformationMap".equals(type)) {
            InformationMapMetaData metaData;
            if (userContext != null && (metaData = IQUeryUtil.getInfoMapMetaData((String)mi.getEntityKey(), (long)mi.getModifyDate().getTime(), (ServerInterface)userContext.getAuthServer())) != null && metaData.isOLAP()) {
                return 8L;
            }
            return 4L;
        }
        if ("InformationMap.Relational".equals(type)) {
            return 4L;
        }
        if ("InformationMap.OLAP".equals(type)) {
            return 8L;
        }
        if ("Table".equals(type) || "PhysicalTable".equals(type)) {
            return 1L;
        }
        if ("Cube".equals(type)) {
            return 2L;
        }
        return -1L;
    }

    public static long getColumnType(UserContextInterface userContext, PromptDataProviderInterface pdp, DataSourceInterface ds, String column) throws ServiceException, RemoteException, IllegalArgumentException, ServerConnectionException, MetadataException {
        block14: {
            ServerInterface server;
            if (ds == null || column == null || null == userContext || (server = userContext.getAuthServer()) == null) break block14;
            String location = ds.getDataSourceLocation();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(location));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)location);
            }
            if (pathUrl != null) {
                MetadataInterface mi;
                if (pathUrl.getType() == null) {
                    pathUrl.setType("");
                }
                if ((mi = server.getObjectByPath(pathUrl)) instanceof DataTableInterface) {
                    List cols = ((DataTableInterface)mi).getColumns();
                    for (ColumnInterface c : cols) {
                        ColumnAttributes ca;
                        if (!Strings.equal((String)column, (String)c.getName(), (boolean)false, (boolean)false) || (ca = c.getColumnAttributes()) == null) continue;
                        return ca.getColumnType();
                    }
                } else if (mi instanceof BriefInformationMap) {
                    InformationMap im = null;
                    if (pdp != null) {
                        im = pdp.getInformationMap(location);
                    } else {
                        IntelligentQueryMetadataService queryService = (IntelligentQueryMetadataService)IntelligentQueryMetadataServiceFactory.newService();
                        SessionContextInterface sessionContext = userContext.getSessionContext();
                        im = queryService.getInformationMap(sessionContext, pathUrl);
                    }
                    if (im != null) {
                        List diList = im.getObjects(true, DataItem.class);
                        for (DataItem di : diList) {
                            try {
                                if (!di.getID().equals(column) && !di.getLabel().equals(column)) continue;
                                return InfoMapItemsValueProvider.getDataSourceColumnType((DataItem)di);
                            }
                            catch (InvalidIDException invalidIDException) {
                            }
                        }
                    }
                }
            }
        }
        return -1L;
    }

    public static String getLibref(UserContextInterface userContext, String path) throws ServiceException, RemoteException, IllegalArgumentException {
        SASLibraryLocationInterface sl = DataSourceUtil.getSASLibrary(userContext, path);
        if (sl != null) {
            return sl.getLibref();
        }
        return null;
    }

    public static SASLibraryLocationInterface getSASLibrary(UserContextInterface userContext, String path) throws ServiceException, RemoteException, IllegalArgumentException {
        if (path != null && null != userContext) {
            ServerInterface server = userContext.getAuthServer();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
            }
            if (pathUrl != null) {
                MetadataInterface mi;
                if (pathUrl.getType() == null) {
                    if (!pathUrl.isWritable()) {
                        pathUrl = new PathUrl(pathUrl.toString());
                    }
                    pathUrl.setType("SASLibrary");
                }
                if (server != null && (mi = server.getObjectByPath(pathUrl)) instanceof SASLibraryInterface) {
                    return new SASLibraryLocation(pathUrl.getAbsolutePath(), ((SASLibraryInterface)mi).getLibref());
                }
            }
        }
        return null;
    }

    public static boolean isExistingFile(IWorkspace workspace, String fileNameWithPath) {
        if (workspace != null) {
            return IFileServiceAdapterSupport.verifyExistenceOfFile(workspace, fileNameWithPath, "");
        }
        return false;
    }

    public static boolean isDataSourceTypeAllowed(long dataSourceType, long allowedDataSources) {
        if (allowedDataSources == -1L) {
            return true;
        }
        return (allowedDataSources & dataSourceType) == dataSourceType;
    }
}

