/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.visuals.Resources;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

@SASScope
class DataSourceRenderer
extends DefaultListCellRenderer {
    private Icon mapImage = Resources.getImageIcon((String)"InformationMapRelational.gif", (int)16);
    private Icon tableImage = Resources.getImageIcon((String)"Table_metadata.gif", (int)16);
    private Icon olapMapImage = Resources.getImageIcon((String)"InformationMapOLAP.gif", (int)16);
    private Icon cubeImage = Resources.getImageIcon((String)"Cube.gif", (int)16);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setIcon(null);
        if (value instanceof DataSourceInterface) {
            DataSourceInterface ds = (DataSourceInterface)value;
            this.setText(ds.getDataSourceLocation());
            if (ds.getDataSourceType() == 4L) {
                this.setIcon(this.mapImage);
            } else if (ds.getDataSourceType() == 1L) {
                this.setIcon(this.tableImage);
            } else if (ds.getDataSourceType() == 8L) {
                this.setIcon(this.olapMapImage);
            } else if (ds.getDataSourceType() == 2L) {
                this.setIcon(this.cubeImage);
            }
        }
        return comp;
    }
}

