/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.ISUtility;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.visuals.BaseRemoteObjectPicker;
import com.sas.swing.visuals.DataSourceRenderer;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;

@SASScope
public class DataSourcePicker
extends BaseRemoteObjectPicker {
    private static final long serialVersionUID = -4266846382290931710L;
    public static final String RB_KEY = "DataSourcePicker.";
    private UserContextInterface userContext;
    private RemoteFileModel2Interface model;
    private long allowedDataSources;
    private DataSourceInterface dataSource;
    private InformationServicesSelectorPanel panel;
    public static final DataSourceInterface UNTITLED_RELATIONAL_INFORMATION_MAP = PromptDataProviderInterface.UNTITLED_RELATIONAL_INFORMATION_MAP;
    public static final DataSourceInterface UNTITLED_OLAP_INFORMATION_MAP = PromptDataProviderInterface.UNTITLED_OLAP_INFORMATION_MAP;

    public DataSourcePicker(UserContextInterface userContext) {
        this(userContext, -1L);
    }

    public DataSourcePicker(UserContextInterface userContext, long allowedDataSources) {
        this.init(userContext, null, allowedDataSources);
    }

    public DataSourcePicker(UserContextInterface userContext, RemoteFileModel2Interface model) {
        this(userContext, model, -1L);
    }

    public DataSourcePicker(UserContextInterface userContext, RemoteFileModel2Interface model, long allowedDataSources) {
        this.init(userContext, model, allowedDataSources);
    }

    private void init(UserContextInterface userContext, RemoteFileModel2Interface model, long allowedDataSources) {
        this.userContext = userContext;
        this.model = model;
        this.allowedDataSources = allowedDataSources;
        this.init();
    }

    @Override
    protected JComponent createLocationComponent() {
        JComponent comp = super.createLocationComponent();
        if (comp instanceof JComboBox) {
            ((JComboBox)comp).setRenderer(new DataSourceRenderer());
        }
        return comp;
    }

    @Override
    protected BaseRemoteFileSelectorPanel getRemoteFileSelectorPanel() {
        ArrayList<String> m;
        if (null == this.userContext) {
            return this.panel;
        }
        boolean showOlapMaps = false;
        boolean showRelationalMaps = false;
        LinkedHashMap<String, Object> fileTypes = new LinkedHashMap<String, Object>();
        ArrayList<String> types = new ArrayList<String>();
        String allTypesKey = RB.getStringResource((String)"allApplicableSASTypes.txt", (Locale)this.getLocale());
        fileTypes.put(allTypesKey, types);
        int count = 0;
        if (DataSourceUtil.isDataSourceTypeAllowed(2L, this.getAllowedDataSources())) {
            ++count;
            fileTypes.put(ISUtility.getLocalizedTypeName((String)"Cube", (Locale)this.getLocale()), "Cube");
            types.add("Cube");
        }
        if (DataSourceUtil.isDataSourceTypeAllowed(1L, this.getAllowedDataSources())) {
            ++count;
            fileTypes.put(ISUtility.getLocalizedTypeName((String)"Table", (Locale)this.getLocale()), "Table");
            types.add("Table");
        }
        if (DataSourceUtil.isDataSourceTypeAllowed(8L, this.getAllowedDataSources())) {
            showOlapMaps = true;
        }
        if (DataSourceUtil.isDataSourceTypeAllowed(4L, this.getAllowedDataSources())) {
            showRelationalMaps = true;
        }
        if (showOlapMaps) {
            ++count;
            m = new ArrayList<String>();
            m.add("InformationMap.OLAP");
            fileTypes.put(ISUtility.getLocalizedTypeName((String)"InformationMap", (Locale)this.getLocale()), m);
            types.add("InformationMap.OLAP");
        }
        if (showRelationalMaps) {
            ++count;
            m = new ArrayList();
            m.add("InformationMap.Relational");
            if (showOlapMaps) {
                m.add("InformationMap.OLAP");
            }
            fileTypes.put(ISUtility.getLocalizedTypeName((String)"InformationMap", (Locale)this.getLocale()), m);
            types.add("InformationMap.Relational");
        }
        if (count <= 1) {
            fileTypes.remove(allTypesKey);
        }
        if (this.panel == null) {
            String startDir = "";
            DataSourceInterface dsi = (DataSourceInterface)this.getValue();
            if (dsi != null && dsi != UNTITLED_RELATIONAL_INFORMATION_MAP && dsi != UNTITLED_OLAP_INFORMATION_MAP) {
                startDir = dsi.getDataSourceLocation();
            }
            if (startDir != null && startDir.length() > 0) {
                int index;
                try {
                    try {
                        startDir = PathUrl.newPathUrlFromExistingUrl((ServerInterface)this.userContext.getAuthServer(), (PathUrl)new PathUrl(startDir)).toString();
                    }
                    catch (IllegalArgumentException ex) {
                        startDir = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.userContext.getAuthServer(), (String)startDir).toString();
                    }
                }
                catch (ServiceException e) {
                    startDir = null;
                }
                catch (RemoteException e) {
                    startDir = null;
                }
                if (startDir != null && (index = startDir.lastIndexOf("/")) != -1) {
                    startDir = startDir.substring(0, index) + "(Folder)";
                }
            }
            try {
                if (this.model == null) {
                    this.panel = new InformationServicesSelectorPanel(startDir, this.userContext.getAuthServer(), fileTypes, false);
                } else {
                    this.panel = new InformationServicesSelectorPanel(startDir, this.userContext.getAuthServer(), fileTypes, false);
                    this.panel.removeAll();
                    this.panel.initialize(startDir, this.model, this.panel.getActionSupportType(), fileTypes, this.panel.getViewComponent().getColumnRenderers());
                }
            }
            catch (ServiceException e) {
                this.handleError((Object)e);
            }
            catch (RemoteException e) {
                this.handleError(e);
            }
            this.panel.setShowSystemFolders(false);
            this.panel.setSelectionMode(InformationServicesSelectorPanel.FILES_ONLY);
            this.panel.setMultiSelectionEnabled(false);
        }
        return this.panel;
    }

    @Override
    protected String getRemoteObjectSelectorTitle() {
        return RB.getStringResource((String)RB_KEY, (String)"title.txt", (Locale)this.getLocale());
    }

    @Override
    protected boolean isInitialValueAllowed(Object value) {
        if (value instanceof DataSourceInterface) {
            return DataSourceUtil.isDataSourceTypeAllowed(((DataSourceInterface)value).getDataSourceType(), this.getAllowedDataSources());
        }
        return false;
    }

    @Override
    public Object getValue() {
        if (this.dataSource != null && Strings.equal((String)this.dataSource.getDataSourceLocation(), (String)this.getText(), (boolean)true, (boolean)false)) {
            return this.dataSource;
        }
        this.setValue(this.getText());
        return this.dataSource;
    }

    private void setValueText() {
        if (this.dataSource != null) {
            this.setText(this.dataSource.getDataSourceLocation());
        } else {
            this.setText(null);
        }
    }

    @Override
    public void setValue(Object anObject) {
        if (!Util.equal((Object)anObject, (Object)this.dataSource)) {
            boolean change = false;
            if (anObject != null) {
                try {
                    if (anObject instanceof DataSourceInterface) {
                        if (DataSourceUtil.isDataSourceTypeAllowed(((DataSourceInterface)anObject).getDataSourceType(), this.getAllowedDataSources())) {
                            this.dataSource = anObject == UNTITLED_RELATIONAL_INFORMATION_MAP || anObject == UNTITLED_OLAP_INFORMATION_MAP ? (DataSourceInterface)anObject : DataSourceUtil.getDataSource(this.userContext, ((DataSourceInterface)anObject).getDataSourceLocation());
                            change = true;
                        } else {
                            this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"illegalType.ex.fmt.txt", (Locale)this.getLocale()), (Object)((DataSourceInterface)anObject).getDataSourceLocation()));
                        }
                    } else {
                        String path = anObject.toString().trim();
                        if (path.length() > 0) {
                            DataSourceInterface ds = DataSourceUtil.getDataSource(this.userContext, path);
                            if (ds != null) {
                                if (DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), this.getAllowedDataSources())) {
                                    this.dataSource = ds;
                                    change = true;
                                } else {
                                    this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"illegalType.ex.fmt.txt", (Locale)this.getLocale()), (Object)path));
                                }
                            } else {
                                this.handleError(new Message(Strings.padSingleQuotesForMessage((String)RB.getStringResource((String)RB_KEY, (String)"invalidPath.ex.txt", (Locale)this.getLocale()))));
                            }
                        } else if (this.dataSource != null) {
                            this.dataSource = null;
                            change = true;
                        }
                    }
                }
                catch (ServiceException ex) {
                    this.handleError((Object)ex);
                }
                catch (RemoteException ex) {
                    this.handleError(ex);
                }
                catch (IllegalArgumentException ex) {
                    this.handleError(ex);
                }
            } else if (this.dataSource != null) {
                this.dataSource = null;
                change = true;
            }
            this.setValueText();
            if (change) {
                this.fireValueChanged();
            }
        }
    }

    public long getAllowedDataSources() {
        return this.allowedDataSources;
    }

    public void setAllowedDataSources(long allowedDataSources) {
        if (this.allowedDataSources != allowedDataSources) {
            long oldValue = this.allowedDataSources;
            this.allowedDataSources = allowedDataSources;
            this.removeListeners();
            this.removeAll();
            this.createUI();
            this.revalidate();
            this.panel = null;
            this.firePropertyChange("allowedDataSources", oldValue, this.allowedDataSources);
        }
    }
}

