/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataSourceColumnType;
import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.BasePromptDynamicValueProvider;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.UserContextEnabledObject;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.MutableFileFilterInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadata;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.DataSourceRenderer;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.ValuePickerRendererHandler;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentInterface;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.SortHeaderRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.Util;
import com.sas.table.MutableTableColumnsInterface;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.text.Message;
import com.sas.util.ListFactory;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

@SASScope
public class DataSourceColumnPicker
extends JComponent
implements EditorInterface,
EditorListener,
ActionListener {
    private static final long serialVersionUID = -4266846382290931710L;
    public static final int SINGLE_SELECTION = 300;
    public static final int MULTIPLE_SELECTION = 301;
    public static final int ORDERED_MULTIPLE_SELECTION = 302;
    private static final String DATA_SOURCE_COLUMN = "DATA_SOURCE_COLUMN";
    public static final String RB_KEY = "DataSourceColumnPicker.";
    private ValueListEditor listEditor;
    private ValuePicker mainValuePicker;
    private ValueProviderAdapter mainVPAdapter;
    private JButton browseButton;
    private DataProviderInterface dataProvider;
    private UserContextInterface userContext;
    private long allowedDataSources;
    private long allowedColumnTypes;
    private int selectionType;
    private boolean allowMultipleDataSources;
    private List dataSources;
    private int maxColumns;
    private ValueProviderAdapter vpAdapter;
    private ValueProviderInterface infoMapItemsValueProvider;
    private ValueProviderInterface columnNameValueProvider;
    private ValuePicker valuePicker;
    private ComboBox dataSourceCombo;
    private Map vpMap;
    private boolean errorMode;
    private boolean browsing;
    private PropertyChangeListener propertyListener;
    private RemoteFileComponentInterface viewComp;
    private InformationServicesSelectorPanel panel;
    private OptionsDialog dialog = null;
    protected PropertyChangeListener focusListener;
    private boolean isEditing;
    private boolean valueModified;
    private DataSourceColumnRendererHandler rendererHandler;
    private boolean ignoreEvents;
    private GenericErrorHandlerInterface errorHandler;
    private ChangeCursorCommand changeCursorCommand;
    private EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    private LoggerFactoryInterface logFactory;

    public DataSourceColumnPicker(UserContextInterface userContext) {
        this(userContext, 5L, -1L);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, long allowedDataSources, long allowedColumnTypes) {
        this.init(userContext, null, allowedDataSources, allowedColumnTypes);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, List dataSources) {
        this(userContext, dataSources, -1L);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, List dataSources, long allowedColumnTypes) {
        this.dataSources = dataSources;
        this.init(userContext, null, -1L, allowedColumnTypes);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, DataProviderInterface dataProvider) {
        this(userContext, dataProvider, 5L, -1L);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, DataProviderInterface dataProvider, long allowedDataSources, long allowedColumnTypes) {
        this.init(userContext, dataProvider, allowedDataSources, allowedColumnTypes);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, DataProviderInterface dataProvider, List dataSources) {
        this(userContext, dataProvider, dataSources, -1L);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, DataProviderInterface dataProvider, List dataSources, long allowedColumnTypes) {
        this.dataSources = dataSources;
        this.init(userContext, dataProvider, -1L, allowedColumnTypes);
    }

    private void init(UserContextInterface userContext, DataProviderInterface dataProvider, long allowedDataSources, long allowedColumnTypes) {
        this.userContext = userContext;
        this.dataProvider = dataProvider;
        if (this.userContext == null && dataProvider instanceof UserContextEnabledObject) {
            this.userContext = ((UserContextEnabledObject)dataProvider).getUserContext();
        }
        this.maxColumns = -1;
        this.allowedDataSources = allowedDataSources;
        this.allowedColumnTypes = allowedColumnTypes;
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.vpMap = new LinkedHashMap();
        this.allowMultipleDataSources = false;
        this.vpAdapter = new ValueProviderAdapter();
        this.selectionType = 300;
        this.rendererHandler = new DataSourceColumnRendererHandler();
        if (userContext != null) {
            try {
                this.logFactory = new ServicesLogFactory(userContext.getSessionContext());
            }
            catch (RemoteException ex) {
                this.logFactory = new ServicesLogFactory();
            }
        }
        this.errorHandler = new JOptionPaneErrorHandler((Component)this);
        this.isEditing = false;
        this.focusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Window currentWindow;
                Component comp;
                String propName = evt.getPropertyName();
                if (propName.equals("focusOwner") && (comp = FocusManager.getCurrentManager().getFocusOwner()) != null && (currentWindow = SwingUtilities.windowForComponent(DataSourceColumnPicker.this)) != null) {
                    boolean owner;
                    boolean bl = owner = SwingUtilities.isDescendingFrom(comp, DataSourceColumnPicker.this) || DataSourceColumnPicker.this.dialog != null && SwingUtilities.isDescendingFrom(comp, (Component)DataSourceColumnPicker.this.dialog);
                    if (owner) {
                        if (!DataSourceColumnPicker.this.isEditing) {
                            DataSourceColumnPicker.this.isEditing = true;
                            DataSourceColumnPicker.this.fireEditingStarted();
                        }
                    } else if (DataSourceColumnPicker.this.isEditing && currentWindow == SwingUtilities.getWindowAncestor(comp)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataSourceColumnPicker.this.isEditing = false;
                                DataSourceColumnPicker.this.valueModified = false;
                                DataSourceColumnPicker.this.fireEditingStopped();
                            }
                        });
                    }
                }
            }
        };
        this.propertyListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RemoteFileMetadataInterface file;
                List items;
                String propName = evt.getPropertyName();
                if (propName.equals("viewType")) {
                    if (DataSourceColumnPicker.this.viewComp != null) {
                        DataSourceColumnPicker.this.viewComp.removePropertyChangeListener(DataSourceColumnPicker.this.propertyListener);
                    }
                    DataSourceColumnPicker.this.viewComp = DataSourceColumnPicker.this.panel.getViewComponent();
                    DataSourceColumnPicker.this.panel.getViewComponent().addPropertyChangeListener(DataSourceColumnPicker.this.propertyListener);
                } else if (propName.equals("selections") && DataSourceColumnPicker.this.panel != null && (items = DataSourceColumnPicker.this.panel.getSelectedItemObjects()) != null && items.size() > 0 && !(file = (RemoteFileMetadataInterface)items.get(0)).isFolder() && file instanceof InformationServicesFileMetadata) {
                    try {
                        String type = ((InformationServicesFileMetadata)file).getSmartType();
                        if (type != null) {
                            DataSourceColumnPicker.this.valuePicker.setEnabled(false);
                            DataSourceInterface ds = (DataSourceInterface)DataSourceType.DEFAULT_INSTANCE.coerceValue((Object)file.getLocation(), DataSourceColumnPicker.this.getLocale());
                            if ("InformationMap".equals(type) || "InformationMap.Relational".equals(type)) {
                                ((BaseDataSource)ds).setDataSourceType(4L);
                            } else if ("PhysicalTable".equals(type) || "Table".equals(type)) {
                                ((BaseDataSource)ds).setDataSourceType(1L);
                            }
                            DataSourceColumnPicker.this.updateValueProvider(DataSourceColumnPicker.this.valuePicker, DataSourceColumnPicker.this.vpAdapter, ds);
                            DataSourceColumnPicker.this.setColumnsOnVP();
                        }
                    }
                    finally {
                        DataSourceColumnPicker.this.valuePicker.setEnabled(true);
                    }
                }
            }
        };
        this.createUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.listEditor != null) {
            this.listEditor.setEnabled(enabled);
        }
        if (this.mainValuePicker != null) {
            this.mainValuePicker.setEnabled(enabled);
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(enabled && !this.errorMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueProvider(ValuePicker picker, ValueProviderAdapter adapter, DataSourceInterface dataSource) {
        try {
            Window comp = SwingUtilities.getWindowAncestor((Component)picker);
            if (comp != null) {
                this.changeCursorCommand.apply((Object)comp);
            }
            if (picker != null) {
                this.changeCursorCommand.apply((Object)picker);
            }
            if (this.panel != null) {
                this.changeCursorCommand.apply((Object)this.panel);
                if (this.panel.getViewComponent() != null) {
                    this.changeCursorCommand.apply((Object)this.panel.getViewComponent());
                }
            }
            boolean reloadNeeded = false;
            ValueProviderInterface vp = null;
            if (dataSource != null) {
                if (dataSource.getDataSourceType() == 1L) {
                    this.infoMapItemsValueProvider = null;
                    if (this.columnNameValueProvider == null) {
                        this.columnNameValueProvider = new ColumnNamesValueProvider(dataSource.getDataSourceLocation());
                        ((BasePromptDynamicValueProvider)this.columnNameValueProvider).setDataProvider(this.getDataProvider());
                    } else if (!Strings.equal((String)dataSource.getDataSourceLocation(), (String)((ColumnNamesValueProvider)this.columnNameValueProvider).getSbipUrl(), (boolean)true, (boolean)false)) {
                        ((ColumnNamesValueProvider)this.columnNameValueProvider).setSbipUrl(dataSource.getDataSourceLocation());
                        reloadNeeded = true;
                    }
                    vp = this.columnNameValueProvider;
                } else if (dataSource.getDataSourceType() == 4L) {
                    this.columnNameValueProvider = null;
                    if (this.infoMapItemsValueProvider == null) {
                        this.infoMapItemsValueProvider = new InfoMapItemsValueProvider();
                        ((InfoMapItemsValueProvider)this.infoMapItemsValueProvider).setIsOLAP(false);
                        ((InfoMapItemsValueProvider)this.infoMapItemsValueProvider).setInfoMapUrl(dataSource.getDataSourceLocation());
                        ((BasePromptDynamicValueProvider)this.infoMapItemsValueProvider).setDataProvider(this.getDataProvider());
                    } else if (!Strings.equal((String)dataSource.getDataSourceLocation(), (String)((InfoMapItemsValueProvider)this.infoMapItemsValueProvider).getInfoMapUrl(), (boolean)true, (boolean)false)) {
                        ((InfoMapItemsValueProvider)this.infoMapItemsValueProvider).setInfoMapUrl(dataSource.getDataSourceLocation());
                        reloadNeeded = true;
                    }
                    vp = this.infoMapItemsValueProvider;
                }
            } else {
                vp = null;
            }
            if (adapter.setValueProvider(vp) || reloadNeeded) {
                picker.reloadValues();
                this.setSortingOnValuePicker(picker);
                if (!this.allowMultipleDataSources) {
                    List items = picker.getSelectedItems();
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        DataSourceColumnInterface dsc = null;
                        if (o instanceof ValueItem && ((ValueItem)o).getValue() instanceof DataSourceColumnInterface) {
                            dsc = (DataSourceColumnInterface)((ValueItem)o).getValue();
                        } else if (o instanceof DataSourceColumnInterface) {
                            dsc = (DataSourceColumnInterface)o;
                        }
                        if (dsc != null && com.sas.util.Util.equal((Object)dsc.getDataSource(), (Object)dataSource)) continue;
                        iter.remove();
                    }
                    picker.setValue((Object)items);
                }
                picker.revalidate();
                picker.repaint();
            }
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueProvider(ValuePicker picker, ValueProviderAdapter adapter, Map map) {
        try {
            Window comp = SwingUtilities.getWindowAncestor((Component)picker);
            if (comp != null) {
                this.changeCursorCommand.apply((Object)comp);
            }
            ArrayList<Object> providers = new ArrayList<Object>();
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                DataSourceInterface dataSource = (DataSourceInterface)entry.getKey();
                if (entry.getValue() == null) {
                    ColumnNamesValueProvider valueProvider = null;
                    if (dataSource.getDataSourceType() == 1L) {
                        ColumnNamesValueProvider columnNameValueProvider = new ColumnNamesValueProvider(dataSource.getDataSourceLocation());
                        columnNameValueProvider.setDataProvider(this.getDataProvider());
                        valueProvider = columnNameValueProvider;
                    } else if (dataSource.getDataSourceType() == 4L) {
                        this.infoMapItemsValueProvider = new InfoMapItemsValueProvider();
                        ((InfoMapItemsValueProvider)this.infoMapItemsValueProvider).setIsOLAP(false);
                        ((InfoMapItemsValueProvider)this.infoMapItemsValueProvider).setInfoMapUrl(dataSource.getDataSourceLocation());
                        ((BasePromptDynamicValueProvider)this.infoMapItemsValueProvider).setDataProvider(this.getDataProvider());
                        valueProvider = this.infoMapItemsValueProvider;
                    }
                    map.put(dataSource, valueProvider);
                    providers.add(valueProvider);
                    continue;
                }
                providers.add(entry.getValue());
            }
            if (adapter.setValueProviders(providers)) {
                picker.reloadValues();
                this.setSortingOnValuePicker(picker);
            }
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
    }

    private void setSortingOnValuePicker(ValuePicker picker) {
        Object table;
        if (picker != null && (table = picker.getBrowseComponent()) instanceof TableView) {
            TableView tv = (TableView)table;
            if (!(tv.getModel() instanceof SortableTableModelAdapter)) {
                TableModel tm = tv.getModel();
                SortableTableModelAdapter sortAdapter = new SortableTableModelAdapter(tm);
                tv.setModel((TableModel)sortAdapter);
            }
            if (!tv.isPopupMenuEnabled()) {
                tv.setPopupMenuEnabled(true);
                SwingActionProvider actionProvider = tv.getActionProvider();
                ActionOrderList columnHeaderAOL = new ActionOrderList("ROOT_NAME", 3);
                columnHeaderAOL.add((Object)"SORT_COLUMN_ASCENDING_ACTION");
                columnHeaderAOL.add((Object)"SORT_COLUMN_DESCENDING_ACTION");
                columnHeaderAOL.add((Object)"CLEAR_SORT_ACTION");
                columnHeaderAOL.setEnabledIfEmpty(false);
                actionProvider.setActionOrderList("TABLEVIEW_SUPPORT", columnHeaderAOL, (ActionProviderViewInterface)tv, "COLUMN_HEADER_AREA");
                ActionOrderList cellAOL = new ActionOrderList("ROOT_NAME", 3);
                cellAOL.add((Object)"SORT_COLUMN_ASCENDING_ACTION");
                cellAOL.add((Object)"SORT_COLUMN_DESCENDING_ACTION");
                cellAOL.add((Object)"CLEAR_SORT_ACTION");
                cellAOL.setEnabledIfEmpty(false);
                actionProvider.setActionOrderList("TABLEVIEW_SUPPORT", cellAOL, (ActionProviderViewInterface)tv, "DATA_CELL_AREA");
                BaseAction clearSortAction = actionProvider.getDefaultAction("TABLEVIEW_SUPPORT", "COLUMN_HEADER_AREA", "CLEAR_SORT_ACTION");
                clearSortAction.putValue("Name", (Object)RB.getStringResource((String)RB_KEY, (String)"clearSort.txt", (Locale)this.getLocale()));
                clearSortAction = actionProvider.getDefaultAction("TABLEVIEW_SUPPORT", "DATA_CELL_AREA", "CLEAR_SORT_ACTION");
                clearSortAction.putValue("Name", (Object)RB.getStringResource((String)RB_KEY, (String)"clearSort.txt", (Locale)this.getLocale()));
                TableViewHeaderSort mouseAdapter = new TableViewHeaderSort(tv);
                tv.getColumnHeader().addMouseMotionListener((MouseMotionListener)mouseAdapter);
                tv.getColumnHeader().addMouseListener((MouseListener)mouseAdapter);
            }
            tv.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new NoBorderTableHeaderRenderer()));
        }
    }

    private void createUI() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 0, 5, 5, true, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        layout.setRemainderColumn(1);
        this.setLayout((LayoutManager)layout);
        if (null != this.mainValuePicker) {
            this.mainValuePicker.removeEditorListener((EditorListener)this);
            this.mainValuePicker.removeListeners();
            this.mainValuePicker = null;
        }
        if (null != this.listEditor) {
            this.listEditor.removeEditorListener((EditorListener)this);
            this.listEditor.removeListeners();
            this.listEditor = null;
        }
        if (this.selectionType == 300) {
            if (this.mainVPAdapter == null) {
                this.mainVPAdapter = new ValueProviderAdapter();
            }
            ViewQueryCacheInterface queryCache = this.getDataProvider() instanceof ViewQueryCacheInterface ? (ViewQueryCacheInterface)this.getDataProvider() : null;
            this.mainValuePicker = new ValuePicker((ValueProviderInterface)this.mainVPAdapter, 400, 303, false, null, null, -1, queryCache, this.getLocale());
            this.mainValuePicker.setRendererHandler((ValuePickerRendererHandler)this.rendererHandler);
            this.mainValuePicker.setMaxValues(this.getMaxColumns());
            this.browseButton = new JButton(RB.getStringResource((String)"browse.txt", (Locale)this.getLocale()));
            this.add((Component)this.mainValuePicker);
            this.add(this.browseButton);
        } else {
            this.listEditor = this.createListEditor();
            if (this.getSelectionMode() != 302) {
                this.listEditor.setReorderingAllowed(false);
            }
            this.listEditor.removeButton(ValueListEditor.BUTTON_EDIT);
            AbstractButton addButton = (AbstractButton)this.listEditor.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_ADD, 3);
            addButton.setAction(new SelectColumnAction());
            this.listEditor.addButton(ItemListManagerViewerInterface.BUTTON_ADD, 0, 0);
            this.listEditor.setMaxItems(this.getMaxColumns());
            this.add((Component)this.listEditor);
        }
        this.addListeners();
    }

    public void addListeners() {
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", this.focusListener);
        if (this.listEditor != null) {
            this.listEditor.addEditorListener((EditorListener)this);
        }
        if (this.mainValuePicker != null) {
            this.mainValuePicker.addEditorListener((EditorListener)this);
        }
        if (this.browseButton != null) {
            this.browseButton.addActionListener(this);
        }
    }

    public void removeListeners() {
        FocusManager.getCurrentManager().removePropertyChangeListener("focusOwner", this.focusListener);
        if (this.listEditor != null) {
            this.listEditor.removeEditorListener((EditorListener)this);
            this.listEditor.removeListeners();
        }
        if (this.mainValuePicker != null) {
            this.mainValuePicker.removeEditorListener((EditorListener)this);
            this.mainValuePicker.removeListeners();
        }
        if (this.browseButton != null) {
            this.browseButton.removeActionListener(this);
        }
    }

    protected ValueListEditor createListEditor() {
        ValueListEditor vle = new ValueListEditor(null){

            protected void updateAddButtonState() {
                this.addButton.setEnabled(true);
            }
        };
        DataSourceColumnRenderer renderer = new DataSourceColumnRenderer(this.rendererHandler);
        vle.getTable().setCellRenderer(-1, -1, (TableCellRenderer)((Object)renderer));
        ((DefaultTableModel)vle.getModel()).setColumnCount(2);
        ((DefaultTableModel)vle.getModel()).setColumnIdentifiers(new String[]{RB.getStringResource((String)RB_KEY, (String)"column.txt", (Locale)this.getLocale()), RB.getStringResource((String)RB_KEY, (String)"dataSource.txt", (Locale)this.getLocale())});
        vle.getTable().setColumnHeaderVisible(true);
        vle.getTable().getColumnHeader().setResizingAllowed(false);
        vle.getTable().getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new NoBorderTableHeaderRenderer()));
        vle.getTable().getTableHeader().setReorderingAllowed(false);
        return vle;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    public ValueListEditor getValueListEditor() {
        return this.listEditor;
    }

    private boolean isDataSourceTypeAllowed(long dataSourceType) {
        if (dataSourceType == 8L || dataSourceType == 2L) {
            return false;
        }
        if (this.allowedDataSources == -1L) {
            return true;
        }
        return (this.allowedDataSources & dataSourceType) == dataSourceType;
    }

    private boolean isColumnTypeAllowed(long columnType) {
        if (this.allowedColumnTypes == -1L) {
            return true;
        }
        return (this.allowedColumnTypes & columnType) == columnType;
    }

    protected void handleError(Exception ex) {
        LoggerRepository2.getLogger((String)DataSourceColumnPicker.class.getPackage().getName(), (LoggerFactoryInterface)this.logFactory).error(ex.getMessage(), (Throwable)ex);
        if (this.getErrorHandler() != null) {
            this.getErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)ex.getMessage())), null);
        }
    }

    public Component getEditorComponent() {
        return this;
    }

    public Object getValue() {
        List values = null;
        values = this.getSelectionMode() == 300 ? this.mainValuePicker.getSelectedItems() : (List)this.listEditor.getValue();
        if (this.getSelectionMode() == 300) {
            if (values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object anObject) {
        try {
            this.ignoreEvents = true;
            if (anObject != null) {
                if (anObject instanceof List) {
                    if (this.listEditor != null) {
                        ((DefaultTableModel)this.listEditor.getModel()).setRowCount(0);
                        Iterator iter = ((List)anObject).iterator();
                        while (iter.hasNext()) {
                            this.addRow(iter.next());
                        }
                    } else {
                        if (this.dataSources == null || this.dataSources.isEmpty()) {
                            StaticValueProvider vp = new StaticValueProvider();
                            ArrayList values = new ArrayList();
                            List newValues = (List)anObject;
                            for (Object column : newValues) {
                                if (column instanceof ValueItem) {
                                    values.add(column);
                                    continue;
                                }
                                if (!(column instanceof DataSourceColumnInterface)) continue;
                                values.add(new ValueItem((Object)((DataSourceColumnInterface)column).getColumnLabel(), column));
                            }
                            vp.setValues(values, this.getLocale());
                            this.mainVPAdapter.setValueProvider((ValueProviderInterface)vp);
                            this.mainValuePicker.reloadValues();
                        }
                        this.mainValuePicker.setValue(anObject);
                    }
                } else if (anObject != null) {
                    if (this.listEditor != null) {
                        ((DefaultTableModel)this.listEditor.getModel()).setRowCount(0);
                        this.addRow(anObject);
                    } else {
                        if (this.dataSources == null || this.dataSources.isEmpty()) {
                            StaticValueProvider vp = new StaticValueProvider();
                            ArrayList<Object> values = new ArrayList<Object>();
                            if (anObject instanceof DataSourceColumnInterface) {
                                values.add(new ValueItem((Object)((DataSourceColumnInterface)anObject).getColumnLabel(), anObject));
                            } else if (anObject instanceof ValueItem) {
                                values.add(anObject);
                            }
                            vp.setValues(values, this.getLocale());
                            this.mainVPAdapter.setValueProvider((ValueProviderInterface)vp);
                            this.mainValuePicker.reloadValues();
                        }
                        this.mainValuePicker.setValue(anObject);
                    }
                }
            } else if (this.listEditor != null) {
                this.listEditor.setValue(null);
            } else {
                this.mainValuePicker.setValue(null);
            }
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private void addRow(Object value) {
        DefaultTableModel tm = (DefaultTableModel)this.listEditor.getModel();
        if (value instanceof ValueItem) {
            ValueItem vi = (ValueItem)value;
            if (vi.getValue() instanceof DataSourceColumnInterface) {
                DataSourceColumnInterface dsc = (DataSourceColumnInterface)vi.getValue();
                tm.addRow(new Object[]{dsc, this.getNameForLocation(dsc.getDataSource().getDataSourceLocation())});
            }
        } else if (value instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface dsc = (DataSourceColumnInterface)value;
            tm.addRow(new Object[]{dsc, this.getNameForLocation(dsc.getDataSource().getDataSourceLocation())});
        }
    }

    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
        this.valueModified = false;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void requestFocus() {
        this.listEditor.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return this.listEditor.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.listEditor.requestFocusInWindow();
    }

    public GenericErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("errorHandler", oldValue, this.errorHandler);
        }
    }

    public long getAllowedDataSources() {
        return this.allowedDataSources;
    }

    public void setAllowedDataSources(long allowedDataSources) {
        if (this.allowedDataSources != allowedDataSources) {
            if (allowedDataSources != -1L && ((allowedDataSources & 2L) == 2L || (allowedDataSources & 8L) == 8L)) {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"illegalDataSourceType.ex.txt", (Locale)this.getLocale()));
            }
            long oldValue = this.allowedDataSources;
            this.allowedDataSources = allowedDataSources;
            this.panel = null;
            if (this.valuePicker != null) {
                this.valuePicker.reloadValues();
            }
            this.updateList();
            this.firePropertyChange("allowedDataSources", oldValue, this.allowedDataSources);
        }
    }

    public long getAllowedColumnTypes() {
        return this.allowedColumnTypes;
    }

    public void setAllowedColumnTypes(long allowedColumnTypes) {
        if (this.allowedColumnTypes != allowedColumnTypes) {
            long oldValue = this.allowedColumnTypes;
            this.allowedColumnTypes = allowedColumnTypes;
            if (this.valuePicker != null) {
                this.valuePicker.reloadValues();
            }
            if (this.mainValuePicker != null) {
                this.mainValuePicker.reloadValues();
            }
            this.updateList();
            this.firePropertyChange("allowedColumnTypes", oldValue, this.allowedColumnTypes);
        }
    }

    public int getSelectionMode() {
        return this.selectionType;
    }

    public void setSelectionMode(int selectionMode) {
        if (this.selectionType != selectionMode) {
            Object dataValue = this.getValue();
            int oldValue = this.selectionType;
            this.selectionType = selectionMode;
            if (!(oldValue != 301 && oldValue != 302 || this.selectionType != 301 && this.selectionType != 302)) {
                if (this.listEditor != null) {
                    this.listEditor.setReorderingAllowed(this.selectionType == 302);
                }
            } else {
                this.removeListeners();
                this.removeAll();
                this.createUI();
                this.revalidate();
                if (this.selectionType == 300 && this.dataSources != null && !this.dataSources.isEmpty()) {
                    this.updateValueProvider(this.mainValuePicker, this.mainVPAdapter, this.vpMap);
                }
                this.setValue(dataValue);
            }
            if (this.valuePicker != null) {
                this.valuePicker.setSelectionMode(selectionMode);
            }
            this.firePropertyChange("selectionMode", oldValue, this.selectionType);
        }
    }

    public List getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List dataSources) {
        if (!PromptUtil.isPromptValuesEqual((Object)this.dataSources, (Object)dataSources)) {
            List oldValue = this.dataSources;
            this.dataSources = dataSources != null ? ListFactory.newList((Collection)dataSources) : null;
            if (this.dataSources != null && !this.dataSources.isEmpty() && null != this.userContext) {
                for (DataSourceInterface dsi : dataSources) {
                    String path;
                    if (!(dsi instanceof BaseDataSource)) continue;
                    PathUrl pathUrl = null;
                    try {
                        try {
                            pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)this.userContext.getAuthServer(), (PathUrl)new PathUrl(dsi.getDataSourceLocation()));
                        }
                        catch (IllegalArgumentException e) {
                            pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.userContext.getAuthServer(), (String)dsi.getDataSourceLocation());
                        }
                    }
                    catch (ServiceException e) {
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (pathUrl == null || Strings.equal((String)(path = pathUrl.getAbsolutePath()), (String)dsi.getDataSourceLocation(), (boolean)true, (boolean)false)) continue;
                    ((BaseDataSource)dsi).setDataSourceLocation(path);
                }
            }
            this.dataSourceCombo = null;
            this.removeListeners();
            this.removeAll();
            this.createUI();
            this.revalidate();
            LinkedHashMap newMap = new LinkedHashMap();
            if (dataSources != null && !dataSources.isEmpty()) {
                for (DataSourceInterface ds : dataSources) {
                    if (this.vpMap.containsKey(ds)) {
                        newMap.put(ds, this.vpMap.get(ds));
                        continue;
                    }
                    newMap.put(ds, null);
                }
            }
            this.vpMap = newMap;
            if (this.selectionType == 300) {
                this.updateValueProvider(this.mainValuePicker, this.mainVPAdapter, this.vpMap);
            }
            this.updateList();
            this.firePropertyChange("dataSources", oldValue, this.dataSources);
        }
    }

    public boolean isAllowMultipleDataSources() {
        return this.allowMultipleDataSources;
    }

    public void setAllowMultipleDataSources(boolean allowMultipleDataSources) {
        if (this.allowMultipleDataSources != allowMultipleDataSources) {
            boolean oldValue = this.allowMultipleDataSources;
            this.allowMultipleDataSources = allowMultipleDataSources;
            this.updateList();
            this.firePropertyChange("allowMultipleDataSources", oldValue, this.allowMultipleDataSources);
        }
    }

    private DataProviderInterface getDataProvider() {
        if (this.dataProvider == null) {
            this.dataProvider = new DataProvider(this.userContext);
        }
        return this.dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList() {
        if (this.listEditor != null) {
            DefaultTableModel tm = (DefaultTableModel)this.listEditor.getModel();
            boolean update = false;
            try {
                this.ignoreEvents = true;
                block3: for (int i = tm.getRowCount(); i > 0; --i) {
                    Object value = tm.getValueAt(i - 1, 0);
                    if (!(value instanceof ValueItem)) continue;
                    if (!this.isValueItemAllowed((ValueItem)value)) {
                        tm.removeRow(i - 1);
                        update = true;
                        continue;
                    }
                    if (this.allowMultipleDataSources) continue;
                    DataSourceInterface ds = ((DataSourceColumnInterface)((ValueItem)value).getValue()).getDataSource();
                    for (int j = 0; j < i; ++j) {
                        DataSourceInterface ds2;
                        Object v = tm.getValueAt(j, 0);
                        if (!(v instanceof ValueItem) || com.sas.util.Util.equal((Object)ds, (Object)(ds2 = ((DataSourceColumnInterface)((ValueItem)v).getValue()).getDataSource()))) continue;
                        tm.removeRow(i - 1);
                        update = true;
                        continue block3;
                    }
                }
            }
            finally {
                this.ignoreEvents = false;
                if (update) {
                    this.fireValueChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectColumns() {
        ArrayList<ValueItem> selColumns = this.getValue();
        if (selColumns != null) {
            if (selColumns instanceof DataSourceColumnInterface) {
                DataSourceColumnInterface dsc = (DataSourceColumnInterface)selColumns;
                selColumns = new ValueItem((Object)dsc.getColumnLabel(), (Object)dsc);
                ((ValueItem)selColumns).setAttribute(DATA_SOURCE_COLUMN, (Object)this.getNameForLocation(dsc.getDataSource().getDataSourceLocation()));
            } else if (selColumns instanceof Collection) {
                Collection col = selColumns;
                ArrayList<ValueItem> newList = new ArrayList<ValueItem>();
                for (Object o : col) {
                    if (!(o instanceof DataSourceColumnInterface)) continue;
                    DataSourceColumnInterface dsc = (DataSourceColumnInterface)o;
                    ValueItem vi = new ValueItem((Object)dsc.getColumnLabel(), (Object)dsc);
                    vi.setAttribute(DATA_SOURCE_COLUMN, (Object)this.getNameForLocation(dsc.getDataSource().getDataSourceLocation()));
                    newList.add(vi);
                }
                selColumns = newList;
            }
        }
        final ArrayList<ValueItem> val = selColumns;
        try {
            Window comp = SwingUtilities.getWindowAncestor(this);
            if (comp != null) {
                this.changeCursorCommand.apply((Object)comp);
            }
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                LinkedHashMap fileTypes = new LinkedHashMap();
                ArrayList<String> types = new ArrayList<String>();
                String allTypesKey = RB.getStringResource((String)"allApplicableSASTypes.txt", (Locale)this.getLocale());
                fileTypes.put(allTypesKey, types);
                int count = 0;
                if (this.isDataSourceTypeAllowed(1L)) {
                    ++count;
                    types.add("Table");
                }
                if (this.isDataSourceTypeAllowed(4L)) {
                    ++count;
                    types.add("InformationMap.Relational");
                }
                if (count == 0) {
                    fileTypes.remove(allTypesKey);
                }
                String startDir = "";
                if (this.panel == null) {
                    try {
                        BaseRemoteFileModelInterface model = null;
                        if (this.getDataProvider() instanceof PromptDataProviderInterface) {
                            model = (BaseRemoteFileModelInterface)((PromptDataProviderInterface)this.getDataProvider()).getRemoteFileModel();
                        }
                        if (model == null) {
                            this.panel = new InformationServicesSelectorPanel(startDir, this.userContext.getAuthServer(), fileTypes, false);
                        } else {
                            this.panel = new InformationServicesSelectorPanel(startDir, this.userContext.getAuthServer(), fileTypes, false);
                            this.panel.removeAll();
                            this.panel.initialize(startDir, model, this.panel.getActionSupportType(), fileTypes, this.panel.getViewComponent().getColumnRenderers());
                        }
                    }
                    catch (ServiceException e) {
                        this.handleError((Exception)((Object)e));
                    }
                    catch (RemoteException e) {
                        this.handleError(e);
                    }
                    this.panel.setShowSystemFolders(false);
                    this.panel.setMultiSelectionEnabled(false);
                    this.panel.setShowFileNamePanel(false);
                    ((MutableFileFilterInterface)((Object)this.panel.getModel())).updateFilteredValues(types);
                    this.panel.getViewComponent().addPropertyChangeListener(this.propertyListener);
                    this.panel.addPropertyChangeListener("viewType", this.propertyListener);
                    this.panel.setSelectionMode(InformationServicesSelectorPanel.FILES_ONLY);
                }
            } else {
                if (this.dataSourceCombo == null) {
                    this.dataSourceCombo = new WideComboBox();
                    for (DataSourceInterface ds : this.dataSources) {
                        this.dataSourceCombo.addItem((Object)ds);
                    }
                    DataSourceRenderer rend = new DataSourceRenderer();
                    this.dataSourceCombo.setRenderer((ListCellRenderer)rend);
                }
                if (val != null) {
                    if (val instanceof DataSourceColumnInterface) {
                        this.dataSourceCombo.setSelectedItem((Object)((DataSourceColumnInterface)val).getDataSource());
                    } else if (val instanceof ValueItem && ((ValueItem)val).getValue() instanceof DataSourceColumnInterface) {
                        this.dataSourceCombo.setSelectedItem((Object)((DataSourceColumnInterface)((ValueItem)val).getValue()).getDataSource());
                    } else if (val instanceof Collection) {
                        Collection c = val;
                        for (Object o : c) {
                            if (o instanceof DataSourceColumnInterface) {
                                this.dataSourceCombo.setSelectedItem((Object)((DataSourceColumnInterface)o).getDataSource());
                                break;
                            }
                            if (!(o instanceof ValueItem) || !(((ValueItem)o).getValue() instanceof DataSourceColumnInterface)) continue;
                            this.dataSourceCombo.setSelectedItem((Object)((DataSourceColumnInterface)((ValueItem)o).getValue()).getDataSource());
                            break;
                        }
                    }
                }
                this.dataSourceCombo.addActionListener((ActionListener)this);
            }
            if (this.valuePicker == null) {
                ViewQueryCacheInterface queryCache = this.getDataProvider() instanceof ViewQueryCacheInterface ? (ViewQueryCacheInterface)this.getDataProvider() : null;
                this.valuePicker = new ValuePicker((ValueProviderInterface)this.vpAdapter, 403, this.getSelectionMode(), false, null, null, -1, queryCache, this.getLocale());
                this.valuePicker.setMaxValues(this.getMaxColumns());
                this.setColumnsOnVP();
                this.valuePicker.setRendererHandler((ValuePickerRendererHandler)this.rendererHandler);
            }
            JPanel valuePickerPanel = new JPanel();
            valuePickerPanel.setOpaque(false);
            BorderLayout valuePickerPanelLayout = new BorderLayout(5, 5);
            valuePickerPanel.setLayout(valuePickerPanelLayout);
            valuePickerPanel.add((Component)this.valuePicker, "Center");
            if (this.getSelectionMode() == 300) {
                JLabel label = new JLabel(RB.getStringResource((String)RB_KEY, (String)"selectADataSourceItem.txt", (Locale)this.getLocale()));
                valuePickerPanel.add((Component)label, "North");
            } else {
                valuePickerPanel.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"columnsTitle.txt", (Locale)this.getLocale()), (int)0, (int)5, (int)5, (int)5));
            }
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                Object unwrap;
                if (val != null && (!this.allowMultipleDataSources || this.getSelectionMode() == 300) && (unwrap = this.getFirstValueUnwrapped(val)) instanceof DataSourceColumnInterface) {
                    try {
                        int index;
                        String location = ((DataSourceColumnInterface)unwrap).getDataSource().getDataSourceLocation();
                        String dataSource = null;
                        if (location != null && (index = location.lastIndexOf(47)) != -1) {
                            dataSource = location.substring(index + 1, location.lastIndexOf(40));
                            location = location.substring(0, index) + "(Folder)";
                        }
                        this.panel.setFileSelections(new String[]{dataSource});
                        this.panel.getModel().setLocation(PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.userContext.getAuthServer(), (String)location).toString());
                    }
                    catch (ServiceException e) {
                        this.handleError((Exception)((Object)e));
                    }
                    catch (RemoteException e) {
                        this.handleError(e);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataSourceColumnPicker.this.valuePicker.setValue(val);
                    }
                });
            } else {
                this.updateValueProvider(this.valuePicker, this.vpAdapter, this.getSelectedDataSource());
                this.valuePicker.setValue(val);
            }
            Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
            String title = null;
            title = this.getSelectionMode() == 300 ? RB.getStringResource((String)RB_KEY, (String)"columnTitle.txt", (Locale)this.getLocale()) : RB.getStringResource((String)RB_KEY, (String)"columnsTitle.txt", (Locale)this.getLocale());
            this.dialog = owner != null ? new OptionsDialog((Dialog)owner, title, true) : new OptionsDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), title, true);
            JPanel mainPanel = this.dialog.getMainPanel();
            AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
            mainPanel.setLayout((LayoutManager)layout);
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                layout.setRowSpacePartitioner((SpacePartitionerInterface)new EqualSpacePartitioner(false));
                JPanel topPanel = new JPanel();
                topPanel.setOpaque(false);
                topPanel.setLayout(new BorderLayout(5, 5));
                topPanel.add((Component)this.panel, "Center");
                topPanel.add((Component)new JLabel(RB.getStringResource((String)RB_KEY, (String)"selectADataSource.txt", (Locale)this.getLocale())), "North");
                mainPanel.add(topPanel);
            } else {
                mainPanel.add(new JLabel(RB.getStringResource((String)RB_KEY, (String)"selectADataSource.txt", (Locale)this.getLocale())));
                mainPanel.add((Component)this.dataSourceCombo);
            }
            mainPanel.add(valuePickerPanel);
            this.dialog.pack();
            Util.centerOver((Window)this.dialog, (Component)this);
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
        this.dialog.setVisible(true);
        if (this.dataSourceCombo != null) {
            this.dataSourceCombo.removeActionListener((ActionListener)this);
        }
        if (!this.dialog.wasCancelled()) {
            Object value = this.valuePicker.getValue();
            this.setValue(value);
            this.fireValueChanged();
        }
        this.dialog = null;
    }

    private Object getFirstValueUnwrapped(Object value) {
        Collection c;
        if (value instanceof DataSourceColumnInterface) {
            return value;
        }
        if (value instanceof ValueItem) {
            return ((ValueItem)value).getValue();
        }
        if (value instanceof Collection && !(c = (Collection)value).isEmpty()) {
            return this.getFirstValueUnwrapped(c.iterator().next());
        }
        return null;
    }

    private void setColumnsOnVP() {
        if (this.getSelectionMode() != 300) {
            String colName;
            ArrayList<String> columns;
            MutableTableColumnsInterface bm;
            TableModel tm = (TableModel)this.valuePicker.getBrowseModel();
            if (tm instanceof SortableTableModelAdapter) {
                tm = ((SortableTableModelAdapter)tm).getModel();
            }
            if (tm instanceof MutableTableColumnsInterface) {
                bm = (MutableTableColumnsInterface)tm;
                columns = new ArrayList<String>();
                columns.add("LABEL");
                colName = RB.getStringResource((String)RB_KEY, (String)"column.txt", (Locale)this.getLocale());
                bm.setColumnName(colName, 0);
                bm.setColumns(columns);
                ((TableView)this.valuePicker.getBrowseComponent()).setColumnHeaderVisible(true);
            }
            if (this.valuePicker.getTargetModel() instanceof MutableTableColumnsInterface) {
                bm = (MutableTableColumnsInterface)this.valuePicker.getTargetModel();
                columns = new ArrayList();
                columns.add("LABEL");
                columns.add(DATA_SOURCE_COLUMN);
                colName = RB.getStringResource((String)RB_KEY, (String)"column.txt", (Locale)this.getLocale());
                bm.setColumnName(colName, 0);
                bm.setColumnName(RB.getStringResource((String)RB_KEY, (String)"dataSource.txt", (Locale)this.getLocale()), 1);
                bm.setColumns(columns);
                ((ValueListEditor)this.valuePicker.getTargetComponent()).getTable().setColumnHeaderVisible(true);
            }
        }
    }

    private DataSourceInterface getSelectedDataSource() {
        if (this.dataSourceCombo != null) {
            return (DataSourceInterface)this.dataSourceCombo.getSelectedItem();
        }
        return null;
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
        if (!this.isEditing) {
            this.isEditing = true;
            this.fireEditingStarted();
        }
    }

    public void valueModified(ChangeEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    public void valueChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.listEditor) {
            if (!this.ignoreEvents) {
                this.fireValueChanged();
            }
        } else if (source == this.mainValuePicker && !this.ignoreEvents) {
            this.fireValueChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            try {
                this.browsing = true;
                this.selectColumns();
            }
            finally {
                this.browsing = false;
            }
        } else if (e.getSource() == this.dataSourceCombo) {
            this.updateValueProvider(this.valuePicker, this.vpAdapter, this.getSelectedDataSource());
            this.setColumnsOnVP();
        }
    }

    protected Collection filterColumns(Collection values) {
        ArrayList<ValueItem> filteredValues = new ArrayList<ValueItem>();
        if (values != null) {
            for (ValueItem element : values) {
                if (!this.isValueItemAllowed(element)) continue;
                filteredValues.add(element);
            }
        }
        return filteredValues;
    }

    protected boolean isValueItemAllowed(ValueItem vi) {
        if (vi.getValue() instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface dataSourceColumn = (DataSourceColumnInterface)vi.getValue();
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                return this.isDataSourceTypeAllowed(dataSourceColumn.getDataSource().getDataSourceType()) && this.isColumnTypeAllowed(dataSourceColumn.getColumnType());
            }
            return this.dataSources.contains(dataSourceColumn.getDataSource()) && this.isColumnTypeAllowed(dataSourceColumn.getColumnType());
        }
        return false;
    }

    private String getNameForLocation(String location) {
        int index = location.lastIndexOf(40);
        if (index != -1) {
            location = location.substring(0, index);
        }
        return location;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        if (this.maxColumns != maxColumns) {
            int oldValue = this.maxColumns;
            this.maxColumns = maxColumns;
            if (this.mainValuePicker != null) {
                this.mainValuePicker.setMaxValues(maxColumns);
            }
            if (this.valuePicker != null) {
                this.valuePicker.setMaxValues(maxColumns);
            }
            if (this.listEditor != null) {
                this.listEditor.setMaxItems(maxColumns);
            }
            this.firePropertyChange("maxColumns", oldValue, this.maxColumns);
        }
    }

    @SASScope
    private class TableViewHeaderSort
    extends MouseInputAdapter {
        boolean pressOk = false;
        private TableView tv;

        public TableViewHeaderSort(TableView tv) {
            this.tv = tv;
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.pressOk = false;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.pressOk = this.tv.getColumnHeader().getCursor() == Cursor.getDefaultCursor();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (SwingUtilities.isLeftMouseButton(event) && this.pressOk) {
                SortableInterface sort;
                int col = this.tv.convertColumnIndexToModel(this.tv.getTableHeader().columnAtPoint(event.getPoint()));
                String columnName = TableViewUtil.getColumnName((TableModel)this.tv.getModel(), (int)col);
                if (this.tv.getModel() instanceof SortableInterface && (sort = (SortableInterface)this.tv.getModel()).isSortAllowed() && sort.isColumnSortable(columnName)) {
                    String[] columns = sort.getSortedColumns();
                    int[] directions = sort.getSortedDirections();
                    int direction = 0;
                    if (columnName != null && columns != null && directions != null && columns.length == directions.length) {
                        for (int i = 0; i < columns.length; ++i) {
                            if (!columnName.equals(columns[i])) continue;
                            if (directions[i] != 0) break;
                            direction = 1;
                            break;
                        }
                    }
                    ArrayList<String> newColumns = new ArrayList<String>();
                    ArrayList<Integer> newDirections = new ArrayList<Integer>();
                    newColumns.add(columnName);
                    newDirections.add(new Integer(direction));
                    for (int i = 0; i < columns.length; ++i) {
                        if (columns[i] == null || columns[i].equals(columnName)) continue;
                        newColumns.add(columns[i]);
                        newDirections.add(new Integer(directions[i]));
                    }
                    int size = newDirections.size();
                    int[] ndirections = new int[size];
                    for (int i = 0; i < size; ++i) {
                        ndirections[i] = (Integer)newDirections.get(i);
                    }
                    try {
                        if (this.tv.isEditing()) {
                            this.tv.getCellEditor().cancelCellEditing();
                        }
                        sort.sort(newColumns.toArray(new String[0]), ndirections);
                    }
                    catch (SortException sortException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @SASScope
    private class NoBorderTableHeaderRenderer
    extends SortHeaderRenderer {
        public NoBorderTableHeaderRenderer() {
            this.setHorizontalAlignment(10);
        }

        protected Border createOutsideBorder() {
            return BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.activeCaption);
        }
    }

    @SASScope
    protected class DataSourceColumnRendererHandler
    extends ValuePickerRendererHandler {
        private Icon characterImage = Resources.getImageIcon((String)"TypeChar.gif", (int)16);
        private Icon numericImage = Resources.getImageIcon((String)"TypeNum.gif", (int)16);
        private Icon dateImage = Resources.getImageIcon((String)"TypeDate.gif", (int)16);
        private Icon timeImage = Resources.getImageIcon((String)"TypeTime.gif", (int)16);
        private Icon timeStampImage = Resources.getImageIcon((String)"TypeTimeStamp.gif", (int)16);
        private Icon categoryImage = Resources.getImageIcon((String)"CategoryType.gif", (int)16);
        private Icon measureImage = Resources.getImageIcon((String)"MeasureItemType.gif", (int)16);
        private static final String ICON = "ICON";

        protected DataSourceColumnRendererHandler() {
        }

        public void configureLabelFor(JLabel label, Object value, JComponent visual, boolean isSelected, boolean hasFocus, Object cellType) {
            block31: {
                DataSourceColumnInterface dsc;
                super.configureLabelFor(label, value, visual, isSelected, hasFocus, cellType);
                if (value instanceof DataSourceColumnInterface) {
                    DataSourceColumnInterface dsc2 = (DataSourceColumnInterface)value;
                    label.setText(dsc2.getColumnLabel() + " [" + dsc2.getColumnName() + "]");
                } else if (value instanceof ValueItem) {
                    Object val;
                    if (DataSourceColumnPicker.this.getSelectionMode() != 300 || !(visual instanceof JComboBox) && !(visual instanceof JList)) {
                        val = ((ValueItem)value).getValue();
                        if (val instanceof DataSourceColumnInterface) {
                            dsc = (DataSourceColumnInterface)val;
                            label.setText(((ValueItem)value).getLabel() + " [" + dsc.getColumnName() + "]");
                        } else {
                            label.setText(((ValueItem)value).getLabel());
                        }
                    } else if (((ValueItem)value).getValue() != null) {
                        val = ((ValueItem)value).getValue();
                        if (val instanceof DataSourceColumnInterface) {
                            dsc = (DataSourceColumnInterface)val;
                            label.setText(((ValueItem)value).getLabel() + " [" + dsc.getColumnName() + "][" + DataSourceColumnPicker.this.getNameForLocation(dsc.getDataSource().getDataSourceLocation()) + "]");
                        }
                    } else {
                        val = ((ValueItem)value).getValue();
                        if (val instanceof DataSourceColumnInterface) {
                            dsc = (DataSourceColumnInterface)val;
                            label.setText(((ValueItem)value).getLabel() + " [" + dsc.getColumnName() + "]");
                        } else {
                            label.setText(((ValueItem)value).getLabel());
                        }
                    }
                }
                label.setIcon(null);
                ValueItem vi = null;
                if (value instanceof ValueItem) {
                    vi = (ValueItem)value;
                    if (vi.getAttribute(ICON) != null) {
                        label.setIcon((Icon)vi.getAttribute(ICON));
                        return;
                    }
                    value = ((ValueItem)value).getValue();
                }
                if (value instanceof DataSourceColumnInterface) {
                    dsc = (DataSourceColumnInterface)value;
                    if (DataSourceColumnPicker.this.getDataProvider() instanceof PromptDataProviderInterface && dsc.getDataSource().getDataSourceType() == 4L) {
                        try {
                            if (((PromptDataProviderInterface)DataSourceColumnPicker.this.getDataProvider()).isMeasureDataItem(dsc.getDataSource().getDataSourceLocation(), dsc.getColumnName())) {
                                if (vi != null) {
                                    vi.setAttribute(ICON, (Object)this.measureImage);
                                }
                                label.setIcon(this.measureImage);
                                break block31;
                            }
                            if (vi != null) {
                                vi.setAttribute(ICON, (Object)this.categoryImage);
                            }
                            label.setIcon(this.categoryImage);
                        }
                        catch (ServerConnectionException ex) {
                            DataSourceColumnPicker.this.handleError((Exception)((Object)ex));
                        }
                    } else {
                        long colType = dsc.getColumnType();
                        if (colType == 1L) {
                            label.setIcon(this.characterImage);
                        } else if (colType == 2L) {
                            label.setIcon(this.numericImage);
                        } else if (colType == 4L) {
                            label.setIcon(this.dateImage);
                        } else if (colType == 8L) {
                            label.setIcon(this.timeImage);
                        } else if (colType == 16L) {
                            label.setIcon(this.timeStampImage);
                        }
                    }
                }
            }
        }
    }

    @SASScope
    protected class DataSourceColumnRenderer
    extends DefaultTableCellRenderer {
        private DataSourceColumnRendererHandler handler;

        public DataSourceColumnRenderer(DataSourceColumnRendererHandler handler) {
            this.handler = handler;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.handler.configureLabelFor(comp, value, table, isSelected, hasFocus, table.getColumnName(column));
            return comp;
        }
    }

    @SASScope
    protected class SelectColumnAction
    extends AbstractAction {
        public SelectColumnAction() {
            this.putValue("SmallIcon", null);
            this.putValue("Name", "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSourceColumnPicker.this.selectColumns();
        }
    }

    @SASScope
    private class ValueProviderAdapter
    implements ValueProviderInterface {
        private List valueProviders;
        private List values;
        private PromptGroupInterface promptGroup = new PromptGroup();
        private PromptValuesInterface promptValues;
        private TextDefinition definition = new TextDefinition("dummyPrompt");
        private DynamicPromptValueContext promptContext;

        public ValueProviderAdapter() {
            this.promptGroup.addPromptDefinition((PromptDefinitionInterface)this.definition);
            this.promptValues = new PromptValues(this.promptGroup);
            this.promptContext = new DynamicPromptValueContext(this.promptValues, this.promptGroup, null, DataSourceColumnPicker.this.getDataProvider());
        }

        public boolean isValueDisplayed() {
            return false;
        }

        public boolean setValueProvider(ValueProviderInterface provider) {
            this.values = null;
            if (this.valueProviders == null || this.valueProviders.size() != 1 || this.valueProviders.get(0) != provider) {
                this.valueProviders = new ArrayList();
                if (provider != null) {
                    this.valueProviders.add(provider);
                }
                return true;
            }
            return false;
        }

        public boolean setValueProviders(List providers) {
            this.values = null;
            if (this.valueProviders != providers) {
                this.valueProviders = providers;
                return true;
            }
            return false;
        }

        public Object getValues(Locale locale) throws ValueProviderException {
            DataSourceColumnPicker.this.errorMode = false;
            if (this.valueProviders != null) {
                if (this.valueProviders.size() == 1) {
                    List values = null;
                    try {
                        ValueProviderInterface valueProvider = (ValueProviderInterface)this.valueProviders.get(0);
                        this.definition.setValueProvider(valueProvider);
                        valueProvider = DataSourceColumnPicker.this.getDataProvider().getValueProvider(valueProvider);
                        values = valueProvider instanceof DynamicValueProviderInterface ? (List)((DynamicValueProviderInterface)valueProvider).getValues(locale, (DynamicPromptValueContextInterface)this.promptContext, ValueType.LIST) : (List)valueProvider.getValues(locale);
                        values = (List)DataSourceColumnPicker.this.filterColumns(values);
                        this.addDataSourceInfo(values);
                    }
                    catch (ValueProviderException ex) {
                        if (!DataSourceColumnPicker.this.browsing) {
                            DataSourceColumnPicker.this.errorMode = true;
                            if (DataSourceColumnPicker.this.browseButton != null) {
                                DataSourceColumnPicker.this.browseButton.setEnabled(false);
                            }
                        }
                        throw ex;
                    }
                    this.values = values;
                    return values;
                }
                ArrayList allValues = new ArrayList();
                boolean oneValid = false;
                ArrayList<ValueProviderException> errors = new ArrayList<ValueProviderException>();
                Iterator iter = this.valueProviders.iterator();
                while (iter.hasNext()) {
                    try {
                        ValueProviderInterface valueProvider = (ValueProviderInterface)iter.next();
                        this.definition.setValueProvider(valueProvider);
                        valueProvider = DataSourceColumnPicker.this.getDataProvider().getValueProvider(valueProvider);
                        Collection values = null;
                        values = valueProvider instanceof DynamicValueProviderInterface ? (List)((DynamicValueProviderInterface)valueProvider).getValues(locale, (DynamicPromptValueContextInterface)this.promptContext, ValueType.LIST) : (List)valueProvider.getValues(locale);
                        oneValid = true;
                        values = DataSourceColumnPicker.this.filterColumns(values);
                        this.addDataSourceInfo(values);
                        allValues.addAll(values);
                    }
                    catch (ValueProviderException ex) {
                        errors.add(ex);
                    }
                }
                this.values = allValues;
                if (!errors.isEmpty()) {
                    String msg = null;
                    for (ValueProviderException ex : errors) {
                        if (msg == null) {
                            msg = ex.getMessage();
                            continue;
                        }
                        msg = msg + "\n" + ex.getMessage();
                    }
                    ValueProviderException vpe = new ValueProviderException((Throwable)errors.get(0), msg);
                    if (!oneValid) {
                        DataSourceColumnPicker.this.errorMode = true;
                        if (DataSourceColumnPicker.this.browseButton != null) {
                            DataSourceColumnPicker.this.browseButton.setEnabled(false);
                        }
                        throw vpe;
                    }
                    DataSourceColumnPicker.this.handleError((Exception)((Object)vpe));
                }
                return allValues;
            }
            this.values = Collections.EMPTY_LIST;
            return this.values;
        }

        private void addDataSourceInfo(Collection values) {
            for (ValueItem vi : values) {
                if (vi.getAttribute(DataSourceColumnPicker.DATA_SOURCE_COLUMN) != null) continue;
                vi.setAttribute(DataSourceColumnPicker.DATA_SOURCE_COLUMN, (Object)DataSourceColumnPicker.this.getNameForLocation(((DataSourceColumnInterface)vi.getValue()).getDataSource().getDataSourceLocation()));
            }
        }

        public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
            if (this.valueProviders != null) {
                if (this.values == null) {
                    this.getValues(locale);
                }
                if (this.values != null) {
                    int size = this.values.size();
                    if (count < 0) {
                        return this.values.subList(index, size);
                    }
                    return this.values.subList(index, Math.min(index + count, size));
                }
            }
            return Collections.EMPTY_LIST;
        }

        public DataTypeInterface getDataType() throws ValueProviderException {
            return DataSourceColumnType.DEFAULT_INSTANCE;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
            return this.getValues(locale);
        }

        public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
            return this.getValues(locale, index, count);
        }
    }
}

