/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.LimitedTextField;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

@SASScope
public abstract class BaseRemoteObjectPicker
extends JComponent
implements EditorInterface,
ActionListener,
DocumentListener,
SupportsGenericErrorHandlerInterface,
ItemListener {
    public static final String RB_KEY = "BaseRemoteObjectPicker.";
    private static final long serialVersionUID = -4266846382290931710L;
    protected JComponent locationComponent;
    private JTextComponent textComponent;
    protected AbstractButton rfsButton;
    protected FocusAdapter focusListener;
    private boolean isEditing;
    private boolean valueModified;
    private boolean handlingError;
    private List initialValues;
    private GenericErrorHandlerInterface errorHandler;
    private ChangeCursorCommand changeCursorCommand;
    private EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    private LoggerFactoryInterface logFactory;

    protected void init() {
        this.logFactory = this.createLogFactory();
        this.errorHandler = new JOptionPaneErrorHandler((Component)this);
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.isEditing = false;
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (event.isTemporary()) {
                    return;
                }
                Component comp1 = event.getComponent();
                Component comp2 = event.getOppositeComponent();
                if (comp1 == null || comp2 == null) {
                    BaseRemoteObjectPicker.this.isEditing = false;
                    BaseRemoteObjectPicker.this.valueModified = false;
                    BaseRemoteObjectPicker.this.fireEditingStopped();
                    return;
                }
                if (!SwingUtilities.isDescendingFrom(comp2, BaseRemoteObjectPicker.this)) {
                    BaseRemoteObjectPicker.this.isEditing = false;
                    BaseRemoteObjectPicker.this.valueModified = false;
                    BaseRemoteObjectPicker.this.fireEditingStopped();
                }
            }

            @Override
            public void focusGained(FocusEvent event) {
                if (!BaseRemoteObjectPicker.this.isEditing) {
                    BaseRemoteObjectPicker.this.isEditing = true;
                    BaseRemoteObjectPicker.this.fireEditingStarted();
                }
            }
        };
        this.createUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.locationComponent != null) {
            this.locationComponent.setEnabled(enabled);
        }
        if (this.rfsButton != null) {
            this.rfsButton.setEnabled(enabled);
        }
    }

    public List getInitialPossibleValues() {
        return this.initialValues;
    }

    public void setInitialPossibleValues(List initialPossibleValues) {
        if (this.initialValues != initialPossibleValues) {
            List oldValue = this.initialValues;
            this.initialValues = initialPossibleValues;
            this.removeListeners();
            this.removeAll();
            this.createUI();
            this.firePropertyChange("initialPossibleValues", oldValue, this.initialValues);
        }
    }

    protected LoggerFactoryInterface createLogFactory() {
        return new Log4JFactory2();
    }

    protected void createUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.locationComponent = this.createLocationComponent();
        this.rfsButton = this.createFileSelectorButton();
        this.addListeners();
        this.add((Component)this.locationComponent, "Center");
        this.add((Component)this.rfsButton, "East");
    }

    protected void addListeners() {
        if (this.locationComponent instanceof JTextField) {
            ((JTextField)this.locationComponent).addActionListener(this);
        }
        if (this.textComponent instanceof JTextComponent) {
            this.textComponent.getDocument().addDocumentListener(this);
        }
        if (this.locationComponent instanceof JComboBox) {
            ((JComboBox)this.locationComponent).addItemListener(this);
        }
        this.locationComponent.addFocusListener(this.focusListener);
        this.rfsButton.addActionListener(this);
        this.rfsButton.addFocusListener(this.focusListener);
    }

    public void removeListeners() {
        if (this.locationComponent instanceof JTextField) {
            ((JTextField)this.locationComponent).removeActionListener(this);
        }
        if (this.textComponent instanceof JTextComponent) {
            this.textComponent.getDocument().removeDocumentListener(this);
        }
        if (this.locationComponent != null) {
            this.locationComponent.removeFocusListener(this.focusListener);
        }
        if (this.locationComponent instanceof JComboBox) {
            ((JComboBox)this.locationComponent).removeItemListener(this);
        }
        if (this.rfsButton != null) {
            this.rfsButton.removeActionListener(this);
            this.rfsButton.removeFocusListener(this.focusListener);
        }
    }

    protected JComponent createLocationComponent() {
        LimitedTextField lc = null;
        if (this.initialValues == null || this.initialValues.isEmpty()) {
            LimitedTextField textField = new LimitedTextField(30);
            textField.setName("locationTextField");
            this.textComponent = textField;
            lc = textField;
        } else {
            WideComboBox combo = new WideComboBox(new DefaultComboBoxModel());
            combo.setName("locationComboBox");
            combo.setPopupStyle(5);
            combo.setEditable(true);
            for (Object element : this.initialValues) {
                if (!this.isInitialValueAllowed(element)) continue;
                combo.addItem(element);
            }
            combo.setSelectedIndex(-1);
            PlainComboBoxEditor editor = new PlainComboBoxEditor();
            this.textComponent = (JTextComponent)editor.getEditorComponent();
            combo.setEditor((ComboBoxEditor)editor);
            lc = combo;
        }
        return lc;
    }

    protected boolean isInitialValueAllowed(Object value) {
        return true;
    }

    public String getText() {
        if (this.textComponent instanceof JTextComponent) {
            return this.textComponent.getText();
        }
        return null;
    }

    public void setText(String txt) {
        if (this.locationComponent instanceof JTextComponent) {
            ((JTextComponent)this.locationComponent).setText(txt);
        } else if (this.locationComponent instanceof JComboBox) {
            ((JComboBox)this.locationComponent).setSelectedItem(txt);
        } else if (this.textComponent instanceof JTextComponent) {
            this.textComponent.setText(txt);
        }
    }

    protected AbstractButton createFileSelectorButton() {
        JButton button = new JButton(RB.getStringResource((String)RB_KEY, (String)"browse.txt", (Locale)this.getLocale()));
        return button;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.locationComponent) {
            if (this.locationComponent instanceof JTextComponent) {
                this.setValue(((JTextComponent)this.locationComponent).getText());
            } else if (this.locationComponent instanceof JComboBox) {
                this.setValue(((JComboBox)this.locationComponent).getSelectedItem());
            }
        } else if (source == this.rfsButton) {
            this.showFileSelector();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (e.getStateChange() == 1 && source == this.locationComponent && this.locationComponent instanceof JComboBox) {
            this.setValue(((JComboBox)this.locationComponent).getSelectedItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showFileSelector() {
        RemoteFileSelectorDialog dialog = null;
        BaseRemoteFileSelectorPanel panel = null;
        try {
            Window comp = SwingUtilities.getWindowAncestor(this);
            if (comp != null) {
                this.changeCursorCommand.apply((Object)comp);
            }
            if ((panel = this.getRemoteFileSelectorPanel()) == null) {
                return;
            }
            dialog = this.getRemoteFileSelectorDialog(panel);
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
        dialog.setVisible(true);
        if (!panel.isCancelled()) {
            List items = new ArrayList();
            items = panel.getReturnedInformation(true);
            if (items != null && items.size() > 0) {
                if (panel instanceof InformationServicesSelectorPanel) {
                    this.setValue(PersistHelper.parseSBIPUrl((String)items.get(0).toString()));
                } else {
                    this.setValue(items.get(0).toString());
                }
            }
        }
    }

    protected RemoteFileSelectorDialog getRemoteFileSelectorDialog(BaseRemoteFileSelectorPanel panel) {
        Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (owner != null) {
            return new RemoteFileSelectorDialog((Dialog)owner, this.getRemoteObjectSelectorTitle(), true, 2, panel);
        }
        return new RemoteFileSelectorDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this.getRemoteObjectSelectorTitle(), true, 2, panel);
    }

    protected abstract BaseRemoteFileSelectorPanel getRemoteFileSelectorPanel();

    protected abstract String getRemoteObjectSelectorTitle();

    protected void handleError(Object error) {
        if (this.handlingError) {
            return;
        }
        try {
            this.handlingError = true;
            String msg = null;
            if (error instanceof Throwable) {
                msg = ((Throwable)error).getLocalizedMessage();
            } else if (error != null) {
                msg = error.toString();
            }
            if (msg == null) {
                msg = "";
            }
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)msg)), null);
            } else if (error instanceof Throwable) {
                LoggerRepository2.getLogger((String)BaseRemoteObjectPicker.class.getName(), (LoggerFactoryInterface)this.logFactory).error(msg, (Throwable)error);
            } else {
                LoggerRepository2.getLogger((String)BaseRemoteObjectPicker.class.getName(), (LoggerFactoryInterface)this.logFactory).error(msg);
            }
        }
        finally {
            this.handlingError = false;
        }
    }

    public boolean isHandlingError() {
        return this.handlingError;
    }

    public void selectAll() {
        if (this.textComponent instanceof JTextComponent) {
            this.textComponent.selectAll();
        }
    }

    public Component getEditorComponent() {
        return this;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
        this.valueModified = false;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void requestFocus() {
        this.locationComponent.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return this.locationComponent.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.locationComponent.requestFocusInWindow();
    }

    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @SASScope
    class PlainComboBoxEditor
    implements ComboBoxEditor {
        private LimitedTextField tc = new LimitedTextField(30);

        public PlainComboBoxEditor() {
            this.tc.setBorder(null);
        }

        public JTextComponent getTextComponent() {
            return this.tc;
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.tc.addActionListener(l);
        }

        @Override
        public Component getEditorComponent() {
            return this.tc;
        }

        @Override
        public Object getItem() {
            return this.tc.getText();
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.tc.removeActionListener(l);
        }

        @Override
        public void selectAll() {
            this.tc.selectAll();
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                this.tc.setText(anObject.toString());
            } else {
                this.tc.setText("");
            }
        }
    }
}

