/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.rmi;

import com.sas.swing.models.remotefileselector2.AddFolderInterface;
import com.sas.swing.models.remotefileselector2.DeleteFileInterface;
import com.sas.swing.models.remotefileselector2.MutableFileFilterInterface;
import com.sas.swing.models.remotefileselector2.PasteFileInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelDirectoriesOnlyInterface;
import com.sas.swing.models.remotefileselector2.RenameFileInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceNavigationModel;
import com.sas.swing.models.remotefileselector2.informationservices.IncludeSystemFoldersInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.swing.models.remotefileselector2.rmi.RemoteFileServiceModelRmi;
import com.sas.swing.models.remotefileselector2.rmi.RenameFileRmiInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RemoteFileServiceModelRmiImpl
extends UnicastRemoteObject
implements RemoteFileServiceModelRmi,
TableModelListener,
PropertyChangeListener {
    private static final long EVENT_WAIT_LIMIT_SECS = 60L;
    RemoteFileModel2Interface _delegate;
    private boolean keepTableModelEvents;
    private boolean keepPropertyChangeEvents;
    private int watchedEventTypes;
    private Integer watchedEventTypesLock;
    private LinkedBlockingQueue queue;
    private Thread occupant;

    public RemoteFileServiceModelRmiImpl(RemoteFileModel2Interface delegate) throws RemoteException {
        this._delegate = delegate;
        this.init();
    }

    public RemoteFileServiceModelRmiImpl(RemoteFileModel2Interface delegate, int port) throws RemoteException {
        super(port);
        this._delegate = delegate;
        this.init();
    }

    public RemoteFileServiceModelRmiImpl(RemoteFileModel2Interface delegate, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this._delegate = delegate;
        this.init();
    }

    private void init() {
        this.keepTableModelEvents = false;
        this.keepPropertyChangeEvents = false;
        this.watchedEventTypes = 0;
        this.watchedEventTypesLock = new Integer(0);
        this.queue = new LinkedBlockingQueue();
    }

    @Override
    public void loadFileInfo() throws RemoteException {
        try {
            this._delegate.loadFileInfo();
        }
        catch (Exception e) {
            throw new RemoteException(e.toString());
        }
    }

    @Override
    public void setFilterValues(List values) throws RemoteException {
        this._delegate.setFilterValues(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getEvents() throws RemoteException {
        LinkedBlockingQueue linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            ArrayList list = new ArrayList();
            if (this.queue.drainTo(list) == 0) {
                this.occupant = Thread.currentThread();
                if (this.watchedEventTypes > 0) {
                    try {
                        Object obj = this.queue.poll(60L, TimeUnit.SECONDS);
                        if (obj != null) {
                            list.add(obj);
                            this.queue.drainTo(list);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.occupant = null;
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeWatchLevel(int delta) {
        Integer n = this.watchedEventTypesLock;
        synchronized (n) {
            Thread t;
            this.watchedEventTypes += delta;
            if (this.watchedEventTypes == 0 && (t = this.occupant) != null) {
                t.interrupt();
            }
        }
    }

    @Override
    public void setKeepPropertyChangeEvents(boolean keep) throws RemoteException {
        if (this.keepPropertyChangeEvents == keep) {
            return;
        }
        this.keepPropertyChangeEvents = keep;
        if (keep) {
            this._delegate.addPropertyChangeListener(this);
            this.changeWatchLevel(1);
        } else {
            if (this._delegate instanceof IFileServiceNavigationModel) {
                ((IFileServiceNavigationModel)this._delegate).removePropertyChangeListener(this);
            } else if (this._delegate instanceof InformationServicesNavigationModel) {
                ((InformationServicesNavigationModel)this._delegate).removePropertyChangeListener(this);
            }
            this.changeWatchLevel(-1);
        }
    }

    @Override
    public void setKeepTableModelEvents(boolean keep) throws RemoteException {
        if (this.keepTableModelEvents == keep) {
            return;
        }
        this.keepTableModelEvents = keep;
        if (keep) {
            this._delegate.addTableModelListener(this);
            this.changeWatchLevel(1);
        } else {
            this._delegate.removeTableModelListener(this);
            this.changeWatchLevel(-1);
        }
    }

    @Override
    public boolean isFolderPopulated(RemoteFileMetadataInterface folderNode) throws RemoteException {
        return this._delegate.isFolderPopulated(folderNode);
    }

    @Override
    public String getLocationForFolderItem(String fileName) throws RemoteException {
        return this._delegate.getLocationForFolderItem(fileName);
    }

    @Override
    public String[] getFileInfo(String fileName) throws RemoteException {
        return this._delegate.getFileInfo(fileName);
    }

    @Override
    public String buildFullyQualifiedLocation(String location, String entryFile) throws RemoteException {
        return this._delegate.buildFullyQualifiedLocation(location, entryFile);
    }

    @Override
    public String getRootLocation() throws RemoteException {
        return this._delegate.getRootLocation();
    }

    @Override
    public boolean isExistingSubFolder(String path, String folderName) throws RemoteException {
        return ((AddFolderInterface)((Object)this._delegate)).isExistingSubFolder(path, folderName);
    }

    @Override
    public RemoteFileMetadataInterface addFolder(String path, String folderName) throws RemoteException {
        return ((AddFolderInterface)((Object)this._delegate)).addFolder(path, folderName);
    }

    @Override
    public void renameFolder(RemoteFileMetadataInterface folderNode, String newFolderName) throws RemoteException {
        ((AddFolderInterface)((Object)this._delegate)).renameFolder(folderNode, newFolderName);
    }

    @Override
    public void moveItem(RemoteFileMetadataInterface itemNode) throws RemoteException {
        ((PasteFileInterface)((Object)this._delegate)).moveItem(itemNode);
    }

    @Override
    public void deleteItem(RemoteFileMetadataInterface nodeOfItemToDelete) throws RemoteException {
        ((DeleteFileInterface)((Object)this._delegate)).deleteItem(nodeOfItemToDelete);
    }

    @Override
    public void renameItem(RemoteFileMetadataInterface itemNode, String newItemName) throws RemoteException {
        ((RenameFileInterface)((Object)this._delegate)).renameItem(itemNode, newItemName);
    }

    @Override
    public void renameItem(int rowIndex, String newItemName) throws RemoteException {
        ((RenameFileRmiInterface)((Object)this._delegate)).renameItem(rowIndex, newItemName);
    }

    @Override
    public boolean isExistingFileItem(String path, String itemName) throws RemoteException {
        return ((RenameFileInterface)((Object)this._delegate)).isExistingFileItem(path, itemName);
    }

    @Override
    public void setLocation(String path) throws RemoteException {
        this._delegate.setLocation(path);
    }

    @Override
    public String getLocation() throws RemoteException {
        return this._delegate.getLocation();
    }

    @Override
    public boolean isUpwardPathRestricted() throws RemoteException {
        return this._delegate.isUpwardPathRestricted();
    }

    @Override
    public String getBasePath() throws RemoteException {
        return this._delegate.getBasePath();
    }

    @Override
    public String getServerName() throws RemoteException {
        return this._delegate.getServerName();
    }

    @Override
    public RemoteFileMetadataInterface getNodeAt(int rowIndex) throws RemoteException {
        return this._delegate.getNodeAt(rowIndex);
    }

    @Override
    public boolean isTableEditable() throws RemoteException {
        return this._delegate.isTableEditable();
    }

    @Override
    public void setTableEditable(boolean editable) throws RemoteException {
        this._delegate.setTableEditable(editable);
    }

    @Override
    public String[][] parseIntoFoldersAndLocations(String path) throws RemoteException {
        return this._delegate.parseIntoFoldersAndLocations(path);
    }

    @Override
    public int getColumnIndex(String column) throws RemoteException {
        return this._delegate.getColumnIndex(column);
    }

    @Override
    public void setRefreshNeeded(boolean needsRefresh) throws RemoteException {
        this._delegate.setRefreshNeeded(needsRefresh);
    }

    @Override
    public boolean isRefreshNeeded() throws RemoteException {
        return this._delegate.isRefreshNeeded();
    }

    @Override
    public void addToPasteBuffer(Object node) throws RemoteException {
        this._delegate.addToPasteBuffer(node);
    }

    @Override
    public void clearPasteBuffer() throws RemoteException {
        this._delegate.clearPasteBuffer();
    }

    @Override
    public List getPasteBuffer() throws RemoteException {
        return this._delegate.getPasteBuffer();
    }

    @Override
    public void setPasetBufferCommandType(int commandType) throws RemoteException {
        this._delegate.setPasteBufferCommandType(commandType);
    }

    @Override
    public int getPasteBufferCommandType() throws RemoteException {
        return this._delegate.getPasteBufferCommandType();
    }

    @Override
    public int getColumnCount() throws RemoteException {
        return this._delegate.getColumnCount();
    }

    @Override
    public int getRowCount() throws RemoteException {
        return this._delegate.getRowCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) throws RemoteException {
        return this._delegate.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Class getColumnClass(int columnIndex) throws RemoteException {
        return this._delegate.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) throws RemoteException {
        return this._delegate.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) throws RemoteException {
        this._delegate.setValueAt(value, rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) throws RemoteException {
        return this._delegate.getColumnName(columnIndex);
    }

    @Override
    public List getLocations() throws RemoteException {
        return this._delegate.getLocations();
    }

    @Override
    public int getLocationsCurrentPathIndex() throws RemoteException {
        return this._delegate.getLocationsCurrentPathIndex();
    }

    @Override
    public boolean isDirectoriesOnly() throws RemoteException {
        return ((RemoteFileModelDirectoriesOnlyInterface)((Object)this._delegate)).isDirectoriesOnly();
    }

    @Override
    public void setDirectoriesOnly(boolean directoriesOnly) throws RemoteException {
        ((RemoteFileModelDirectoriesOnlyInterface)((Object)this._delegate)).setDirectoriesOnly(directoriesOnly);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.keepPropertyChangeEvents) {
            this.queue.add(evt);
        }
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (this.keepTableModelEvents) {
            this.queue.add(evt);
        }
    }

    @Override
    public String[] getFileInfo(String folderLocation, String fileName, String fileType) throws RemoteException {
        return this._delegate.getFileInfo(folderLocation, fileName, fileType);
    }

    @Override
    public String getValidName(String fileName) throws RemoteException {
        return this._delegate.getValidName(fileName);
    }

    @Override
    public String getValidNameStatus(String fileName) throws RemoteException {
        return this._delegate.getValidNameStatus(fileName);
    }

    @Override
    public boolean isFileDuplicate(String path, String fileName, String selectedFileType) throws RemoteException {
        return this._delegate.isFileDuplicate(path, fileName, selectedFileType);
    }

    @Override
    public boolean isIncludeSystemFolders() throws RemoteException {
        return ((IncludeSystemFoldersInterface)((Object)this._delegate)).isIncludeSystemFolders();
    }

    @Override
    public void setIncludeSystemFolders(boolean include) throws RemoteException {
        ((IncludeSystemFoldersInterface)((Object)this._delegate)).setIncludeSystemFolders(include);
    }

    @Override
    public void updateFilteredValues(List newFilterValues) throws RemoteException {
        ((MutableFileFilterInterface)((Object)this._delegate)).updateFilteredValues(newFilterValues);
    }
}

