/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.rmi;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.remotefileselector2.AddFolderInterface;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import java.text.MessageFormat;
import java.util.HashMap;

public class AddFolderCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "AddFolderCommand.";
    public static final String RB_RFS_KEY = "RemoteFileSelector.";
    private String path;
    private BaseRemoteFileModelInterface model;
    private boolean contentsChanged;
    private HashMap eventInfo = new HashMap(2);
    private Object eventSource;
    private boolean renameFlag = false;
    private String newName;
    private String newFolderName;
    private RemoteFileMetadataInterface newFolderNode;
    private boolean addFailed = false;

    public AddFolderCommand() {
        this(null);
    }

    public AddFolderCommand(String name) {
        this(name, null);
    }

    public AddFolderCommand(String name, String actionClass) {
        super(name);
    }

    public void execute(Object o) throws IllegalArgumentException {
        if (this.getModel() instanceof AddFolderInterface) {
            String newFolderNameBase;
            this.setEventSource(this.model);
            AddFolderInterface rfsModel = (AddFolderInterface)((Object)this.getModel());
            this.newFolderName = newFolderNameBase = RB.getStringResource(RB_KEY, "newFolder.txt");
            boolean nameExistsAlready = true;
            int count = 0;
            while (nameExistsAlready) {
                boolean folderExists = rfsModel.isExistingSubFolder(this.path, this.newFolderName);
                if (folderExists) {
                    this.newFolderName = newFolderNameBase + "(" + new Integer(++count).toString() + ")";
                    nameExistsAlready = true;
                    continue;
                }
                nameExistsAlready = false;
            }
            this.newFolderNode = rfsModel.addFolder(this.path, this.newFolderName);
            if (this.newFolderNode == null) {
                this.addFailed = true;
                String msg = MessageFormat.format(RB.getStringResource(RB_RFS_KEY, "noWritePermissions.txt"), RemoteFileVisualsUtil.getDisplayPath(this.path));
                throw new IllegalArgumentException(msg);
            }
            this.addFailed = false;
            this.setNewName(this.newFolderName);
            this.contentsChanged = true;
            this.eventInfo.put("path", this.path);
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setModel(BaseRemoteFileModelInterface rfsModel) {
        this.model = rfsModel;
    }

    public BaseRemoteFileModelInterface getModel() {
        return this.model;
    }

    public void setFullyQualifiedLocation(String path) {
        this.path = path;
    }

    public String getFullyQualifiedLocation() {
        return this.path;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setRenameFlag(boolean flag) {
        this.renameFlag = flag;
    }

    public boolean isAddFailed() {
        return this.addFailed;
    }
}

