/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.informationservices;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.AuthorFilter;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.KeywordFilter;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.RB;
import com.sas.swing.models.remotefileselector2.RemoteFileSearchAttributes;
import com.sas.swing.models.remotefileselector2.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector2.informationservices.BaseInformationServicesModel;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadata;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SASScope(value="ALL")
public class InformationServicesSearchModel
extends BaseInformationServicesModel
implements RemoteFileSearchModelInterface {
    public static final String RB_KEY = "InformationServices.";
    public static final String MODIFIED_DATE = "MODIFIED_DATE";
    public static final String CREATED_DATE = "CREATED_DATE";
    private int filterRelation = 1;
    private String searchText;
    private String searchContext;
    private String startingPath;
    private boolean recursiveSearch;
    private int filterMatch;
    private String authorValue = RB.getStringResource("InformationServices.", "author.txt");
    private String keywordValue = RB.getStringResource("InformationServices.", "keywords.txt");
    private FilterInterface searchingFilter;

    public InformationServicesSearchModel(RepositoryInterface repository) {
        super(repository);
        this.filterMatch = -1;
        this.modelNeedsRefresh = true;
    }

    public InformationServicesSearchModel(UserContextInterface user) {
        super(user, false);
    }

    @SASScope
    public InformationServicesSearchModel(UserContextInterface user, boolean navigateUsingServer) {
        super(user, navigateUsingServer);
        this.filterMatch = -1;
        this.modelNeedsRefresh = true;
    }

    @SASScope
    public InformationServicesSearchModel(ServerInterface serverToSearch) {
        super(serverToSearch);
        this.filterMatch = -1;
        this.modelNeedsRefresh = true;
    }

    @Override
    public void loadFileInfo(RemoteFileSearchAttributes searchCriteria) throws IllegalArgumentException {
        FilterInterface searchFilter;
        this.infoList = new ArrayList();
        this.searchText = searchCriteria.getSearchText();
        this.searchContext = searchCriteria.getSearchContext();
        this.recursiveSearch = searchCriteria.getRecursive();
        this.startingPath = searchCriteria.getStartingPath();
        if (this.startingPath == null) {
            this.startingPath = "";
        }
        if ((searchFilter = this.getSearchFilter()) == null) {
            searchFilter = this.setupSearchFilter();
        }
        if (this.server != null) {
            this.loadSearchResultsForServer(searchFilter);
        } else {
            this.loadSearchResultsForRepository(searchFilter);
        }
        this.filterDataBasedOnDateCriteria(searchCriteria);
        this.fireTableDataChanged();
        this.modelNeedsRefresh = false;
    }

    protected void setSearchFilter(FilterInterface searchFilter) {
        this.searchingFilter = searchFilter;
    }

    protected FilterInterface getSearchFilter() {
        return this.searchingFilter;
    }

    private void filterDataBasedOnDateCriteria(RemoteFileSearchAttributes searchCriteria) {
        Date startDate = searchCriteria.getStartingDate();
        Date endDate = searchCriteria.getEndingDate();
        String dateType = searchCriteria.getDateSearchType();
        if (startDate != null && endDate != null) {
            Date dateTime = null;
            for (int i = this.infoList.size() - 1; i >= 0; --i) {
                InformationServicesFileMetadata element = (InformationServicesFileMetadata)this.infoList.get(i);
                dateTime = MODIFIED_DATE.equals(dateType) ? element.getModifiedDate() : element.getCreatedDate();
                if (!dateTime.before(startDate) && !dateTime.after(endDate)) continue;
                this.infoList.remove(i);
            }
        }
    }

    private FilterInterface setupSearchFilter() {
        int asterixIndex = this.searchText.indexOf(42);
        int textLength = this.searchText.length();
        if (asterixIndex >= 0) {
            if (asterixIndex == 0) {
                this.filterRelation = 1;
                this.searchText = this.searchText.substring(asterixIndex + 1);
                if (this.searchText.endsWith("*")) {
                    this.filterRelation = 1;
                    this.searchText = this.searchText.substring(0, textLength - 2);
                }
            } else if (asterixIndex == textLength - 1) {
                this.filterRelation = 2;
                this.searchText = this.searchText.substring(0, textLength - 1);
            }
        }
        if (this.filterMatch != -1) {
            this.filterRelation = this.filterMatch;
        }
        Filter searchFilter = null;
        if (this.searchText != null && !this.searchText.equals("") && !this.searchText.equals("*")) {
            if (this.searchContext.equals(this.keywordValue)) {
                searchFilter = new KeywordFilter();
                ((KeywordFilter)searchFilter).addKeyword(this.searchText);
            } else if (this.searchContext.equals(this.authorValue)) {
                searchFilter = new AuthorFilter();
                searchFilter.setName(this.searchText);
            } else {
                searchFilter = new Filter();
                FilterComponent filterComponent = new FilterComponent(this.searchContext, this.filterRelation, this.searchText);
                filterComponent.setAggregation(0);
                searchFilter.setFilterComponent(filterComponent);
            }
        } else {
            searchFilter = new Filter();
        }
        searchFilter.setOMRFlags(16);
        searchFilter.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n    <Timestamps/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
        if (this.server != null && this.startingPath == null || this.startingPath.trim().equals("") || this.startingPath.trim().equals(this.getRepositoryRootLocation())) {
            searchFilter.setOMRFlags(8192);
        }
        return searchFilter;
    }

    private void loadSearchResultsForRepository(FilterInterface searchFilter) {
        block13: {
            try {
                if (this.startingPath.trim().equals("")) {
                    this.recursiveSearch = true;
                    for (RepositoryInterface repository : this.reposList) {
                        List rootFolders = repository.getRootFolders();
                        for (FolderInterface folder : rootFolders) {
                            String key = folder.getEntityKey();
                            this.infoList.addAll(this.createMetadataItems(repository.browseFolderRecursive(key, searchFilter)));
                        }
                    }
                    break block13;
                }
                this.repository = this.getCurrentRepository(new PathUrl(this.startingPath));
                if (!this.getRepositoryRootLocation().equals(this.startingPath)) {
                    FolderInterface folder = this.getCurrentFolder(this.startingPath);
                    try {
                        String key = folder.getEntityKey();
                        if (this.recursiveSearch) {
                            List test = this.createMetadataItems(this.repository.browseFolderRecursive(key, searchFilter));
                            this.infoList.addAll(test);
                        } else {
                            this.currentPath = this.startingPath;
                            this.infoList.addAll(this.createMetadataItems(this.repository.browseFolder(key, searchFilter)));
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "pathDoesNotExist.txt"));
                    }
                }
                this.recursiveSearch = true;
                List rootFolders = this.repository.getRootFolders();
                for (FolderInterface folder : rootFolders) {
                    String key = folder.getEntityKey();
                    this.infoList.addAll(this.createMetadataItems(this.repository.browseFolderRecursive(key, searchFilter)));
                }
            }
            catch (ServiceException e) {
                LoggerRepository2.getLogger((String)InformationServicesSearchModel.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)InformationServicesSearchModel.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                LoggerRepository2.getLogger((String)InformationServicesSearchModel.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void loadSearchResultsForServer(FilterInterface searchFilter) {
        if (this.startingPath == null || this.startingPath.trim().equals("") || this.startingPath.trim().equals(this.getRepositoryRootLocation())) {
            this.recursiveSearch = true;
            try {
                RootFolderInterface rootFolder = this.server.getRootFolder();
                String rootEntityKey = rootFolder.getEntityKey();
                BrowseMetadataInterface rootFolderBrowseResults = this.server.browseFolderRecursive(rootEntityKey, searchFilter);
                this.infoList.addAll(this.createMetadataItems(rootFolderBrowseResults.getMembers()));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        } else {
            FolderInterface folder = this.getCurrentFolder(this.startingPath);
            BrowseMetadataInterface searchResults = null;
            try {
                String key = folder.getEntityKey();
                if (this.recursiveSearch) {
                    searchResults = this.server.browseFolderRecursive(key, searchFilter);
                    this.infoList.addAll(this.createMetadataItems(searchResults.getMembers()));
                } else {
                    this.currentPath = this.startingPath;
                    searchResults = this.server.browseFolder(key, searchFilter);
                    this.infoList.addAll(this.createMetadataItems(searchResults.getMembers()));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "pathDoesNotExist.txt"));
            }
        }
    }

    public void setFilterMatchType(int filterMatch) {
        this.filterMatch = filterMatch;
    }

    public int getFilterMatchType() {
        return this.filterMatch;
    }

    public boolean getRecursive() {
        return this.recursiveSearch;
    }
}

