/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.informationservices;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.util.ISUtility;
import com.sas.services.publish.EntryInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileServerModel;
import com.sas.swing.models.remotefileselector2.LocaleDataInterface;
import com.sas.swing.models.remotefileselector2.Location;
import com.sas.swing.models.remotefileselector2.LocationNode;
import com.sas.swing.models.remotefileselector2.RB;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector2.informationservices.IncludeSystemFoldersInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesAdapterSupport;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadata;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesSearchModel;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class BaseInformationServicesModel
extends BaseRemoteFileServerModel
implements IncludeSystemFoldersInterface,
LocaleDataInterface {
    public static final String RB_KEY = "RemoteFileSelector.";
    public static final String FOLDERTYPE_MYFOLDER = "My Folder";
    public static final String FOLDERTYPE_FOLDER = "Folder";
    public static final String FOLDERTYPE_ROOTFOLDER = "Root Folder";
    public static final String FOLDERTYPE_WEBDAVFOLDER = "WebDAV Folder";
    public static final String PACKAGE = "Package";
    public static final String SYSTEM_FOLDER_TYPE = "System";
    protected static final String CHOOSE_REPORT_METADATA_TEMPLATE = "<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n    <Timestamps/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>";
    protected static final String LOAD_ROOT_FOLDER_TEMPLATE = "<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>";
    protected RepositoryInterface repository;
    protected RepositoryInterface navigatingRepository;
    protected List reposList;
    private UserContextInterface user;
    protected boolean isPathUrl;
    private List columnIndices;
    private Locale locale;
    protected ServerInterface server;
    protected static final String SBIP = "SBIP://";
    protected static final String FOLDER_TYPE = "(Folder)";
    protected static final String FOLDER_TYPE_AND_SLASH = "/(Folder)";
    public static final String MY_FOLDER = "MY_FOLDER";
    protected static final String SLASH = "/";
    protected List webDavReposList;
    protected List webDavReposNames;
    protected List rootLocations;
    protected List locations;
    protected FolderInterface userHomeFolder;
    protected String userHomeFolderName;
    protected String[][] userHomeFolderInfo;
    protected FolderInterface rootFolder;
    protected String rootFolderName;
    protected String rootFolderLocation;
    protected String[][] rootFolderInfo;
    protected int locationsCurrentPathIndex;
    protected TypeDescriptorInterface typeDescriptor;
    protected CommonLoggerInterface log;
    protected boolean allowNewFoldersInRootFolder;
    private ArrayList rootLocationInfo;
    protected LocationNode myFolderNode;
    protected String myFolderName;
    private LocationNode sasFolderNode;
    private Location sasFolderLocation;
    private ArrayList webDavRootInfo;
    private boolean openPackage;
    protected Object myFolderLocationUrl;
    private List extensionfilterValues;
    protected boolean includeSystemFolders;
    protected RepositoryInterface repositoryForFilteringRootFolders;
    protected String folderLocalizedType;

    public BaseInformationServicesModel(RepositoryInterface repository) {
        this.setIncludeSystemFolders(true);
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this.repository = repository;
        this.reposList = new ArrayList(1);
        this.reposList.add(repository);
        this.createColumnIndices();
        try {
            this.user = repository.getUserContext();
            this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory(this.user.getSessionContext()));
        }
        catch (RemoteException e) {
            this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        }
    }

    public BaseInformationServicesModel(UserContextInterface user) {
        this(user, false);
    }

    @SASScope
    public BaseInformationServicesModel(UserContextInterface user, boolean navigateUsingServer) {
        block9: {
            this.user = user;
            try {
                this.reposList = user.getRepositories();
                int reposSize = this.reposList.size();
                this.webDavReposList = new ArrayList(reposSize);
                this.webDavReposNames = new ArrayList(reposSize);
                for (int i = 0; i < reposSize; ++i) {
                    RepositoryInterface repositoryToCheck = (RepositoryInterface)this.reposList.get(i);
                    if (!(repositoryToCheck instanceof DAVRepositoryInterface)) continue;
                    this.webDavReposList.add(repositoryToCheck);
                    this.webDavReposNames.add(repositoryToCheck.getISName());
                }
                if (navigateUsingServer) {
                    this.server = user.getAuthServer();
                    this.initialize();
                } else {
                    this.setupLogger();
                }
            }
            catch (RemoteException e) {
                if (this.log != null) {
                    this.log.debug(e.getMessage(), (Throwable)e);
                }
            }
            catch (ServiceException e) {
                if (this.log == null) break block9;
                this.log.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (this.reposList.size() < 1) {
            throw new IllegalArgumentException();
        }
        if (this.reposList.size() == 1) {
            this.repository = (RepositoryInterface)this.reposList.get(0);
        }
        this.createColumnIndices();
    }

    @SASScope
    public BaseInformationServicesModel(ServerInterface dataServer) {
        this.server = dataServer;
        this.createColumnIndices();
        this.initialize();
    }

    protected void initialize() {
        this.setupLogger();
        this.setAllowNewFoldersInRootFolder(true);
        this.setIncludeSystemFolders(true);
        this.myFolderNode = new LocationNode();
        this.myFolderNode.setLocation(MY_FOLDER);
        this.myFolderNode.setType(FOLDERTYPE_MYFOLDER);
        int numOfRootLocations = 1;
        if (this.webDavReposList != null) {
            numOfRootLocations = this.webDavReposList.size() + 1;
        }
        this.rootLocationInfo = new ArrayList(numOfRootLocations);
        this.sasFolderNode = new LocationNode();
        this.sasFolderNode.setLabel(RB.getStringResource(RB_KEY, "rootFolder.txt", this.getLocale()));
        this.sasFolderNode.setType(FOLDERTYPE_ROOTFOLDER);
        this.sasFolderLocation = new Location();
        ArrayList<LocationNode> sasFolderLocationNodes = new ArrayList<LocationNode>(1);
        sasFolderLocationNodes.add(this.sasFolderNode);
        this.sasFolderLocation.setLocationNodes(sasFolderLocationNodes);
        this.rootLocationInfo.add(this.sasFolderLocation);
        if (this.webDavReposList != null && this.webDavReposList.size() > 0) {
            int numOfWebDavs = this.webDavReposList.size();
            this.webDavRootInfo = new ArrayList(numOfWebDavs);
            for (int i = 0; i < numOfWebDavs; ++i) {
                LocationNode webDavNode = new LocationNode();
                String repositoryName = (String)this.webDavReposNames.get(i);
                webDavNode.setLabel(repositoryName);
                String webDAVRootLocation = SBIP + repositoryName + FOLDER_TYPE_AND_SLASH;
                webDavNode.setLocation(webDAVRootLocation);
                webDavNode.setType(FOLDERTYPE_WEBDAVFOLDER);
                ArrayList<LocationNode> webDavLocationNodes = new ArrayList<LocationNode>(1);
                webDavLocationNodes.add(webDavNode);
                Location webDavLocation = new Location();
                webDavLocation.setLocationNodes(webDavLocationNodes);
                this.rootLocationInfo.add(webDavLocation);
                this.webDavRootInfo.add(webDavLocation);
            }
        }
        this.folderLocalizedType = RB.getStringResource(RB_KEY, "folder.txt", this.getLocale());
    }

    private void updateLocalizedData(Locale locale) {
        this.folderLocalizedType = RB.getStringResource(RB_KEY, "folder.txt", this.getLocale());
        if (this.sasFolderNode != null) {
            this.sasFolderNode.setLabel(RB.getStringResource(RB_KEY, "rootFolder.txt", this.getLocale()));
        }
    }

    private void setupLogger() {
        try {
            if (this.server != null) {
                this.user = this.server.getUserContext();
                if (this.user != null) {
                    this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory(this.user.getSessionContext()));
                }
            } else {
                this.log = this.user != null ? LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory(this.user.getSessionContext())) : LoggerRepository2.getLogger((String)this.getClass().getName(), null);
            }
        }
        catch (RemoteException e) {
            this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
            this.log.debug(e.getMessage(), (Throwable)e);
        }
    }

    @SASScope
    public ServerInterface getServer() {
        return this.server;
    }

    @SASScope
    public void setRepositoryForServerFilter(RepositoryInterface repository) {
        this.repositoryForFilteringRootFolders = repository;
    }

    @SASScope
    public RepositoryInterface getRepositoryForServerFilter() {
        return this.repositoryForFilteringRootFolders;
    }

    @SASScope
    public void setOpenPackageOn(boolean open) {
        this.openPackage = open;
    }

    @SASScope
    public boolean isOpenPackageOn() {
        return this.openPackage;
    }

    private void createColumnIndices() {
        this.columnIndices = new ArrayList();
        this.columnIndices.add("NAME_COLUMN");
        this.columnIndices.add("AUTHOR_COLUMN");
        this.columnIndices.add("MODIFIED_DATE_COLUMN");
        this.columnIndices.add("CREATED_DATE_COLUMN");
        this.columnIndices.add("KEYWORDS_COLUMN");
        this.columnIndices.add("DESCRIPTION_COLUMN");
        this.columnIndices.add("PATH_COLUMN");
        this.columnIndices.add("ENTITY_KEY_COLUMN");
        this.columnIndices.add("IS_A_FOLDER_COLUMN");
        this.columnIndices.add("TYPE_COLUMN");
        this.columnIndices.add("FILE_METADATA_COLUMN");
    }

    public int getColumnIndex(String column) {
        return this.columnIndices.indexOf(column);
    }

    @Override
    public int getColumnCount() {
        return this.columnIndices.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnObject = null;
        if (this.infoList == null || this.infoList.size() == 0) {
            return returnObject;
        }
        InformationServicesFileMetadata item = (InformationServicesFileMetadata)this.infoList.get(rowIndex);
        if (!this.directoriesOnly || this.directoriesOnly && item.isFolder()) {
            switch (columnIndex) {
                case 0: {
                    returnObject = item.getName();
                    break;
                }
                case 1: {
                    returnObject = item.getOwner();
                    break;
                }
                case 2: {
                    returnObject = item.getModifiedDate();
                    break;
                }
                case 3: {
                    returnObject = item.getCreatedDate();
                    break;
                }
                case 4: {
                    returnObject = CollectionType.DEFAULT_INSTANCE_STRING.getDisplayString((Object)item.getKeywords(), this.locale);
                    break;
                }
                case 5: {
                    returnObject = item.getDescription();
                    break;
                }
                case 6: {
                    returnObject = item.getLocation();
                    break;
                }
                case 7: {
                    returnObject = item.getISEntityKey();
                    break;
                }
                case 8: {
                    returnObject = item.isFolder() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 9: {
                    returnObject = this.getType(item);
                    break;
                }
                case 10: {
                    returnObject = item;
                    break;
                }
            }
            this.readingFromCache = true;
        }
        return returnObject;
    }

    private Object getType(InformationServicesFileMetadata item) {
        String returnType = "";
        if (item.isFolder()) {
            returnType = this.folderLocalizedType;
        } else if (this.server != null) {
            try {
                this.typeDescriptor = this.server.getTypeDescriptor(item.getType());
                if (this.typeDescriptor != null) {
                    Locale modelLocale = this.getLocale();
                    returnType = modelLocale != null ? this.typeDescriptor.getType(modelLocale) : this.typeDescriptor.getType();
                } else {
                    String sType = item.getSmartType();
                    if (sType != null && sType.length() > 0) {
                        returnType = ISUtility.getLocalizedTypeName((String)sType, (Locale)this.getLocale());
                    }
                }
            }
            catch (ServiceException e) {
                returnType = "";
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                returnType = "";
                this.log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            String sType = item.getSmartType();
            if (sType != null && sType.length() > 0) {
                returnType = ISUtility.getLocalizedTypeName((String)sType, (Locale)this.getLocale());
            }
        }
        return returnType;
    }

    protected List createMetadataItems(List itemList) {
        ArrayList<InformationServicesFileMetadata> returnList = new ArrayList<InformationServicesFileMetadata>();
        for (BrowseMetadataInterface element : itemList) {
            String pt;
            if (this.isDirectoriesOnly() && !element.isAFolder() || (this.server != null || this.user != null) && element.isAFolder() && "Folder.SecuredData".equals(pt = (String)element.get("PublicType")) || !this.filterData(element)) continue;
            InformationServicesFileMetadata item = new InformationServicesFileMetadata(element, this.isOpenPackageOn());
            returnList.add(item);
            PathUrl pathUrl = null;
            if (this instanceof InformationServicesSearchModel && ((InformationServicesSearchModel)this).getRecursive()) {
                try {
                    if (this.user == null && this.server != null) {
                        this.user = this.server.getUserContext();
                    } else if (this.user == null && this.repository != null) {
                        this.user = this.repository.getUserContext();
                    }
                    if (this.user == null) continue;
                    pathUrl = ISUtility.getPathFromEntityKey((UserContextInterface)this.user, (String)item.getISEntityKey());
                    item.setLocation(pathUrl.toString());
                }
                catch (ServiceException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            String type = element.getSmartType();
            if ("Metadata".equals(type)) {
                type = element.getNativeType();
            }
            String location = this.buildNewSBipUrl(this.currentPath, element.getName(), type);
            item.setLocation(location);
        }
        return returnList;
    }

    protected List createMetadataPackageItems(EntryInterface[] packageItemList) {
        ArrayList<InformationServicesFileMetadata> returnList = new ArrayList<InformationServicesFileMetadata>();
        for (EntryInterface element : packageItemList) {
            if (!this.filterPackageData(element)) continue;
            InformationServicesFileMetadata item = new InformationServicesFileMetadata(element);
            StringBuffer pathUrlSB = null;
            int index = this.currentPath.indexOf("(");
            pathUrlSB = index > 0 ? new StringBuffer(this.currentPath.substring(0, index)) : new StringBuffer(this.currentPath);
            pathUrlSB.append(SLASH);
            pathUrlSB.append(item.getName());
            item.setLocation(pathUrlSB.toString());
            returnList.add(item);
        }
        return returnList;
    }

    protected boolean filterPackageData(EntryInterface element) {
        if (this.getFilterExtensionValues() != null) {
            String elementName = RemoteFileModelsUtil.getPackageName(element);
            return this.isValidFileExtension(elementName);
        }
        return true;
    }

    private boolean isValidFileExtension(String elementNameWithExtension) {
        boolean value = false;
        List extensionsToCheck = this.getFilterExtensionValues();
        if (extensionsToCheck != null && extensionsToCheck.size() > 0) {
            String fileName = elementNameWithExtension;
            int startIndexOfExtension = fileName.lastIndexOf(".") + 1;
            String fileExtension = "";
            if (startIndexOfExtension > 0) {
                fileExtension = fileName.substring(startIndexOfExtension);
            }
            if (extensionsToCheck.contains(fileExtension)) {
                value = true;
            }
        } else {
            value = true;
        }
        return value;
    }

    protected List createRepositoryNodeMetadataItems(List listOfRepositories) {
        ArrayList<InformationServicesFileMetadata> returnList = new ArrayList<InformationServicesFileMetadata>();
        for (RepositoryInterface element : listOfRepositories) {
            InformationServicesFileMetadata item = new InformationServicesFileMetadata(element);
            returnList.add(item);
            String topLevelName = this.getTopLevelNameForRepository(element);
            StringBuffer pathUrlSB = null;
            pathUrlSB = new StringBuffer();
            pathUrlSB.append(SBIP);
            pathUrlSB.append(topLevelName);
            pathUrlSB.append(FOLDER_TYPE_AND_SLASH);
            item.setLocation(pathUrlSB.toString());
        }
        return returnList;
    }

    protected List updateLocations(String path) {
        PathUrl cpPathUrl;
        String repositoryName;
        int nameInListIndex;
        String parentFolderLocation;
        if (this.getServer() == null) {
            return null;
        }
        if (this.sasFolderNode != null && this.sasFolderNode.getLocation() == null) {
            this.sasFolderNode.setLocation(this.rootFolderLocation);
        }
        if (path == null || "".equals(path.trim()) || path.equals(this.sasFolderLocation)) {
            this.locationsCurrentPathIndex = 0;
            return this.rootLocationInfo;
        }
        LocationNode basePathNode = null;
        LocationNode rootNodeOfCurrentPath = this.sasFolderNode;
        if (this.myFolderLocationUrl != null && (parentFolderLocation = this.myFolderLocationUrl.toString()) != null && RemoteFileModelsUtil.isLocationInParentFolder(parentFolderLocation, path)) {
            basePathNode = this.myFolderNode;
            this.myFolderNode.setLocation(parentFolderLocation);
        }
        Location webDavRootLocation = null;
        if (basePathNode == null && this.webDavReposList != null && this.webDavReposList.size() > 0 && (nameInListIndex = this.webDavReposNames.indexOf(repositoryName = (cpPathUrl = new PathUrl(path)).getRepository())) >= 0) {
            webDavRootLocation = (Location)this.webDavRootInfo.get(nameInListIndex);
            rootNodeOfCurrentPath = (LocationNode)webDavRootLocation.getLocationNodes().get(0);
        }
        Location currentLocationInfo = this.parseIntoFoldersAndLocations(path, rootNodeOfCurrentPath, basePathNode);
        if (this.locations == null) {
            this.locations = new ArrayList();
        } else {
            this.locations.clear();
        }
        int rootIndex = 0;
        if (rootNodeOfCurrentPath == this.sasFolderNode) {
            this.locations.add(currentLocationInfo);
            if (this.webDavReposList != null && this.webDavReposList.size() > 0 && this.webDavRootInfo != null) {
                this.locations.addAll(this.webDavRootInfo);
            }
            this.locationsCurrentPathIndex = currentLocationInfo.getLocationNodes().size() - 1;
        } else if (webDavRootLocation != null) {
            this.locations.add(this.sasFolderLocation);
            int numOfWebDavRoots = this.webDavRootInfo.size();
            for (int i = 0; i < numOfWebDavRoots; ++i) {
                Location webDavLocation = (Location)this.webDavRootInfo.get(i);
                if (webDavLocation == webDavRootLocation) {
                    this.locations.add(currentLocationInfo);
                    rootIndex = i;
                    continue;
                }
                this.locations.add(webDavLocation);
            }
            this.locationsCurrentPathIndex = currentLocationInfo.getLocationNodes().size() + rootIndex;
        }
        return this.locations;
    }

    @Override
    @SASScope
    public int getLocationsCurrentPathIndex() {
        return this.locationsCurrentPathIndex;
    }

    private Location parseIntoFoldersAndLocations(String path, LocationNode rootFolderNode, LocationNode baseFolderNode) {
        Location location = null;
        if (path == null) {
            ArrayList<LocationNode> folderLocationNodes = new ArrayList<LocationNode>(1);
            folderLocationNodes.add(rootFolderNode);
            location = new Location(folderLocationNodes);
            return location;
        }
        if (RemoteFileModelsUtil.isValidURL(path)) {
            location = new Location();
            int folderCount = 1;
            PathUrl locationUrl = new PathUrl(path);
            String absolutePath = locationUrl.getAbsolutePath();
            String pathToProcess = absolutePath = RemoteFileModelsUtil.normalizeLocation(absolutePath);
            if (baseFolderNode == null && pathToProcess.equals("")) {
                ArrayList<LocationNode> folderLocationNodes = new ArrayList<LocationNode>(1);
                folderLocationNodes.add(rootFolderNode);
                location = new Location(folderLocationNodes);
                return location;
            }
            String absoluteBasePath = null;
            LocationNode basePathNode = null;
            if (baseFolderNode != null) {
                String basePathLocation = baseFolderNode.getLocation();
                PathUrl basePathUrl = new PathUrl(basePathLocation);
                absoluteBasePath = basePathUrl.getAbsolutePath();
                if (absolutePath.startsWith(absoluteBasePath = RemoteFileModelsUtil.normalizeLocation(absoluteBasePath))) {
                    pathToProcess = absolutePath.substring(absoluteBasePath.length());
                    pathToProcess = RemoteFileModelsUtil.removeStartingPathDelimiter(pathToProcess, SLASH);
                    basePathNode = baseFolderNode;
                    ++folderCount;
                }
            }
            if (absolutePath != null && absolutePath.equals(absoluteBasePath)) {
                ArrayList<LocationNode> folderLocationNodes = new ArrayList<LocationNode>(2);
                folderLocationNodes.add(rootFolderNode);
                if (basePathNode != null) {
                    folderLocationNodes.add(basePathNode);
                }
                location.setLocationNodes(folderLocationNodes);
            } else {
                String[] folderNames = pathToProcess.split(SLASH);
                int numOfFolders = folderNames.length;
                ArrayList<LocationNode> folderLocationNodes = new ArrayList<LocationNode>(numOfFolders + folderCount);
                if (rootFolderNode != null) {
                    folderLocationNodes.add(rootFolderNode);
                } else {
                    LocationNode root = new LocationNode(this.getServerName(), "");
                    folderLocationNodes.add(root);
                }
                if (basePathNode != null) {
                    folderLocationNodes.add(basePathNode);
                }
                StringBuffer folderLocation = new StringBuffer(SBIP).append(locationUrl.getServer());
                if (basePathNode != null) {
                    folderLocation.append(SLASH).append(absoluteBasePath);
                }
                for (int i = 0; i < numOfFolders; ++i) {
                    folderLocation.append(SLASH).append(folderNames[i]);
                    String folderLocationUrl = folderLocation.toString() + FOLDER_TYPE;
                    LocationNode folderLocationNode = new LocationNode(folderNames[i], folderLocationUrl);
                    folderLocationNodes.add(folderLocationNode);
                }
                location.setLocationNodes(folderLocationNodes);
            }
        }
        return location;
    }

    protected boolean isValidURL(String SBIPUrl) {
        String validateString;
        boolean validUrl = false;
        if (SBIPUrl != null && !SBIPUrl.equals("") && (validateString = SBIPUrl.trim()).startsWith(SBIP)) {
            validUrl = true;
        }
        return validUrl;
    }

    public String[][] parseIntoFoldersAndLocations(String path) {
        String[] stringArray;
        String fileName;
        int count = 0;
        String location = path;
        String tempLocation = path;
        ArrayList<String> locationList = new ArrayList<String>();
        ArrayList<String> folderList = new ArrayList<String>();
        if (this.server == null && this instanceof RemoteFileSearchModelInterface && path != null && !path.trim().equals("")) {
            this.repository = this.getCurrentRepository(new PathUrl(path));
        } else if (this instanceof RemoteFileSearchModelInterface && path != null && !path.trim().equals("")) {
            this.navigatingRepository = RemoteFileModelsUtil.getRepositoryForPath(path, this.webDavReposList, this.webDavReposNames);
        }
        String repositoryRootLocation = this.getRepositoryRootLocation();
        while (!(path == null || path.trim().equals("") || path.equals(repositoryRootLocation) || count != 0 && (count <= 0 || location.equalsIgnoreCase((String)locationList.get(count - 1))) || SLASH.equals(fileName = (stringArray = this.splitPathAndFileName(path))[0]))) {
            locationList.add(location);
            folderList.add(fileName);
            ++count;
            path = stringArray[1];
            location = stringArray[1];
        }
        if (this.server != null) {
            locationList.add(repositoryRootLocation);
            if (this.navigatingRepository != null) {
                folderList.add(this.getServerName());
            } else {
                folderList.add(this.sasFolderNode.getLabel());
            }
        } else if (this.getRepositoryList().size() == 1 && tempLocation.trim().equals("") || !tempLocation.trim().equals("")) {
            locationList.add(this.getRepositoryRootLocation());
            folderList.add(this.getServerName());
        }
        if (this.server == null && this.getRepositoryList().size() > 1) {
            locationList.add(" ");
            folderList.add(RB.getStringResource(RB_KEY, "infoservice.txt", this.getLocale()));
        }
        String[][] returnArray = new String[locationList.size()][2];
        for (int i = 0; i < locationList.size(); ++i) {
            returnArray[i][0] = (String)locationList.get(i);
            returnArray[i][1] = (String)folderList.get(i);
        }
        return returnArray;
    }

    public String[] splitPathAndFileName(String path) {
        String shortName = null;
        String returnedPath = null;
        String[] stringArray = new String[2];
        if (path.trim().equals("")) {
            return stringArray;
        }
        PathUrl pathUrl = new PathUrl(path);
        shortName = pathUrl.getName();
        String pathPart = pathUrl.getPath();
        String rootTree = pathUrl.getRootTree();
        if (pathPart != null) {
            returnedPath = rootTree != null ? new StringBuffer(SBIP).append(pathUrl.getRepository()).append(SLASH).append(rootTree).append(SLASH).append(pathPart).append(FOLDER_TYPE).toString() : new StringBuffer(SBIP).append(pathUrl.getRepository()).append(SLASH).append(pathPart).append(FOLDER_TYPE).toString();
        } else if (pathPart == null && shortName != null && shortName != rootTree) {
            returnedPath = rootTree != null ? SBIP + pathUrl.getRepository() + SLASH + rootTree + FOLDER_TYPE : new StringBuffer(SBIP).append(pathUrl.getRepository()).append(FOLDER_TYPE_AND_SLASH).toString();
        } else {
            shortName = pathUrl.getRootTree();
            returnedPath = new StringBuffer(SBIP).append(pathUrl.getRepository()).append(FOLDER_TYPE_AND_SLASH).toString();
        }
        stringArray[0] = shortName;
        stringArray[1] = returnedPath;
        return stringArray;
    }

    public String combinePathAndFileName(String path, String name) {
        path = RemoteFileModelsUtil.removeEndingPathDelimiter(path, SLASH);
        String fullName = null;
        fullName = path.trim().equals("") ? name : (path.endsWith(SLASH) ? path + name : path + SLASH + name);
        return fullName;
    }

    @SASScope
    public String buildNewSBipUrl(String pathUrlString, String name, String itemType) {
        return InformationServicesAdapterSupport.buildNewSBipUrl(this, pathUrlString, name, itemType);
    }

    @SASScope
    public String buildNewSBipUrl(String serverName, String rootTreeName, String path, String folderName, String name, String type) {
        return InformationServicesAdapterSupport.buildNewSBipUrl(serverName, rootTreeName, path, folderName, name, type);
    }

    public String getRepositoryRootLocation() {
        return SBIP + this.getServerName() + FOLDER_TYPE_AND_SLASH;
    }

    public RepositoryInterface getCurrentRepository(PathUrl pathUrl) {
        try {
            String reposName = pathUrl.getRepository();
            if (this.repository == null || !this.repository.getISName().equals(reposName)) {
                for (RepositoryInterface tempRepository : this.reposList) {
                    if (!tempRepository.getISName().equals(reposName)) continue;
                    return tempRepository;
                }
            }
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return this.repository;
    }

    public boolean isUpwardPathRestricted() {
        String[] testArray = this.splitPathAndFileName(this.currentPath);
        if ((testArray[0] == null || testArray[0].trim().equals("")) && (testArray[1] == null || testArray[1].trim().equals(""))) {
            return true;
        }
        if (this.getRepositoryRootLocation().equals(this.currentPath) && (this.getRepositoryList() != null && this.getRepositoryList().size() == 1 || this.navigatingRepository != null)) {
            return true;
        }
        return this.currentPath != null && (this.currentPath.equals(this.getRootLocation()) || this.currentPath.equals(this.rootFolderLocation));
    }

    public String getServerName() {
        String name = null;
        try {
            name = this.server != null ? (this.navigatingRepository != null ? this.navigatingRepository.getISName() : this.server.getName()) : (this.repository != null ? this.getTopLevelNameForRepository(this.repository) : RB.getStringResource(RB_KEY, "infoservice.txt", this.getLocale()));
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    private String getTopLevelNameForRepository(RepositoryInterface repository) {
        String name = null;
        try {
            if (repository != null) {
                name = repository.getISName();
            }
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    public String getDirectoryPath(String path) {
        if (path.trim().equals("")) {
            return path;
        }
        PathUrl pathUrl = new PathUrl(path);
        String returnPath = pathUrl.getPath();
        if ((returnPath == null || returnPath.trim().equals("")) && (returnPath = pathUrl.getName()) == null) {
            returnPath = pathUrl.getRootTree();
        }
        return returnPath;
    }

    protected FolderInterface getCurrentFolder(String path) {
        return (FolderInterface)InformationServicesAdapterSupport.getMetadataObjectByPath(this.getUserContext(), path);
    }

    @SASScope
    public void setFilterExtensionValues(List filterValues) {
        this.extensionfilterValues = filterValues;
    }

    @SASScope
    public List getFilterExtensionValues() {
        return this.extensionfilterValues;
    }

    protected boolean filterData(BrowseMetadataInterface item) {
        boolean value = false;
        if (this.filterValues != null) {
            if (this.filterValues.get(0).equals("*")) {
                value = true;
            } else if (!item.isAFolder()) {
                String type;
                if (item.getNativeType().equals("Transformation") && this.filterValues.contains(type = (String)item.get("TransformRole"))) {
                    value = true;
                }
                if (!value && this.filterValues.contains(type = item.getSmartType())) {
                    value = true;
                }
                if (!value && this.filterValues.contains(type = (String)item.get("PublicType"))) {
                    value = true;
                }
            } else {
                value = true;
            }
        } else {
            value = this.getFilterExtensionValues() != null ? (!item.isAFolder() ? (PACKAGE.equalsIgnoreCase(item.getSmartType()) && this.isOpenPackageOn() && !"binaryPackage".equalsIgnoreCase(item.getNativeType()) ? true : this.isValidFileExtension(item.getName())) : true) : true;
        }
        return value;
    }

    public void setRepository(RepositoryInterface repository) {
        this.repository = repository;
        this.modelNeedsRefresh = true;
    }

    public RepositoryInterface getRepository() {
        return this.repository;
    }

    public List getRepositoryList() {
        return this.reposList;
    }

    public void setUserContext(UserContextInterface user) {
        this.user = user;
        this.modelNeedsRefresh = true;
    }

    public UserContextInterface getUserContext() {
        return this.user;
    }

    @Override
    public void setLocale(Locale loc) {
        this.locale = loc;
        this.updateLocalizedData(loc);
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    @SASScope
    public String getColumnName(int columnIndex) {
        String columnName = "";
        if (columnIndex >= 0 && columnIndex < this.columnIndices.size()) {
            return (String)this.columnIndices.get(columnIndex);
        }
        return columnName;
    }

    @SASScope
    public String getFolderFullyQualifiedLocation(String folderName) {
        return InformationServicesAdapterSupport.getFolderFullyQualifiedLocation(this, folderName);
    }

    @Override
    @SASScope
    public List getLocations() {
        return this.updateLocations(this.getLocation());
    }

    @Override
    @SASScope
    public void setLocation(String path) {
        String currentLocation = this.getLocation();
        if (currentLocation == path) {
            return;
        }
        if (currentLocation != null && currentLocation.equals(path)) {
            return;
        }
        String validLocation = null;
        if (MY_FOLDER.equalsIgnoreCase(path)) {
            validLocation = MY_FOLDER;
        } else {
            RepositoryInterface testWebDav = null;
            if (path != null && (testWebDav = RemoteFileModelsUtil.getRepositoryForPath(path, this.webDavReposList, this.webDavReposNames)) != null) {
                validLocation = path;
            }
            if (testWebDav == null && (validLocation = InformationServicesAdapterSupport.buildFullyQualifiedPath(this, path)) == null) {
                validLocation = this.getLocation();
                if (validLocation == null) {
                    validLocation = this.rootLocation != null ? this.rootLocation : "";
                }
                this.log.warn(MessageFormat.format(RB.getStringResource(RB_KEY, "unknownLocationMessage.txt"), path));
                this.spcs.firePropertyChange("invalidLocation", null, path);
            }
        }
        super.setLocation(validLocation);
    }

    @SASScope
    public boolean isRootFolderAtSASFolders() {
        if (this.currentPath == null || this.currentPath.length() == 0) {
            return false;
        }
        RepositoryInterface repository = RemoteFileModelsUtil.getRepositoryForPath(this.currentPath, this.webDavReposList, this.webDavReposNames);
        return repository == null;
    }

    @SASScope
    public void setAllowNewFoldersInRootFolder(boolean allow) {
        this.allowNewFoldersInRootFolder = allow;
    }

    @SASScope
    public boolean isAllowNewFoldersInRootFolder() {
        return this.allowNewFoldersInRootFolder;
    }

    @Override
    @SASScope
    public void setIncludeSystemFolders(boolean include) {
        this.includeSystemFolders = include;
    }

    @Override
    @SASScope
    public boolean isIncludeSystemFolders() {
        return this.includeSystemFolders;
    }

    @Override
    @SASScope
    public String getValidNameStatus(String fileName) {
        try {
            if (fileName != null && this.isRootFolderAtSASFolders()) {
                Names.validateOMRObjectName((String)Names.trimName((String)fileName), (boolean)true);
            }
        }
        catch (IllegalArgumentException ie) {
            return ie.getMessage();
        }
        return null;
    }

    @Override
    @SASScope
    public String getValidName(String fileName) {
        if (fileName != null && this.isRootFolderAtSASFolders()) {
            return Names.trimName((String)fileName);
        }
        return super.getValidName(fileName);
    }
}

