/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.ifileservice;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IWorkspace;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileServerModel;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadata;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseIFileServiceModel
extends BaseRemoteFileServerModel {
    public static final int MVS_OS_FILESYSTEM = 1;
    public static final int MVS_HFS_FILESYSTEM = 2;
    public static final int ROOT_MODE = 10;
    public static final int USER_MODE = 11;
    public static final int PATH_MODE = 99;
    protected IWorkspace workspace;
    private List columnIndices;
    private int mode;
    private String userHomeDirectory;

    public BaseIFileServiceModel(IWorkspace workspace, int fileSystem) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
        IFileServiceAdapterSupport.setWorkspaceOptions(workspace, fileSystem);
        this.rootLocation = null;
        this.createColumnIndices();
    }

    private void createColumnIndices() {
        this.columnIndices = new ArrayList();
        this.columnIndices.add("NAME_COLUMN");
        this.columnIndices.add("SIZE_COLUMN");
        this.columnIndices.add("MODIFIED_DATE_COLUMN");
        this.columnIndices.add("ENGINE_COLUMN");
        this.columnIndices.add("IS_A_FOLDER_COLUMN");
    }

    public int getColumnIndex(String column) {
        return this.columnIndices.indexOf(column);
    }

    @Override
    public int getColumnCount() {
        return this.columnIndices.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnObject = null;
        if (this.infoList == null || this.infoList.size() == 0) {
            return returnObject;
        }
        IFileServiceFileMetadata item = (IFileServiceFileMetadata)this.infoList.get(rowIndex);
        if (!this.directoriesOnly || this.directoriesOnly && item.isFolder()) {
            switch (columnIndex) {
                case 0: {
                    returnObject = item.getName();
                    break;
                }
                case 1: {
                    returnObject = new Integer(item.getSize());
                    break;
                }
                case 2: {
                    returnObject = item.getModifiedDate();
                    break;
                }
                case 3: {
                    returnObject = item.getEngine();
                    break;
                }
                case 4: {
                    returnObject = item.isFolder() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
            }
        }
        return returnObject;
    }

    public String[][] parseIntoFoldersAndLocations(String path) {
        return IFileServiceAdapterSupport.parseIntoFoldersAndLocations(this.workspace, this.workspace.FileService(), this.getRootLocation(), this.getBasePath(), path);
    }

    @Override
    public String getRootLocation() {
        if (this.rootLocation == null) {
            this.rootLocation = this.rootLocation = IFileServiceAdapterSupport.getModePath((IFileService)this.workspace.FileService(), (ListFilesMode)ListFilesMode.ListFilesModeRoot).value;
        }
        return this.rootLocation;
    }

    public String[] splitPathAndFileName(String path) {
        return IFileServiceAdapterSupport.splitPathAndFileName(this.workspace, this.workspace.FileService(), this.getRootLocation(), this.getBasePath(), path);
    }

    public boolean isUpwardPathRestricted() {
        String currentLocation = this.getLocation();
        return currentLocation == null || currentLocation.equals(this.getRootLocation()) || currentLocation.equals(this.getBasePath());
    }

    public String getServerName() {
        return IFileServiceAdapterSupport.getServerNameFromWorkspace(this.workspace);
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(IWorkspace workspace, int fileSystem) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
        if (fileSystem != 2 && fileSystem != 1) {
            fileSystem = 1;
        }
        IFileServiceAdapterSupport.setWorkspaceOptions(workspace, fileSystem);
        this.rootLocation = null;
        this.setRefreshNeeded(true);
    }

    public void setWorkspace(IWorkspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
        IFileServiceAdapterSupport.setWorkspaceOptions(workspace, 1);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setLocation(int listingMode) {
        if (listingMode != 10 && listingMode != 11) {
            this.setMode(11);
        } else {
            this.setMode(listingMode);
        }
        this.setRefreshNeeded(true);
    }

    @Override
    public void setLocation(String path) {
        this.setMode(99);
        super.setLocation(path);
    }

    @Override
    public String getLocation() {
        if (10 == this.getMode()) {
            return this.getRootLocation();
        }
        if (11 == this.getMode()) {
            return this.getUserHomeDirectory();
        }
        return this.currentPath;
    }

    public String getLocation(int mode) {
        if (10 == mode) {
            return this.getRootLocation();
        }
        if (11 == mode) {
            return this.getUserHomeDirectory();
        }
        return null;
    }

    protected String getUserHomeDirectory() {
        if (this.userHomeDirectory == null) {
            this.userHomeDirectory = IFileServiceAdapterSupport.getModePath((IFileService)this.workspace.FileService(), (ListFilesMode)ListFilesMode.ListFilesModeUser).value;
        }
        return this.userHomeDirectory;
    }

    public String getDefaultLocation() {
        String location = this.getLocation();
        if (location == null) {
            return this.getUserHomeDirectory();
        }
        if ("".equals(location)) {
            return this.getRootLocation();
        }
        return location;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnName = "";
        if (columnIndex >= 0 && columnIndex < this.columnIndices.size()) {
            return (String)this.columnIndices.get(columnIndex);
        }
        return columnName;
    }

    public String buildFullyQualifiedLocation(String location, String entryFile) {
        return IFileServiceAdapterSupport.combinePathAndFileName(this.workspace.FileService(), location, entryFile);
    }
}

